/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.eclipse.jst.jsf.common.internal.strategy.SimpleStrategyComposite;
import org.eclipse.jst.jsf.core.tests.strategy.ConcatStrategy;
import org.junit.Before;
import org.junit.Test;

public class StrategyCompositeTests {
    private ConcatStrategy _concatStrategyAAAbbb;
    private ConcatStrategy _concatStrategyAAAccc;
    private ConcatStrategy _concatStrategyBBBccc;
    private ConcatStrategy _concatStrategyCCCaaa;
    private List<ConcatStrategy> _strategies;

    @Before
    public void setup() throws Exception {
        this._concatStrategyAAAbbb = new ConcatStrategy(Pattern.compile("^AAA.*"), "bbb", "AAA");
        this._concatStrategyAAAccc = new ConcatStrategy(Pattern.compile("^AAA.*"), "ccc", "AAA");
        this._concatStrategyBBBccc = new ConcatStrategy(Pattern.compile("^BBB.*"), "ccc", "BBB");
        this._concatStrategyCCCaaa = new ConcatStrategy(Pattern.compile("^CCC.*"), "aaa", "CCC");
        this._strategies = new ArrayList<ConcatStrategy>();
        this._strategies.add(this._concatStrategyAAAbbb);
        this._strategies.add(this._concatStrategyAAAccc);
        this._strategies.add(this._concatStrategyBBBccc);
        this._strategies.add(this._concatStrategyCCCaaa);
    }

    @Test
    public void testDefaultPerform() {
        SimpleStrategyComposite testComposite = new SimpleStrategyComposite(this._strategies);
        Assert.assertEquals((String)"AAAbbb", (String)((String)testComposite.perform((Object)"AAA")));
        Assert.assertEquals((String)"AAAqqqbbb", (String)((String)testComposite.perform((Object)"AAAqqq")));
        Assert.assertEquals((String)"BBBtccc", (String)((String)testComposite.perform((Object)"BBBt")));
        Assert.assertEquals((String)"CCC_____aaa", (String)((String)testComposite.perform((Object)"CCC_____")));
    }
}

