/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxb.core.tests;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlSchema;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxb.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class AddAnnotationToPackageTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "package-info.java";
    }

    public String getClassContents() {
        return "package com.example;\n";
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair locationVP = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"location", (String)"uri:someSchema");
        MemberValuePair namespaceVP = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"namespace", (String)"uri:testNS");
        memberValuePairs.add(locationVP);
        memberValuePairs.add(namespaceVP);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)XmlSchema.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToPackage() {
        try {
            AddAnnotationToPackageTest.assertNotNull((Object)this.annotation);
            AddAnnotationToPackageTest.assertEquals((String)XmlSchema.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IPackageDeclaration myPackage = this.source.getPackageDeclaration(this.getPackageName());
            AddAnnotationToPackageTest.assertNotNull((Object)myPackage);
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)myPackage, (Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)myPackage, (String)XmlSchema.class.getCanonicalName()));
            AddAnnotationToPackageTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToPackageTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)myPackage, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            AddAnnotationToPackageTest.assertTrue((boolean)this.source.getImport(XmlSchema.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            AddAnnotationToPackageTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

