/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;

public class AbstractArchiveTest
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public AbstractArchiveTest(String name) {
        super(name);
    }

    public Set getAllUnresolvedProxies(EObject root) {
        HashSet visited = new HashSet();
        HashSet proxies = new HashSet();
        this.getAllUnresolvedProxies(root, proxies, visited, root.eResource());
        return proxies;
    }

    public void getAllUnresolvedProxies(EObject object, Set proxies, Set visitedObjects, Resource originalResource) {
        if (visitedObjects.contains(object)) {
            return;
        }
        visitedObjects.add(object);
        if (object.eResource() != originalResource) {
            if (((InternalEObject)object).eIsProxy()) {
                proxies.add(object);
            }
            return;
        }
        EList refs = object.eClass().getEAllReferences();
        if (refs != null) {
            Iterator ir = refs.iterator();
            while (ir.hasNext()) {
                EReference r = (EReference)ir.next();
                Object value = object.eGet((EStructuralFeature)r);
                if (value == null) continue;
                if (r.isMany()) {
                    Collection c = (Collection)value;
                    Iterator ir2 = c.iterator();
                    while (ir2.hasNext()) {
                        EObject refObj = (EObject)ir2.next();
                        this.getAllUnresolvedProxies(refObj, proxies, visitedObjects, originalResource);
                    }
                    continue;
                }
                this.getAllUnresolvedProxies((EObject)value, proxies, visitedObjects, originalResource);
            }
        }
    }

    public static CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public void verifyProxies(EObject root) {
        Set proxies = this.getAllUnresolvedProxies(root);
        AbstractArchiveTest.assertTrue((String)"Some proxies could not be resolved", (boolean)proxies.isEmpty());
    }
}

