/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.util;

import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDiff {
    private PrintStream out = System.out;
    private boolean DIFF_ELEMENT_NODE_ONLY = false;

    public boolean diff(String file1, String file2) throws ParserConfigurationException, SAXException, IOException {
        return this.diff(file1, file2, false);
    }

    public boolean diff(String file1, String file2, boolean elementOnly) throws ParserConfigurationException, SAXException, IOException {
        Document doc1 = this.getDocument(file1);
        Document doc2 = this.getDocument(file2);
        this.DIFF_ELEMENT_NODE_ONLY = elementOnly;
        return this.diff(doc1, doc2);
    }

    public boolean diff(Document doc1, Document doc2) {
        Element root1 = doc1.getDocumentElement();
        Element root2 = doc2.getDocumentElement();
        return this.compareNodes(root1, root2);
    }

    private Document getDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(uri);
        return doc;
    }

    private boolean compareNodes(Node node1, Node node2) {
        if (this.DIFF_ELEMENT_NODE_ONLY) {
            this.filterNonElementNodes(node1);
            this.filterNonElementNodes(node2);
        }
        if (node1.getNodeType() != node2.getNodeType() || node1.getNodeName() != node2.getNodeName()) {
            this.println("Node type or node name is different:");
            this.println("Node 1: " + node1.getNodeName());
            this.println("Node 2: " + node2.getNodeName());
            return false;
        }
        if (!this.compareAttributes(node1, node2)) {
            return false;
        }
        NodeList nodeList1 = node1.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList1.getLength() != nodeList2.getLength()) {
            this.println("The number of children is different:");
            this.println("Node 1: " + node1.getNodeName());
            this.println("Node 2: " + node2.getNodeName());
            return false;
        }
        boolean result = true;
        int length = nodeList1.getLength();
        int i = 0;
        while (i < length) {
            result = this.compareNodes(nodeList1.item(i), nodeList2.item(i));
            if (!result) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void filterNonElementNodes(Node node) {
        Node firstChild = node.getFirstChild();
        while (firstChild.getNodeType() != 1) {
            node.removeChild(firstChild);
            firstChild = node.getFirstChild();
        }
        Node sibling = firstChild.getNextSibling();
        Node deleteMe = null;
        while (sibling != null) {
            if (sibling.getNodeType() == 1) continue;
            deleteMe = sibling;
            sibling = sibling.getNextSibling();
            node.removeChild(deleteMe);
        }
    }

    private boolean compareAttributes(Node node1, Node node2) {
        NamedNodeMap nodeMap1 = node1.getAttributes();
        NamedNodeMap nodeMap2 = node2.getAttributes();
        if (nodeMap1 == null || nodeMap2 == null) {
            return nodeMap1 == null && nodeMap2 == null;
        }
        if (nodeMap1.getLength() != nodeMap2.getLength()) {
            this.println("The number of attributes is different:");
            this.println("Node 1: " + node1.getNodeName());
            this.println("Node 2: " + node2.getNodeName());
            return false;
        }
        Node attrNode1 = null;
        Node attrNode2 = null;
        int length = nodeMap1.getLength();
        int i = 0;
        while (i < length) {
            attrNode1 = nodeMap1.item(i);
            attrNode2 = nodeMap2.getNamedItem(attrNode1.getNodeName());
            if (attrNode2 == null) {
                this.println("The attribute is not found in Node 2: " + attrNode1.getNodeName());
                this.println("Node 1: " + node1.getNodeName());
                this.println("Node 2: " + node2.getNodeName());
                return false;
            }
            if (!attrNode1.getNodeValue().equals(attrNode2.getNodeValue())) {
                this.println("The attribute values are different:");
                this.println("Node 1: " + node1.getNodeName() + "," + attrNode1.getNodeValue());
                this.println("Node 2: " + node2.getNodeName() + "," + attrNode2.getNodeValue());
                return false;
            }
            ++i;
        }
        return true;
    }

    private void println(String s) {
        this.out.println(s);
    }
}

