/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntimeTargetHandler;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class GenericServerClasspathRuntimeHandlerTest
extends TestCase {
    private static final String SERVER_ROOT = "/dev/java/appservers/JOnAS-4.1.4";
    private static final String SERVER_DEF_NAME = "JOnAS 4.x";
    private IRuntime fRuntime;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        IRuntimeType type = ServerCore.findRuntimeType((String)"org.eclipse.jst.server.generic.runtime.jonas4");
        IRuntimeWorkingCopy wc = type.createRuntime("testRuntime", null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericServerRuntime delegate = (GenericServerRuntime)wc.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("mappernames", "");
        props.put("classPathVariableName", "JONAS");
        props.put("serverAddress", "127.0.0.1");
        props.put("jonasBase", SERVER_ROOT);
        props.put("jonasRoot", SERVER_ROOT);
        props.put("protocols", "jrmp");
        props.put("port", "9000");
        delegate.setServerInstanceProperties(props);
        delegate.setServerDefinitionId(SERVER_DEF_NAME);
        wc.save(false, null);
        this.fRuntime = wc.getOriginal();
    }

    public GenericServerClasspathRuntimeHandlerTest(String name) {
        super(name);
    }

    public void testResolveClasspathContainer() {
        GenericServerRuntimeTargetHandler handler = new GenericServerRuntimeTargetHandler();
        IClasspathEntry[] entries = handler.resolveClasspathContainer(this.fRuntime, null);
        GenericServerClasspathRuntimeHandlerTest.assertNotNull((String)"Failed to resolve classpath entries", (Object)entries);
        int i = 0;
        while (i < entries.length) {
            GenericServerClasspathRuntimeHandlerTest.assertTrue((String)"the resolved classpath entry does not start with classpath prefix", (boolean)new Path(SERVER_ROOT).isPrefixOf(entries[i].getPath()));
            ++i;
        }
    }
}

