/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.util;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;

public class WSCustomAdapterFactory
implements IAdapterFactory {
    private static final Class[] types = new Class[]{IFile.class, String.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ServletLink && (adapterType == IFile.class || adapterType == String.class)) {
            System.out.println("getAdapter on " + adaptableObject.toString());
            ServletLink beanLink = (ServletLink)adaptableObject;
            IFile wsdlFile = this.getWSDLFile(beanLink);
            System.out.println("wsdlFile = " + wsdlFile);
            if (adapterType == IFile.class) {
                return wsdlFile;
            }
            if (adapterType == String.class) {
                URI wsdlUri = wsdlFile.getLocationURI();
                String wsdlFileString = null;
                if (wsdlUri != null) {
                    wsdlFileString = wsdlUri.toString();
                    System.out.println("wsdlFileString = " + wsdlFileString);
                }
                return wsdlFileString;
            }
            return null;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return types;
    }

    private IFile getWSDLFile(ServiceImplBean bean) {
        EObject eObject = bean.eContainer();
        if (eObject == null) {
            return null;
        }
        if ((eObject = eObject.eContainer()) instanceof WebServiceDescription) {
            WebServiceDescription wsd = (WebServiceDescription)eObject;
            IProject project = ProjectUtilities.getProject((EObject)wsd);
            IPath path = J2EEUtils.getWebContentPath((IProject)project);
            path = path.append(wsd.getWsdlFile());
            return ResourceUtils.getWorkspaceRoot().getFile(path);
        }
        return null;
    }

    private IFile getWSDLFile(ServletLink link) {
        EObject eObject = link.eContainer();
        if (eObject instanceof ServiceImplBean) {
            return this.getWSDLFile((ServiceImplBean)eObject);
        }
        return null;
    }
}

