/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.tests.data;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.wst.ws.tests.plugin.TestsPlugin;

public class LocatorWorkspaceSetup
extends TestCase {
    public static String PROJECT1_NAME = "Project1";
    public static String FOLDER1_NAME = "Folder1";
    public static String FOLDER2_NAME = "Folder2";
    public static String FOLDER3_NAME = "Folder3";
    public static String PROJECT2_NAME = "Project2";
    public static String FOLDER4_NAME = "Folder4";
    public static String FOLDER5_NAME = "Folder5";
    public static String PROJECT3_NAME = "Project3";
    public static String WSDLFILE_ONE = "one.wsdl";
    public static String WSDLFILE_TWO = "two.wsdl";
    public static String WSDLFILE_THREE = "three.wsdl";
    public static String WSDLFILE_FOUR = "four.wsdl";
    public static String WSDLFILE_FIVE = "five.wsdl";
    public static String WSDLFILE_SIX = "six.wsdl";
    public static String XMLFILE_ONE = "one.XML";
    public static String ACTUAL_TESTFILEPATH = "data/locator/test.wsdl";
    private IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.ws.tests.data.LocatorWorkspaceSetup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "LocatorWorkspaceSetup");
    }

    protected void closeIntro() {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart introPart = introManager.getIntro();
        if (introPart != null) {
            introManager.closeIntro(introPart);
        }
    }

    protected IProject createSimpleProject(String name) throws CoreException {
        IProject simpleProject = this.root.getProject(name);
        simpleProject.create(null);
        simpleProject.open(null);
        return simpleProject;
    }

    protected IFolder createFolder(IContainer parent, String folderName) throws CoreException {
        IFolder folder1 = parent.getFolder((IPath)new Path(folderName));
        folder1.create(false, true, null);
        return folder1;
    }

    protected void copyFile(IContainer project, String source, String dest) throws IOException, CoreException {
        IFile file = project.getFile((IPath)new Path(dest));
        file.create(TestsPlugin.getDefault().getBundle().getEntry(source).openStream(), true, null);
        Assert.assertTrue((boolean)file.exists());
    }

    protected void joinAutoBuild() throws CoreException {
        boolean interrupted = true;
        while (interrupted) {
            try {
                Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
    }

    public void testSetup() throws Exception {
        try {
            System.out.println("------ locator data setup starting");
            this.closeIntro();
            IProject project1 = this.createSimpleProject(PROJECT1_NAME);
            IFolder folder1 = this.createFolder((IContainer)project1, FOLDER1_NAME);
            this.copyFile((IContainer)folder1, ACTUAL_TESTFILEPATH, WSDLFILE_TWO);
            IFolder folder2 = this.createFolder((IContainer)folder1, FOLDER2_NAME);
            this.copyFile((IContainer)folder2, ACTUAL_TESTFILEPATH, WSDLFILE_ONE);
            IFolder folder3 = this.createFolder((IContainer)project1, FOLDER3_NAME);
            this.copyFile((IContainer)folder3, ACTUAL_TESTFILEPATH, WSDLFILE_THREE);
            this.copyFile((IContainer)folder3, ACTUAL_TESTFILEPATH, WSDLFILE_FOUR);
            IProject project2 = this.createSimpleProject(PROJECT2_NAME);
            this.copyFile((IContainer)project2, ACTUAL_TESTFILEPATH, WSDLFILE_FIVE);
            this.createFolder((IContainer)project2, FOLDER4_NAME);
            IFolder folder5 = this.createFolder((IContainer)project2, FOLDER5_NAME);
            this.copyFile((IContainer)folder5, ACTUAL_TESTFILEPATH, WSDLFILE_SIX);
            IProject project3 = this.createSimpleProject(PROJECT3_NAME);
            this.copyFile((IContainer)project3, ACTUAL_TESTFILEPATH, XMLFILE_ONE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("------ locator data setup complete");
    }

    protected class DataResourceVisitor
    implements IResourceVisitor {
        protected DataResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IProject || resource instanceof IFolder) {
                System.out.println("visiting " + resource.getName());
            } else if (resource instanceof IFile) {
                System.out.println("found file " + resource.getName());
            }
            return true;
        }
    }
}

