/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPJavaValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "bug_87351";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_87351", "/bug_87351");
        }
        JSPJavaValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testValidatingFragments() throws Exception {
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_87351/WebContent/ihaveerrors.jspf";
        helper.setURI(filePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        String validate = JSPFContentProperties.getProperty((String)"validateFragments", (IResource)file, (boolean)false);
        JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)Boolean.toString(true));
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        if (validate != null) {
            JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)validate);
        }
        JSPJavaValidatorTest.assertTrue((String)"jspf was not validated when it should have been", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    public void testNoValidatingFragments() throws Exception {
        JSPValidator validator = new JSPValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_87351/ihaveerrors.jspf";
        helper.setURI(filePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        String validate = JSPFContentProperties.getProperty((String)"validateFragments", (IResource)file, (boolean)false);
        JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)Boolean.toString(false));
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        if (validate != null) {
            JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)validate);
        }
        JSPJavaValidatorTest.assertTrue((String)"jspf was validated when it should not have been", (boolean)reporter.getMessages().isEmpty());
    }
}

