package oracle.adfdemo.view.faces;
import java.io.IOException;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import oracle.adf.view.faces.event.PollEvent;
import oracle.adf.view.faces.model.DefaultBoundedRangeModel;

/**
 * Bean for progress steps demos.
 *
 * @version $Name:  $ ($Revision: 1.5 $) $Date: 2004/07/30 20:41:51 $
 */
public class ProgressStepsBean extends ProgressBean 
{
  public List getProgressSteps()
  {
    return _PROGRESS_STEPS;
  }
  
  public void onPoll(PollEvent event)
  {
    if ( __model != null && (__model.getMaximum() <= __model.getValue()) )
    {
      //pu: This means the background task is complete.
      //  End the task and navigate off to a different page.
      endProcess();
      try
      {
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        ec.redirect("../components/progressEnd.jspx?taskStatus=completed");
      }
      catch(IOException ioe)
      {
        _LOG.log(Level.WARNING, "Could not redirect", ioe);
      }
      catch (RuntimeException re)
      {
        _LOG.log(Level.SEVERE, "Could not redirect", re);
        throw re;
      }
    }
  }
  
  protected void prepare()
  {
    __model = new DefaultBoundedRangeModel(-1, 6);
    //pu: simulate asynchronous model updates on a different thread
    __processThread = new ProcessThread(1500, 1);
    __processThread.start();
  }
  
  static private List _PROGRESS_STEPS;
  
  static private final Logger _LOG = Logger.getLogger(
    ProgressStepsBean.class.getName());
  
  static
  {
    _PROGRESS_STEPS = new ArrayList();
    _PROGRESS_STEPS.add("Checking for latest version");
    _PROGRESS_STEPS.add("Checking available disk space");
    _PROGRESS_STEPS.add("Copying files");
    _PROGRESS_STEPS.add("Analyzing dependencies");
    _PROGRESS_STEPS.add("Install in progress");
    _PROGRESS_STEPS.add("Building icons and shortcuts");
  }

}