package oracle.adfdemo.view.faces.change;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import oracle.adf.view.faces.change.AddChildComponentChange;
import oracle.adf.view.faces.change.AddChildDocumentChange;
import oracle.adf.view.faces.change.SetFacetChildComponentChange;
import oracle.adf.view.faces.change.AttributeComponentChange;
import oracle.adf.view.faces.change.ChangeManager;
import oracle.adf.view.faces.change.ComponentChange;
import oracle.adf.view.faces.change.DocumentChange;
import oracle.adf.view.faces.change.RemoveChildComponentChange;
import oracle.adf.view.faces.change.RemoveFacetComponentChange;
import oracle.adf.view.faces.change.ReorderChildrenComponentChange;
import oracle.adf.view.faces.component.core.nav.CoreCommandButton;

import oracle.adf.view.faces.component.core.output.CoreObjectImage;
import oracle.adf.view.faces.component.core.output.CoreOutputFormatted;
import oracle.adf.view.faces.context.AdfFacesContext;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

import org.xml.sax.SAXException;
import java.io.ByteArrayInputStream;

/**
 * Managed bean for Change persistence demos.
 * @version $Name:  $ ($Revision: 1.2 $) $Date: 2004/07/30 00:40:29 $
 */
public class ChangeBean 
{
  /**
   * Picks up an image randomly from a list and changes it on the objectImage.
   */
  public void modifyObjectImage(ActionEvent event)
  {
    UIComponent uic = event.getComponent().findComponent("oi1");
    String source = "/components/images/" + _images[_getRandIndex()];
    uic.getAttributes().put("source", source);
    _addAttributeChange(uic, "source", source);
  }
  
  /**
   * Picks up a string randomly from a list and changes the text attribute value
   *  of the panelBox.
   */
  public void modifyPanelBox(ActionEvent event)
  {
    UIComponent uic = event.getComponent().findComponent("pb1");
    String text = _texts[_getRandIndex()];
    uic.getAttributes().put("text", text);
    _addAttributeChange(uic, "text", text);
  }

  /**
   * Modifies the sortable property of the column.
   */
  public void modifyColumn(ActionEvent event)
  {
    //=-=pu: 'uic1' gets null, while 'uic' gets valid component, maybe a bug ?.
    //UIComponent uic1 = event.getComponent().findComponent("c1");
    UIComponent uic2 = event.getComponent().findComponent("t1");
    UIComponent uic = uic2.findComponent("c1");
    
    Object sortableAttrib = uic.getAttributes().get("sortable");
    Boolean isSortable = 
      (sortableAttrib == null)? Boolean.TRUE:(Boolean)sortableAttrib;
    Boolean newSortableValue = 
      Boolean.TRUE.equals(isSortable)? Boolean.FALSE:Boolean.TRUE;
    uic.getAttributes().put("sortable", newSortableValue);
    _addAttributeChange(uic, "sortable", newSortableValue);
  }

  /**
   * Picks up a string randomly from a list and changes the label attribute 
   *  value of the inputText.
   */
  public void modifyInputText(ActionEvent event)
  {
    UIComponent uic = event.getComponent().findComponent("it1");
    String label = _labels[_getRandIndex()];
    uic.getAttributes().put("label", label);
    _addAttributeChange(uic, "label", label);
  }

  /**
   * Appends an objectImage child to the panelGroup in the underlying JSP document
   */
  public void appendChildToDocument(ActionEvent event)
  {
    UIComponent eventSource = event.getComponent();
    UIComponent uic = eventSource.findComponent("pg1");
    
    // only allow the image to be added once
    if (_findChildById(uic,"oi3") != null)
      return;
      
    FacesContext fc = FacesContext.getCurrentInstance();

    DocumentFragment imageFragment = _createDocumentFragment(_IMAGE_MARK_UP);
    
    if (imageFragment != null)
    {
      DocumentChange change = new AddChildDocumentChange(imageFragment);
      
      ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
      
      apm.addDocumentChange(fc, uic, change);
    }
  }

  /**
   * Appends an objectImage child to the panelGroup.
   */
  public void appendChild(ActionEvent event)
  {
    UIComponent eventSource = event.getComponent();
    UIComponent uic = eventSource.findComponent("pg1");
    if (_findChildById(uic,"oi2") != null)
      return;
    FacesContext fc = FacesContext.getCurrentInstance();
    
    CoreObjectImage newChild = 
      (CoreObjectImage) fc.getApplication().createComponent(
        "oracle.adf.CoreObjectImage");
    newChild.setId("oi2");
    newChild.setHeight(100);
    newChild.setWidth(120);
    newChild.setSource(
      "http://homepage.mac.com/awiner/.Pictures/WindyHill/PaleSwallowtail.jpg");  
    uic.getChildren().add(newChild);

    ComponentChange aca = new AddChildComponentChange(newChild);

    ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
    apm.addComponentChange(fc, uic, aca);
  }

  /**
   * Adds a 'brandingAppContextual' facet  to the panelGroup.
   */
  public void addFacet(ActionEvent event)
  {
    UIComponent eventSource = event.getComponent();
    UIComponent uic = eventSource.findComponent("pp1");
    FacesContext fc = FacesContext.getCurrentInstance();
    CoreOutputFormatted newFacetComponent = 
      (CoreOutputFormatted) fc.getApplication().createComponent(
        "oracle.adf.CoreOutputFormatted");
    newFacetComponent.setStyleUsage("inContextBranding" );
    newFacetComponent.setValue(
      "Customer Company - Menlo Park");
    uic.getFacets().put("brandingAppContextual", newFacetComponent);

    ComponentChange afa = new SetFacetChildComponentChange("brandingAppContextual", newFacetComponent);

    ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
    apm.addComponentChange(fc, uic, afa);
  }

  /**
   * Reverses the order of children of the panelGroup.
   */
  public void reorderChildren(ActionEvent event)
  {
    UIComponent uic = event.getComponent().findComponent("pg1");
    int numChildren = uic.getChildCount();
    if (numChildren == 0)
      return;
    List children = uic.getChildren();
    Collections.reverse(children);
    List reorderedChildIdList = new ArrayList();
    for (int i=0; i<children.size(); i++)
    {
      UIComponent child = (UIComponent) children.get(i);
      reorderedChildIdList.add(child.getId());
    }
    
    ComponentChange ra = new ReorderChildrenComponentChange(reorderedChildIdList);

    FacesContext fc = FacesContext.getCurrentInstance();
    ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
    apm.addComponentChange(fc, uic, ra);
  }

  /**
   * Removes a pair of children, based on some characteristic of the
   *  event source.
   */
  public void removeChildren(ActionEvent event)
  {
    UIComponent eventSource = event.getComponent();
    UIComponent uic = eventSource.findComponent("pg1");
    int numChildren = uic.getChildCount();
    if (numChildren == 0)
      return;
    String eventSourceId = eventSource.getId();    
    if (eventSourceId.equals("cb2"))
    {
      _removeChild(uic, "sic1");
      _removeChild(uic, "cc1");
    }
    else if (eventSourceId.equals("cb3"))
    {
      _removeChild(uic, "cd1");
      _removeChild(uic, "sid1");
    }
  }

  /**
   * Removes one or more facets, based on some characteristic of the
   *  event source.
   */
  public void removeFacets(ActionEvent event)
  {
    CoreCommandButton eventSource = (CoreCommandButton) event.getComponent();
    //pu: Anything until ":" in the button text represents the facet name/s
    String facetNameFromButtonText = (eventSource.getText().split(":"))[0];
    //pu: In case of the button that removes multiple facets, this is again 
    //  delimited by "_"
    String removableFacetNames[] = facetNameFromButtonText.split("_");
    
    //pu: Get the CorePanelPage components that has all the removable facets
    UIComponent uic = eventSource.findComponent("pp1");
    Map facets = uic.getFacets();
    if (facets.keySet().size() == 0)
      return;

    for (int i=0; i<removableFacetNames.length; i++)
    {
      if (facets.get(removableFacetNames[i]) != null)
      {
        facets.remove(removableFacetNames[i]);
        ComponentChange rfa = new RemoveFacetComponentChange(removableFacetNames[i]);
        FacesContext fc = FacesContext.getCurrentInstance();
        ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
        apm.addComponentChange(fc, uic, rfa);
      }
    }
  }

  /**
   * Creates a DocumentFragment containing the parsed content
   * @param markUp JSP Document markup
   * @return DocumentFragment containing the parsed content
   */
  private static DocumentFragment _createDocumentFragment(
    String markUp)
  {
    // prepend XML declaration
    markUp = "<?xml version = '1.0' encoding = 'ISO-8859-1'?>" + markUp;

    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    factory.setNamespaceAware(true);
    factory.setValidating(false);

    DocumentBuilder builder;
    
    try
    {
      builder = factory.newDocumentBuilder();
    }
    catch (ParserConfigurationException pce)
    {
      _LOG.log(Level.WARNING, "Unable to get XML Parser:", pce);
      
      return null;
    }
    
    try
    {
      // use a version explicitly with ISO-8859-1 instead
      byte[] markupBytes = markUp.getBytes();
      Document newDoc = builder.parse(new ByteArrayInputStream(markupBytes));
    
      DocumentFragment fragment = newDoc.createDocumentFragment();
      
      // add the document's root element to the fragment
      fragment.appendChild(newDoc.getDocumentElement());
      
      return fragment;
    }
    catch (SAXException se)
    {      
      _LOG.log(Level.WARNING, "Unable to parse markup:" + markUp, se);
      
      return null;
    }
    catch (IOException ioe)
    {
      _LOG.log(Level.WARNING, "IO Problem with markup:" + markUp, ioe);

      return null;
    }
  }

  private static void _removeChild(UIComponent uic, String removableChildId)
  {
    UIComponent removableChild = _findChildById(uic, removableChildId);
    if (removableChild != null)
    {
      List children = uic.getChildren();
      children.remove(removableChild);
      ComponentChange rca = new RemoveChildComponentChange(removableChildId);
      FacesContext fc = FacesContext.getCurrentInstance();
      ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
      apm.addComponentChange(fc, uic, rca);
    }
  }
  
  private static UIComponent _findChildById(UIComponent uic, String id)
  {
    int numChildren = uic.getChildCount();
    if (numChildren == 0)
      return null;
    List children = uic.getChildren();
    UIComponent child = null;
    for (int i=0; i<numChildren; i++)
    {
      child = (UIComponent) children.get(i);
      if (id.equals(child.getId()))
        return child;
    }
    return null;
  }

  private static void _addAttributeChange(
    UIComponent uic, 
    String attribName, 
    Object attribValue
    )
  {
    FacesContext fc = FacesContext.getCurrentInstance();
    ChangeManager apm = AdfFacesContext.getCurrentInstance().getChangeManager();
    ComponentChange aa = new AttributeComponentChange(attribName, attribValue);
    apm.addComponentChange(fc, uic, aa);
  }
  
  private static int _getRandIndex()
  {
    return (int) (Math.random()*10)/2;
  }
  
  private static final String _images[] = 
    {"cobrand.gif","corporateBrand.gif","largeAd.gif","mediumAd.gif","new.gif"};
  private static final String _labels[] = 
    {"Label One","Label Two","Label Three","Label Four","Label Five"};
  private static final String _texts[] = 
    {"PanelBoxText One",
     "PanelBoxText Two",
     "PanelBoxText Three",
     "PanelBoxText Four",
     "PanelBoxText Five"};

  // markup to use for image added to document
  private static final String _IMAGE_MARK_UP = 
   "<af:objectImage id='oi3' height='100' width='120' " +
   "source='http://homepage.mac.com/awiner/.Pictures/WindyHill/PaleSwallowtail.jpg' " +
   "xmlns:af='http://xmlns.oracle.com/adf/faces/EA17'/>";

  static private final Logger _LOG = Logger.getLogger(ChangeBean.class.getName());
}