/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmBaseColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.core.resource.orm.AbstractXmlColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseColumn<T extends AbstractXmlColumn>
extends AbstractOrmNamedColumn<T>
implements OrmBaseColumn {
    protected String specifiedTable;
    protected String defaultTable;
    protected Boolean specifiedUnique;
    protected Boolean specifiedNullable;
    protected Boolean specifiedInsertable;
    protected Boolean specifiedUpdatable;

    protected AbstractOrmBaseColumn(XmlContextNode parent, OrmBaseColumn.Owner owner) {
        super(parent, owner);
    }

    public void initializeFrom(BaseColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedTable(oldColumn.getSpecifiedTable());
        this.setSpecifiedUnique(oldColumn.getSpecifiedUnique());
        this.setSpecifiedNullable(oldColumn.getSpecifiedNullable());
        this.setSpecifiedInsertable(oldColumn.getSpecifiedInsertable());
        this.setSpecifiedUpdatable(oldColumn.getSpecifiedUpdatable());
    }

    @Override
    public OrmBaseColumn.Owner getOwner() {
        return (OrmBaseColumn.Owner)super.getOwner();
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        if (this.valuesAreDifferent(oldSpecifiedTable, newSpecifiedTable)) {
            if (this.getResourceColumn() != null) {
                ((AbstractXmlColumn)this.getResourceColumn()).setTable(newSpecifiedTable);
                this.removeResourceColumnIfFeaturesUnset();
            } else if (newSpecifiedTable != null) {
                this.addResourceColumn();
                ((AbstractXmlColumn)this.getResourceColumn()).setTable(newSpecifiedTable);
            }
        }
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        this.firePropertyChanged("defaultTable", oldDefaultTable, newDefaultTable);
    }

    @Override
    public boolean tableNameIsInvalid() {
        return this.getOwner().tableNameIsInvalid(this.getTable());
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getOwner().candidateTableNames();
    }

    @Override
    public boolean isUnique() {
        return this.getSpecifiedUnique() == null ? this.isDefaultUnique() : this.getSpecifiedUnique().booleanValue();
    }

    @Override
    public boolean isDefaultUnique() {
        return false;
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        if (this.valuesAreDifferent(oldSpecifiedUnique, newSpecifiedUnique)) {
            if (this.getResourceColumn() != null) {
                ((AbstractXmlColumn)this.getResourceColumn()).setUnique(newSpecifiedUnique);
                if (((AbstractXmlColumn)this.getResourceColumn()).isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedUnique != null) {
                this.addResourceColumn();
                ((AbstractXmlColumn)this.getResourceColumn()).setUnique(newSpecifiedUnique);
            }
        }
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    protected void setSpecifiedUnique_(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    @Override
    public boolean isNullable() {
        return this.getSpecifiedNullable() == null ? this.isDefaultNullable() : this.getSpecifiedNullable().booleanValue();
    }

    @Override
    public boolean isDefaultNullable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        if (this.valuesAreDifferent(oldSpecifiedNullable, newSpecifiedNullable)) {
            if (this.getResourceColumn() != null) {
                ((AbstractXmlColumn)this.getResourceColumn()).setNullable(newSpecifiedNullable);
                this.removeResourceColumnIfFeaturesUnset();
            } else if (newSpecifiedNullable != null) {
                this.addResourceColumn();
                ((AbstractXmlColumn)this.getResourceColumn()).setNullable(newSpecifiedNullable);
            }
        }
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    protected void setSpecifiedNullable_(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    @Override
    public boolean isInsertable() {
        return this.getSpecifiedInsertable() == null ? this.isDefaultInsertable() : this.getSpecifiedInsertable().booleanValue();
    }

    @Override
    public boolean isDefaultInsertable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        if (this.valuesAreDifferent(oldSpecifiedInsertable, newSpecifiedInsertable)) {
            if (this.getResourceColumn() != null) {
                ((AbstractXmlColumn)this.getResourceColumn()).setInsertable(newSpecifiedInsertable);
                this.removeResourceColumnIfFeaturesUnset();
            } else if (newSpecifiedInsertable != null) {
                this.addResourceColumn();
                ((AbstractXmlColumn)this.getResourceColumn()).setInsertable(newSpecifiedInsertable);
            }
        }
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    protected void setSpecifiedInsertable_(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    @Override
    public boolean isUpdatable() {
        return this.getSpecifiedUpdatable() == null ? this.isDefaultUpdatable() : this.getSpecifiedUpdatable().booleanValue();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        if (this.valuesAreDifferent(oldSpecifiedUpdatable, newSpecifiedUpdatable)) {
            if (this.getResourceColumn() != null) {
                ((AbstractXmlColumn)this.getResourceColumn()).setUpdatable(newSpecifiedUpdatable);
                if (((AbstractXmlColumn)this.getResourceColumn()).isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedUpdatable != null) {
                this.addResourceColumn();
                ((AbstractXmlColumn)this.getResourceColumn()).setUpdatable(newSpecifiedUpdatable);
            }
        }
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    protected void setSpecifiedUpdatable_(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    @Override
    public TextRange getTableTextRange() {
        TextRange textRange;
        if (this.getResourceColumn() != null && (textRange = ((AbstractXmlColumn)this.getResourceColumn()).getTableTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    @Override
    protected void initialize(T column) {
        super.initialize(column);
        this.specifiedTable = this.getResourceTable(column);
        this.defaultTable = this.buildDefaultTableName();
        this.specifiedNullable = this.getResourceNullable(column);
        this.specifiedUpdatable = this.getResourceUpdatable(column);
        this.specifiedUnique = this.getResourceUnique(column);
        this.specifiedInsertable = this.getResourceInsertable(column);
    }

    @Override
    protected void update(T column) {
        super.update(column);
        this.setSpecifiedTable_(this.getResourceTable(column));
        this.setDefaultTable(this.buildDefaultTableName());
        this.setSpecifiedNullable_(this.getResourceNullable(column));
        this.setSpecifiedUpdatable_(this.getResourceUpdatable(column));
        this.setSpecifiedUnique_(this.getResourceUnique(column));
        this.setSpecifiedInsertable_(this.getResourceInsertable(column));
    }

    protected String getResourceTable(T column) {
        return column == null ? null : ((AbstractXmlColumn)column).getTable();
    }

    protected Boolean getResourceNullable(T column) {
        return column == null ? null : ((AbstractXmlColumn)column).getNullable();
    }

    protected Boolean getResourceUpdatable(T column) {
        return column == null ? null : ((AbstractXmlColumn)column).getUpdatable();
    }

    protected Boolean getResourceUnique(T column) {
        return column == null ? null : ((AbstractXmlColumn)column).getUnique();
    }

    protected Boolean getResourceInsertable(T column) {
        return column == null ? null : ((AbstractXmlColumn)column).getInsertable();
    }

    protected String buildDefaultTableName() {
        return this.getOwner().getDefaultTableName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (this.validateTable(messages)) {
            super.validate(messages, reporter);
        }
    }

    protected boolean validateTable(List<IMessage> messages) {
        if (this.tableNameIsInvalid()) {
            messages.add(this.getOwner().buildTableNotValidMessage(this, this.getTableTextRange()));
            return false;
        }
        return true;
    }
}

