/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.JoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.JoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinTableJoiningStrategy
extends AbstractOrmXmlContextNode
implements OrmJoinTableJoiningStrategy {
    protected OrmJoinTable joinTable;

    protected AbstractOrmJoinTableJoiningStrategy(JoinTableEnabledRelationshipReference parent) {
        super(parent);
    }

    @Override
    public void initializeFrom(JoinTableJoiningStrategy oldStrategy) {
        JoinTable oldJoinTable = oldStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.getJoinTable().setSpecifiedCatalog(oldJoinTable.getSpecifiedCatalog());
            this.getJoinTable().setSpecifiedSchema(oldJoinTable.getSpecifiedSchema());
            this.getJoinTable().setSpecifiedName(oldJoinTable.getSpecifiedName());
        }
    }

    @Override
    public JoinTableEnabledRelationshipReference getParent() {
        return (JoinTableEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JoinTableEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public String getTableName() {
        return this.getJoinTable().getName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getJoinTable().getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !StringTools.stringsAreEqual((String)this.getTableName(), (String)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationshipReference());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            XmlJoinTable resourceJoinTable = OrmFactory.eINSTANCE.createXmlJoinTable();
            this.joinTable = this.getXmlContextNodeFactory().buildOrmJoinTable(this, resourceJoinTable);
            this.setResourceJoinTable(resourceJoinTable);
            this.firePropertyChanged("joinTable", null, this.joinTable);
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            OrmJoinTable oldJoinTable = this.joinTable;
            this.joinTable = null;
            this.removeResourceJoinTable();
            this.firePropertyChanged("joinTable", oldJoinTable, null);
        }
    }

    protected abstract void setResourceJoinTable(XmlJoinTable var1);

    @Override
    public OrmJoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public OrmJoinTable addJoinTable() {
        this.addStrategy();
        return this.joinTable;
    }

    protected void setJoinTable_(OrmJoinTable newJoinTable) {
        OrmJoinTable oldJoinTable = this.joinTable;
        this.joinTable = newJoinTable;
        this.firePropertyChanged("joinTable", oldJoinTable, newJoinTable);
    }

    @Override
    public XmlJoinTable addResourceJoinTable() {
        XmlJoinTable resourceJoinTable = OrmFactory.eINSTANCE.createXmlJoinTable();
        this.setResourceJoinTable(resourceJoinTable);
        return resourceJoinTable;
    }

    protected boolean mayHaveJoinTable() {
        return this.getResourceJoinTable() != null || this.getRelationshipReference().mayHaveDefaultJoinTable();
    }

    protected void initialize() {
        if (this.mayHaveJoinTable()) {
            this.joinTable = this.getXmlContextNodeFactory().buildOrmJoinTable(this, this.getResourceJoinTable());
        }
    }

    @Override
    public void update() {
        if (this.mayHaveJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable_(this.getXmlContextNodeFactory().buildOrmJoinTable(this, this.getResourceJoinTable()));
            }
            this.joinTable.update();
        } else if (this.joinTable != null) {
            this.setJoinTable_(null);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter);
        }
    }
}

