/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualCascadeType;
import org.eclipse.jpt.core.internal.context.orm.VirtualMapKey;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlJoinTable;
import org.eclipse.jpt.core.resource.orm.CascadeType;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.utility.TextRange;

public class VirtualXmlManyToMany
extends XmlManyToMany {
    protected OrmTypeMapping ormTypeMapping;
    protected final JavaManyToManyMapping javaAttributeMapping;
    protected final VirtualXmlAttributeMapping virtualXmlAttributeMapping;
    protected final VirtualCascadeType virtualCascadeType;
    protected final MapKey mapKey;

    public VirtualXmlManyToMany(OrmTypeMapping ormTypeMapping, JavaManyToManyMapping javaManyToManyMapping) {
        this.ormTypeMapping = ormTypeMapping;
        this.javaAttributeMapping = javaManyToManyMapping;
        this.virtualXmlAttributeMapping = new VirtualXmlAttributeMapping(ormTypeMapping, javaManyToManyMapping);
        this.virtualCascadeType = new VirtualCascadeType(javaManyToManyMapping.getCascade(), this.isOrmMetadataComplete());
        this.mapKey = new VirtualMapKey(javaManyToManyMapping);
    }

    protected boolean isOrmMetadataComplete() {
        return this.ormTypeMapping.isMetadataComplete();
    }

    public String getMappingKey() {
        return this.virtualXmlAttributeMapping.getMappingKey();
    }

    public String getName() {
        return this.virtualXmlAttributeMapping.getName();
    }

    public void setName(String newName) {
        this.virtualXmlAttributeMapping.setName(newName);
    }

    public TextRange getNameTextRange() {
        return this.virtualXmlAttributeMapping.getNameTextRange();
    }

    public org.eclipse.jpt.core.resource.orm.FetchType getFetch() {
        if (this.isOrmMetadataComplete()) {
            return FetchType.toOrmResourceModel(this.javaAttributeMapping.getDefaultFetch());
        }
        return FetchType.toOrmResourceModel(this.javaAttributeMapping.getFetch());
    }

    public void setFetch(org.eclipse.jpt.core.resource.orm.FetchType newFetch) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public CascadeType getCascade() {
        return this.virtualCascadeType;
    }

    public void setCascade(CascadeType value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public XmlJoinTable getJoinTable() {
        if (this.javaAttributeMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable() != null) {
            return new VirtualXmlJoinTable(this.ormTypeMapping, this.javaAttributeMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable());
        }
        return null;
    }

    public void setJoinTable(XmlJoinTable value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public String getTargetEntity() {
        if (this.isOrmMetadataComplete()) {
            return this.javaAttributeMapping.getDefaultTargetEntity();
        }
        return this.javaAttributeMapping.getFullyQualifiedTargetEntity();
    }

    public void setTargetEntity(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public String getMappedBy() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        return this.javaAttributeMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute();
    }

    public void setMappedBy(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public MapKey getMapKey() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        if (this.javaAttributeMapping.isNoMapKey()) {
            return null;
        }
        return this.mapKey;
    }

    public void setMapKey(MapKey value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public String getOrderBy() {
        if (this.isOrmMetadataComplete()) {
            return null;
        }
        return this.javaAttributeMapping.getOrderable().getSpecifiedOrderBy();
    }

    public void setOrderBy(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    public TextRange getMappedByTextRange() {
        return null;
    }

    public TextRange getTargetEntityTextRange() {
        return null;
    }
}

