/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaCascade;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaCascadeTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    public JavaCascadeTests(String name) {
        super(name);
    }

    public void testUpdateCascadeAll() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isAll());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeAll());
        annotation.setCascadeAll(true);
        this.getJpaProject().update();
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeAll());
        JavaCascadeTests.assertTrue((boolean)cascade.isAll());
        annotation.setCascadeAll(false);
        this.getJpaProject().update();
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeAll());
        JavaCascadeTests.assertFalse((boolean)cascade.isAll());
    }

    public void testModifyCascadeAll() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isAll());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeAll());
        cascade.setAll(true);
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeAll());
        JavaCascadeTests.assertTrue((boolean)cascade.isAll());
        cascade.setAll(false);
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeAll());
        JavaCascadeTests.assertFalse((boolean)cascade.isAll());
    }

    public void testUpdateCascadePersist() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isPersist());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadePersist());
        annotation.setCascadePersist(true);
        this.getJpaProject().update();
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadePersist());
        JavaCascadeTests.assertTrue((boolean)cascade.isPersist());
        annotation.setCascadePersist(false);
        this.getJpaProject().update();
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadePersist());
        JavaCascadeTests.assertFalse((boolean)cascade.isPersist());
    }

    public void testModifyCascadePersist() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isPersist());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadePersist());
        cascade.setPersist(true);
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadePersist());
        JavaCascadeTests.assertTrue((boolean)cascade.isPersist());
        cascade.setPersist(false);
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadePersist());
        JavaCascadeTests.assertFalse((boolean)cascade.isPersist());
    }

    public void testUpdateCascadeMerge() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isMerge());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeMerge());
        annotation.setCascadeMerge(true);
        this.getJpaProject().update();
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeMerge());
        JavaCascadeTests.assertTrue((boolean)cascade.isMerge());
        annotation.setCascadeMerge(false);
        this.getJpaProject().update();
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeMerge());
        JavaCascadeTests.assertFalse((boolean)cascade.isMerge());
    }

    public void testModifyCascadeMerge() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isMerge());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeMerge());
        cascade.setMerge(true);
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeMerge());
        JavaCascadeTests.assertTrue((boolean)cascade.isMerge());
        cascade.setMerge(false);
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeMerge());
        JavaCascadeTests.assertFalse((boolean)cascade.isMerge());
    }

    public void testUpdateCascadeRemove() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isRemove());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRemove());
        annotation.setCascadeRemove(true);
        this.getJpaProject().update();
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeRemove());
        JavaCascadeTests.assertTrue((boolean)cascade.isRemove());
        annotation.setCascadeRemove(false);
        this.getJpaProject().update();
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRemove());
        JavaCascadeTests.assertFalse((boolean)cascade.isRemove());
    }

    public void testModifyCascadeRemove() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isRemove());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRemove());
        cascade.setRemove(true);
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeRemove());
        JavaCascadeTests.assertTrue((boolean)cascade.isRemove());
        cascade.setRemove(false);
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRemove());
        JavaCascadeTests.assertFalse((boolean)cascade.isRemove());
    }

    public void testUpdateCascadeRefresh() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isRefresh());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRefresh());
        annotation.setCascadeRefresh(true);
        this.getJpaProject().update();
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeRefresh());
        JavaCascadeTests.assertTrue((boolean)cascade.isRefresh());
        annotation.setCascadeRefresh(false);
        this.getJpaProject().update();
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRefresh());
        JavaCascadeTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testModifyCascadeRefresh() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping mapping = (JavaOneToOneMapping)persistentAttribute.getMapping();
        JavaCascade cascade = mapping.getCascade();
        JavaCascadeTests.assertFalse((boolean)cascade.isRefresh());
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRefresh());
        cascade.setRefresh(true);
        JavaCascadeTests.assertTrue((boolean)annotation.isCascadeRefresh());
        JavaCascadeTests.assertTrue((boolean)cascade.isRefresh());
        cascade.setRefresh(false);
        JavaCascadeTests.assertFalse((boolean)annotation.isCascadeRefresh());
        JavaCascadeTests.assertFalse((boolean)cascade.isRefresh());
    }
}

