/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaColumnTests
extends ContextModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String COLUMN_DEFINITION = "MY_COLUMN_DEFINITION";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultBasicColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name=\"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicColumnTableSet() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Column(table=\"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicColumnColumnDefinitionSet() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Column(columnDefinition=\"MY_COLUMN_DEFINITION\")");
            }
        });
    }

    public JavaColumnTests(String name) {
        super(name);
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithDefaultBasicColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)COLUMN_NAME, (String)basicMapping.getColumn().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)basicMapping.getPersistentAttribute().getName(), (String)basicMapping.getColumn().getDefaultName());
        JavaColumnTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithDefaultBasicColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
        basicMapping.getColumn().setSpecifiedName("foo");
        JavaColumnTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)"id", (String)basicMapping.getColumn().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithDefaultBasicColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)COLUMN_NAME, (String)basicMapping.getColumn().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        basicMapping.getColumn().setSpecifiedName("foo");
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((String)"foo", (String)column.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithDefaultBasicColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        basicMapping.getColumn().setSpecifiedName(null);
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
    }

    public void testGetNameUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedName());
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getName());
        column.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
    }

    public void testGetSpecifiedTableNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedTable());
    }

    public void testGetSpecifiedTable() throws Exception {
        this.createTestEntityWithBasicColumnTableSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)TABLE_NAME, (String)basicMapping.getColumn().getSpecifiedTable());
    }

    public void testGetDefaultTableSpecifiedTableNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)((Entity)basicMapping.getTypeMapping()).getName(), (String)basicMapping.getColumn().getDefaultTable());
        JavaColumnTests.assertEquals((String)"AnnotationTestType", (String)basicMapping.getColumn().getDefaultTable());
    }

    public void testGetDefaultTable() throws Exception {
        this.createTestEntityWithDefaultBasicColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)"AnnotationTestType", (String)basicMapping.getColumn().getDefaultTable());
        basicMapping.getColumn().setSpecifiedTable("foo");
        JavaColumnTests.assertEquals((String)"AnnotationTestType", (String)basicMapping.getColumn().getDefaultTable());
    }

    public void testGetTable() throws Exception {
        this.createTestEntityWithBasicColumnTableSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)TABLE_NAME, (String)basicMapping.getColumn().getTable());
    }

    public void testSetSpecifiedTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        basicMapping.getColumn().setSpecifiedTable("foo");
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((String)"foo", (String)column.getTable());
    }

    public void testSetSpecifiedTableNull() throws Exception {
        this.createTestEntityWithBasicColumnTableSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        basicMapping.getColumn().setSpecifiedTable(null);
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
    }

    public void testGetTableUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setTable("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedTable());
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getTable());
        column.setTable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedTable());
    }

    public void testGetColumnDefinition() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((String)COLUMN_DEFINITION, (String)basicMapping.getColumn().getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        this.createTestEntityWithBasicColumnTableSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        basicMapping.getColumn().setColumnDefinition("foo");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((String)"foo", (String)column.getColumnDefinition());
        basicMapping.getColumn().setColumnDefinition(null);
        JavaColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testGetColumnDefinitionUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getColumnDefinition());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setColumnDefinition("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getColumnDefinition());
        column.setColumnDefinition(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getColumnDefinition());
    }

    public void testGetLength() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)255, (int)basicMapping.getColumn().getLength());
        basicMapping.getColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)55, (int)basicMapping.getColumn().getLength());
    }

    public void testGetDefaultLength() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)255, (int)basicMapping.getColumn().getDefaultLength());
        basicMapping.getColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)255, (int)basicMapping.getColumn().getDefaultLength());
    }

    public void testGetSpecifiedLength() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedLength());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setLength(Integer.valueOf(66));
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)66, (Object)basicMapping.getColumn().getSpecifiedLength());
        JavaColumnTests.assertEquals((int)66, (int)basicMapping.getColumn().getLength());
        column.setLength(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedLength());
    }

    public void testSetSpecifiedLength() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedLength());
        basicMapping.getColumn().setSpecifiedLength(Integer.valueOf(100));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)100, (Object)column.getLength());
        basicMapping.getColumn().setSpecifiedLength(null);
        JavaColumnTests.assertNull((Object)column.getLength());
    }

    public void testGetPrecision() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getPrecision());
        basicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)55, (int)basicMapping.getColumn().getPrecision());
    }

    public void testGetDefaultPrecision() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getDefaultPrecision());
        basicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getDefaultPrecision());
    }

    public void testGetSpecifiedPrecision() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedPrecision());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setPrecision(Integer.valueOf(66));
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)66, (Object)basicMapping.getColumn().getSpecifiedPrecision());
        JavaColumnTests.assertEquals((int)66, (int)basicMapping.getColumn().getPrecision());
        column.setPrecision(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedPrecision());
    }

    public void testSetSpecifiedPrecision() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedPrecision());
        basicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(100));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)100, (Object)column.getPrecision());
        basicMapping.getColumn().setSpecifiedPrecision(null);
        JavaColumnTests.assertNull((Object)column.getPrecision());
    }

    public void testGetScale() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getScale());
        basicMapping.getColumn().setSpecifiedScale(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)55, (int)basicMapping.getColumn().getScale());
    }

    public void testGetDefaultScale() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getDefaultScale());
        basicMapping.getColumn().setSpecifiedScale(Integer.valueOf(55));
        JavaColumnTests.assertEquals((int)0, (int)basicMapping.getColumn().getDefaultScale());
    }

    public void testGetSpecifiedScale() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedScale());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setScale(Integer.valueOf(66));
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)66, (Object)basicMapping.getColumn().getSpecifiedScale());
        JavaColumnTests.assertEquals((int)66, (int)basicMapping.getColumn().getScale());
        column.setScale(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedScale());
    }

    public void testSetSpecifiedScale() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedScale());
        basicMapping.getColumn().setSpecifiedScale(Integer.valueOf(100));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)100, (Object)column.getScale());
        basicMapping.getColumn().setSpecifiedScale(null);
        JavaColumnTests.assertNull((Object)column.getScale());
    }

    public void testGetUnique() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)false, (boolean)basicMapping.getColumn().isUnique());
        basicMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isUnique());
    }

    public void testGetDefaultUnique() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)false, (boolean)basicMapping.getColumn().isDefaultUnique());
        basicMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)false, (boolean)basicMapping.getColumn().isDefaultUnique());
    }

    public void testGetSpecifiedUnique() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUnique());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setUnique(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getColumn().getSpecifiedUnique());
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isUnique());
        column.setUnique(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUnique());
    }

    public void testSetSpecifiedUnique() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUnique());
        basicMapping.getColumn().setSpecifiedUnique(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        basicMapping.getColumn().setSpecifiedUnique(null);
        JavaColumnTests.assertNull((Object)column.getUnique());
    }

    public void testGetInsertable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isInsertable());
        basicMapping.getColumn().setSpecifiedInsertable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isInsertable());
    }

    public void testGetDefaultInsertable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultInsertable());
        basicMapping.getColumn().setSpecifiedInsertable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultInsertable());
    }

    public void testGetSpecifiedInsertable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedInsertable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setInsertable(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getColumn().getSpecifiedInsertable());
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isInsertable());
        column.setInsertable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedInsertable());
    }

    public void testSetSpecifiedInsertable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedInsertable());
        basicMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        basicMapping.getColumn().setSpecifiedInsertable(null);
        JavaColumnTests.assertNull((Object)column.getInsertable());
    }

    public void testGetNullable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isNullable());
        basicMapping.getColumn().setSpecifiedNullable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isNullable());
    }

    public void testGetDefaultNullable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultNullable());
        basicMapping.getColumn().setSpecifiedNullable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultNullable());
    }

    public void testGetSpecifiedNullable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedNullable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setNullable(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getColumn().getSpecifiedNullable());
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isNullable());
        column.setNullable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedNullable());
    }

    public void testSetSpecifiedNullable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedNullable());
        basicMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        basicMapping.getColumn().setSpecifiedNullable(null);
        JavaColumnTests.assertNull((Object)column.getNullable());
    }

    public void testGetUpdatable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isUpdatable());
        basicMapping.getColumn().setSpecifiedUpdatable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isUpdatable());
    }

    public void testGetDefaultUpdatable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultUpdatable());
        basicMapping.getColumn().setSpecifiedUpdatable(Boolean.TRUE);
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isDefaultUpdatable());
    }

    public void testGetSpecifiedUpdatable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUpdatable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setUpdatable(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getColumn().getSpecifiedUpdatable());
        JavaColumnTests.assertEquals((boolean)true, (boolean)basicMapping.getColumn().isUpdatable());
        column.setUpdatable(null);
        this.getJpaProject().synchronizeContextModel();
        JavaColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUpdatable());
    }

    public void testSetSpecifiedUpdatable() throws Exception {
        this.createTestEntityWithBasicColumnColumnDefinitionSet();
        this.addXmlClassRef("test.AnnotationTestType");
        BasicMapping basicMapping = (BasicMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaColumnTests.assertNull((Object)basicMapping.getColumn().getSpecifiedUpdatable());
        basicMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        basicMapping.getColumn().setSpecifiedUpdatable(null);
        JavaColumnTests.assertNull((Object)column.getUpdatable());
    }
}

