/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.MappedSuperclass;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaEntityTests
extends ContextModelTestCase {
    private static final String ENTITY_NAME = "entityName";
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String DISCRIMINATOR_VALUE = "MY_DISCRIMINATOR_VALUE";
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public JavaEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private void createTestAbstractEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityAnnotationOnProperty() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Basic", "javax.persistence.Version", "javax.persistence.Transient", "javax.persistence.Embedded", "javax.persistence.EmbeddedId", "javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @Basic");
                sb.append(CR);
                sb.append("    private int basic;").append(CR);
                sb.append(CR);
                sb.append("    @Version");
                sb.append(CR);
                sb.append("    private int version;").append(CR);
                sb.append(CR);
                sb.append("    @Transient");
                sb.append(CR);
                sb.append("    private int transient;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    private int embedded;").append(CR);
                sb.append(CR);
                sb.append("    @EmbeddedId");
                sb.append(CR);
                sb.append("    private int embeddedId;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild oneToOne;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int oneToMany;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int manyToOne;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int manyToMany;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestEntityWithName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name=\"entityName\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Table(name=\"MY_TABLE\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(JavaEntityTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithInheritance() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDiscriminatorValue() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.DiscriminatorValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@DiscriminatorValue(value=\"MY_DISCRIMINATOR_VALUE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTable(name=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name=\"foo\"), @SecondaryTable(name=\"bar\")})");
            }
        });
    }

    private ICompilationUnit createAbstractTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
                sb.append("abstract");
            }
        });
    }

    private void createTestIdClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append("TestTypeId").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestTypeId.java", sourceWriter);
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey("mappedSuperclass");
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof MappedSuperclass));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey("embeddable");
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedQuery"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
    }

    public void testAccessNoAnnotations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessAnnotationsOnSuper() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaPersistentType childPersistentType = this.getJavaPersistentType();
        PersistentType superPersistentType = childPersistentType.getSuperPersistentType();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((IdMapping)superPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((JavaResourcePersistentAttribute)typeResource.persistableProperties().next()).removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((BasicMapping)superPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.removeXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        OrmPersistentType childOrmPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.removeXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childOrmPersistentType.getJavaPersistentType().getAccess());
    }

    public void testAccessWithXmlSettings() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((JavaResourcePersistentAttribute)typeResource.persistableProperties().next()).removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        ((BasicMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getJavaPersistentType().getAccess());
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().setSpecifiedName("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"foo", (String)((EntityAnnotation)typeResource.getAnnotation("javax.persistence.Entity")).getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().setSpecifiedName(null);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)((EntityAnnotation)typeResource.getAnnotation("javax.persistence.Entity")).getName());
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        EntityAnnotation entity = (EntityAnnotation)typeResource.getAnnotation("javax.persistence.Entity");
        entity.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetTableName() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithName();
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testGetTableName2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testGetTableName3() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testSetTableNameWithNullTable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTable table = this.getJavaEntity().getTable();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table.getName());
        this.assertSourceDoesNotContain("@Table", cu);
        table.setSpecifiedName(TABLE_NAME);
        this.assertSourceContains("@Table(name = \"MY_TABLE\")", cu);
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getPrimaryTableName());
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setSpecifiedCatalog(TABLE_NAME);
    }

    public void testGetInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getInheritanceStrategy());
    }

    public void testGetDefaultInheritanceStrategy() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertNotSame((Object)childEntity, (Object)rootEntity);
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        rootEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)rootEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getInheritanceStrategy());
        JavaEntityTests.assertNull((Object)childEntity.getSpecifiedInheritanceStrategy());
    }

    public void testGetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        inheritance.setStrategy(org.eclipse.jpt.core.resource.java.InheritanceType.JOINED);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        inheritance.setStrategy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
    }

    public void testSetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        JavaEntityTests.assertEquals((Object)org.eclipse.jpt.core.resource.java.InheritanceType.JOINED, (Object)inheritance.getStrategy());
    }

    public void testGetDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getDiscriminatorValue());
    }

    public void testGetDefaultDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals(null, (String)this.getJavaEntity().getDefaultDiscriminatorValue());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)this.getJavaEntity().getName(), (String)this.getJavaEntity().getDefaultDiscriminatorValue());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(DiscriminatorType.INTEGER);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultDiscriminatorValue());
    }

    public void testGetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        discriminatorValue.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        discriminatorValue.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorValue"));
    }

    public void testSetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        this.getJavaEntity().setSpecifiedDiscriminatorValue("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        JavaEntityTests.assertEquals((String)"foo", (String)discriminatorValue.getValue());
    }

    public void testSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertTrue((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.secondaryTablesSize());
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.secondaryTablesSize());
    }

    public void testSpecifiedSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedSecondaryTables = this.getJavaEntity().specifiedSecondaryTables();
        JavaEntityTests.assertTrue((boolean)specifiedSecondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedSecondaryTables.hasNext());
    }

    public void testSpecifiedSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.specifiedSecondaryTablesSize());
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.specifiedSecondaryTablesSize());
    }

    public void testAddSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        Iterator secondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTable2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        Iterator secondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTablePreservePkJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSecondaryTable specifiedSecondaryTable = this.getJavaEntity().addSpecifiedSecondaryTable(0);
        specifiedSecondaryTable.setSpecifiedName("FOO");
        specifiedSecondaryTable.setSpecifiedCatalog("CATALOG");
        specifiedSecondaryTable.setSpecifiedSchema("SCHEMA");
        specifiedSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("PK_NAME");
        JavaSecondaryTable specifiedSecondaryTable2 = this.getJavaEntity().addSpecifiedSecondaryTable(1);
        specifiedSecondaryTable2.setSpecifiedName("BAR");
        ListIterator secondaryTables = this.getJavaEntity().secondaryTables();
        SecondaryTable secondaryTable = (SecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable);
        JavaEntityTests.assertEquals((String)"FOO", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((String)"CATALOG", (String)secondaryTable.getCatalog());
        JavaEntityTests.assertEquals((String)"SCHEMA", (String)secondaryTable.getSchema());
        JavaEntityTests.assertEquals((int)1, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
        PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)secondaryTable.specifiedPrimaryKeyJoinColumns().next();
        JavaEntityTests.assertEquals((String)"PK_NAME", (String)pkJoinColumn.getName());
        secondaryTable = (SecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable2);
        JavaEntityTests.assertEquals((String)"BAR", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((int)0, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testRemoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        this.getJavaEntity().removeSpecifiedSecondaryTable(1);
        Iterator secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        ListIterator secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.getJavaEntity().removeSpecifiedSecondaryTable(1);
        secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.getJavaEntity().removeSpecifiedSecondaryTable(0);
        secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTables"));
    }

    public void testMoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        entity.addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        Iterator javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaSecondaryTables));
        entity.moveSpecifiedSecondaryTable(2, 0);
        ListIterator secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        entity.moveSpecifiedSecondaryTable(0, 1);
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
    }

    public void testUpdateSpecifiedSecondaryTables() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("FOO");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAR");
        ((SecondaryTableAnnotation)typeResource.addAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.specifiedSecondaryTables();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.getJavaEntity().associatedTables()));
        Iterator associatedTables = this.getJavaEntity().associatedTables();
        Table table1 = (Table)associatedTables.next();
        SecondaryTable table2 = (SecondaryTable)associatedTables.next();
        SecondaryTable table3 = (SecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)rootEntity.associatedTablesIncludingInherited()));
        Iterator associatedTables = rootEntity.associatedTablesIncludingInherited();
        Table table1 = (Table)associatedTables.next();
        SecondaryTable table2 = (SecondaryTable)associatedTables.next();
        SecondaryTable table3 = (SecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
        JavaEntityTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)childEntity.associatedTablesIncludingInherited()));
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)rootEntity.associatedTableNamesIncludingInherited()));
        Iterator associatedTables = rootEntity.associatedTableNamesIncludingInherited();
        String table1 = (String)associatedTables.next();
        String table2 = (String)associatedTables.next();
        String table3 = (String)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1);
        JavaEntityTests.assertEquals((String)"foo", (String)table2);
        JavaEntityTests.assertEquals((String)"bar", (String)table3);
        JavaEntityTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)childEntity.associatedTableNamesIncludingInherited()));
    }

    public void testAddSecondaryTableToResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)this.getJavaEntity().secondaryTables().next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)this.getJavaEntity().secondaryTables().next()).getName());
        SecondaryTableAnnotation secondaryTable2 = (SecondaryTableAnnotation)typeResource.addAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable2.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)this.getJavaEntity().secondaryTablesSize());
        ListIterator secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        SecondaryTableAnnotation secondaryTable3 = (SecondaryTableAnnotation)typeResource.addAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable3.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().secondaryTablesSize());
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
    }

    public void testRemoveSecondaryTableFromResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("baz");
        ListIterator secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)2, (int)this.getJavaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().secondaryTablesSize());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSecondaryTable)secondaryTables.next()).getSpecifiedName());
        typeResource.removeAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = this.getJavaEntity().secondaryTables();
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().secondaryTablesSize());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)2, (int)typeResource.annotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
        this.getJavaEntity().getGeneratorContainer().getSequenceGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        this.getJavaEntity().getGeneratorContainer().addSequenceGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        try {
            this.getJavaEntity().getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        this.getJavaEntity().getGeneratorContainer().removeSequenceGenerator();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            this.getJavaEntity().getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertEquals((int)2, (int)typeResource.annotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
        this.getJavaEntity().getGeneratorContainer().getTableGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().generatorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        this.getJavaEntity().getGeneratorContainer().addTableGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        try {
            this.getJavaEntity().getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        this.getJavaEntity().getGeneratorContainer().removeTableGenerator();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.TableGenerator"));
        try {
            this.getJavaEntity().getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetDiscriminatorColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDiscriminatorColumn());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addAnnotation("javax.persistence.DiscriminatorColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        column.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        typeResource.removeAnnotation("javax.persistence.DiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDiscriminatorColumn());
    }

    public void testSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.moveAnnotation(1, 0, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
    }

    public void testSpecifiedPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().specifiedPrimaryKeyJoinColumnsSize());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().primaryKeyJoinColumnsSize());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().primaryKeyJoinColumnsSize());
    }

    public void testGetDefaultPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        Iterator pkJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        Iterator pkJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")));
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        Iterator pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        ListIterator pkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumnResources = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.getJavaEntity().specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumns"));
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        entity.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        entity.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        Iterator javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaPrimaryKeyJoinColumns));
        entity.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        entity.moveSpecifiedPrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = typeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("FOO");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAR");
        ((PrimaryKeyJoinColumnAnnotation)typeResource.addAnnotation(2, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.specifiedPrimaryKeyJoinColumns();
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
    }

    public void testPrimaryKeyJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn().isVirtual());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0);
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.getJavaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().tableNameIsInvalid("AnnotationTestType"));
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().tableNameIsInvalid("FOO"));
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().tableNameIsInvalid("BAR"));
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().overridableAttributeNames();
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = this.getJavaEntity().overridableAttributeNames();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().overridableAttributeNames();
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = this.getJavaEntity().overridableAttributeNames();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAttributes = abstractEntity.allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().allOverridableAssociationNames();
        JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAssociations = abstractEntity.allOverridableAssociationNames();
        JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().allOverridableAttributeNames();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrideDefaults() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        BasicMapping fooMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("foo").getMapping();
        fooMapping.getColumn().setSpecifiedName("FOO");
        fooMapping.getColumn().setSpecifiedTable("BAR");
        fooMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        fooMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        fooMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        fooMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        fooMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntityTests.assertEquals((String)"COLUMN_DEF", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        fooMapping.getColumn().setSpecifiedName(null);
        fooMapping.getColumn().setSpecifiedTable(null);
        fooMapping.getColumn().setColumnDefinition(null);
        fooMapping.getColumn().setSpecifiedInsertable(null);
        fooMapping.getColumn().setSpecifiedUpdatable(null);
        fooMapping.getColumn().setSpecifiedUnique(null);
        fooMapping.getColumn().setSpecifiedNullable(null);
        fooMapping.getColumn().setSpecifiedLength(null);
        fooMapping.getColumn().setSpecifiedPrecision(null);
        fooMapping.getColumn().setSpecifiedScale(null);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = virtualAttributeOverride.setVirtual(false);
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
    }

    public void testVirtualAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntity superclass = (JavaEntity)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        virtualAttributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = virtualAttributeOverride.setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.specifiedAttributeOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.virtualAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.attributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.attributeOverridesSize());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.attributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((JavaAttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator attributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        ((AttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        Iterator attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        ListIterator attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"basic", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"id", (String)((JavaAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrideResources = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AttributeOverrides"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaAttributeOverrides));
        overrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        overrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = typeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("FOO");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAR");
        ((AttributeOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.specifiedAttributeOverrides();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"basic", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"basic", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().overridableAssociationNames();
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().allOverridableAssociationNames();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociations() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().allOverridableAssociationNames();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.moveAnnotation(1, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAssociationOverrideContainer overrideContainer = javaEntity.getAssociationOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JoinColumnJoiningStrategy joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        JavaEntityTests.assertEquals((String)"oneToOne_id", (String)virtualJoinColumn.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualJoinColumn.getTable());
        JavaEntityTests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        OneToOneMapping oneToOneMapping = (OneToOneMapping)this.getJavaPersistentType().getAttributeNamed("oneToOne").getMapping();
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTable("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        JavaEntityTests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        JavaEntityTests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        JavaEntityTests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        JavaEntityTests.assertEquals((String)"MY_JOIN_COLUMN", (String)((JoinColumn)joiningStrategy.joinColumns().next()).getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)typeResource.getName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.specifiedAssociationOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.specifiedAssociationOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.associationOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverrides.next();
        ((JavaAssociationOverride)virtualAssociationOverrides.next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        Iterator associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        associationOverrideResources = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType(FULLY_QUALIFIED_SUB_TYPE_NAME);
        Iterator javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedAssociationOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedAssociationOverride(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("FOO");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAR");
        ((AssociationOverrideAnnotation)typeResource.addAnnotation(2, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.moveAnnotation(2, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        AssociationOverride virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testAddNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaNamedQuery namedQuery1 = entity.getQueryContainer().addNamedQuery(0);
        namedQuery1.setName("FOO");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedQuery namedQuery2 = entity.getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedQuery namedQuery3 = entity.getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((Object)namedQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery1, namedQueries.next());
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        entity.getQueryContainer().addNamedNativeQuery(0).setName("foo");
    }

    public void testRemoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)javaNamedQueries));
    }

    public void testAddNamedNativeQueryWithNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        NamedNativeQueryAnnotation nativeQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        nativeQuery.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)entity.getQueryContainer().namedNativeQueriesSize());
        ListIterator namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
    }

    public void testAddNamedQueryWithNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)entity.getQueryContainer().namedQueriesSize());
        ListIterator namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
    }

    public void testMoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().queriesSize());
        ((NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("FOO");
        ((NamedQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAR");
        ((NamedQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.moveAnnotation(2, 0, "javax.persistence.NamedQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.NamedQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.removeAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.removeAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedQueries();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().queriesSize());
    }

    public void testNamedQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.getQueryContainer().namedQueriesSize());
        ((NamedQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("FOO");
        ((NamedQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAR");
        ((NamedQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getQueryContainer().namedQueriesSize());
    }

    public void testAddNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaNamedNativeQuery namedNativeQuery = entity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedNativeQuery namedNativeQuery2 = entity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedNativeQuery namedNativeQuery3 = entity.getQueryContainer().addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((Object)namedNativeQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery, namedQueries.next());
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)javaNamedQueries));
    }

    public void testMoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        Iterator javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().moveNamedNativeQuery(2, 0);
        ListIterator namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().moveNamedNativeQuery(0, 1);
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().queriesSize());
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("FOO");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAR");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.moveAnnotation(2, 0, "javax.persistence.NamedNativeQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.moveAnnotation(0, 1, "javax.persistence.NamedNativeQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        typeResource.removeAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.removeAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)entity.getPersistenceUnit().queriesSize());
        typeResource.removeAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().namedNativeQueries();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().queriesSize());
    }

    public void testNamedNativeQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)entity.getQueryContainer().namedNativeQueriesSize());
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("FOO");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAR");
        ((NamedNativeQueryAnnotation)typeResource.addAnnotation(2, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getQueryContainer().namedNativeQueriesSize());
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestEntity();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        String nonExistentIdClassName = "test.Foo";
        idClass.setValue(nonExistentIdClassName);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClass.setValue(existentIdClassName);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        idClass.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        idClass.setValue(existentIdClassName);
        typeResource.removeAnnotation("javax.persistence.IdClass");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        this.createTestEntity();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String nonExistentIdClassName = "test.Foo";
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(nonExistentIdClassName);
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String existentIdClassName = "test.TestTypeId";
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(existentIdClassName);
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(null);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
    }

    public void testGetPrimaryKeyColumnNameWithAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType entityPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntity javaEntity = (JavaEntity)entityPersistentType.getMapping();
        JavaPersistentType mappedSuperclassPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntityTests.assertEquals((String)"id", (String)javaEntity.getPrimaryKeyColumnName());
        ((JavaIdMapping)mappedSuperclassPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaEntityTests.assertEquals((String)"MY_ID", (String)javaEntity.getPrimaryKeyColumnName());
        ListIterator virtualAttributeOverrides = javaEntity.getAttributeOverrideContainer().virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        virtualAttributeOverrides.next();
        JavaAttributeOverride javaAttributeOverride = (JavaAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)javaAttributeOverride.getName());
        javaAttributeOverride = javaAttributeOverride.setVirtual(false);
        javaAttributeOverride.getColumn().setSpecifiedName("ID");
        JavaEntityTests.assertEquals((String)"ID", (String)javaEntity.getPrimaryKeyColumnName());
    }

    public void testDiscriminatorValueIsUndefinedConcreteClass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
    }

    public void testDiscriminatorValueIsUndefinedAbstractClass() throws Exception {
        this.createTestAbstractEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
    }

    public void testSpecifiedDiscriminatorColumnIsAllowed() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity concreteEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertFalse((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
        abstractEntity.setSpecifiedInheritanceStrategy(null);
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertTrue((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
    }

    public void testAbstractEntityGetDefaultDiscriminatorColumnNameTablePerClassInheritance() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        Entity concreteEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getSpecifiedInheritanceStrategy());
        JavaEntityTests.assertEquals(null, (Object)concreteEntity.getSpecifiedInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)concreteEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertEquals(null, (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        JavaEntityTests.assertEquals(null, (String)concreteEntity.getDiscriminatorColumn().getDefaultName());
        JavaEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertEquals(null, (String)abstractEntity.getDefaultDiscriminatorValue());
        JavaEntityTests.assertTrue((boolean)concreteEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertEquals(null, (String)concreteEntity.getDefaultDiscriminatorValue());
    }
}

