/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToManyRelationshipReference;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaOneToManyMappingTests
extends ContextModelTestCase {
    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonCollectionOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Address addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Map;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.OneToMany").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Map<Integer, Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public JavaOneToManyMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaOneToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("FOO");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaOneToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaOneToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("newTargetEntity");
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedTargetEntity());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getFetch());
        oneToMany.setFetch(FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToMany.setFetch(FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToMany.getFetch());
        oneToMany.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getFetch());
        oneToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToMany.getFetch());
        oneToManyMapping.setSpecifiedFetch(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedFetch());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("newMappedBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("newTargetEntity");
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getMappedBy());
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        JavaOneToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping mapping = (OneToManyMapping)contextAttribute.getMapping();
        OneToManyRelationshipReference relationshipReference = mapping.getRelationshipReference();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping mapping = (OneToManyMapping)contextAttribute.getMapping();
        OneToManyRelationshipReference relationshipReference = mapping.getRelationshipReference();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        JavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        JavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getDefaultTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityNonCollectionType() throws Exception {
        this.createTestEntityWithNonCollectionOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        JavaOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        JavaOneToManyMappingTests.assertEquals((String)"test.Address", (String)oneToManyMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaOneToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToManyMapping.getResolvedTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getResolvedTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity("test.Address");
        JavaOneToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToManyMapping.getResolvedTargetEntity());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        JavaOneToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToManyMapping.getResolvedTargetEntity());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaOneToManyMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        oneToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        oneToManyMapping.setSpecifiedMapKey(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaOneToManyMapping.candidateMapKeyNames();
        JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = javaOneToManyMapping.candidateMapKeyNames();
        JavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = javaOneToManyMapping.candidateMapKeyNames();
        JavaOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        JavaOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testUpdateOrderBy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testModifyOrderBy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("newOrderBy");
        JavaOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        JavaOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        oneToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        JavaOneToManyMappingTests.assertNull((Object)oneToManyMapping.getOrderable().getSpecifiedOrderBy());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateNoOrdering() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertTrue((boolean)oneToManyMapping.getOrderable().isNoOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isNoOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isNoOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertTrue((boolean)oneToManyMapping.getOrderable().isNoOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdatePkOrdering() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isPkOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertTrue((boolean)oneToManyMapping.getOrderable().isPkOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isPkOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isPkOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateCustomOrdering() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isCustomOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isCustomOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertTrue((boolean)oneToManyMapping.getOrderable().isCustomOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getOrderable().isCustomOrdering());
        JavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testDefaultTargetEntityForMap() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.addXmlClassRef("test.Department");
        this.addXmlClassRef("test.Employee");
        JavaPersistentType departmentPersistentType = this.getJavaPersistentType();
        OneToManyMapping employeesMapping = (OneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getSpecifiedMapping();
        JavaOneToManyMappingTests.assertEquals((String)"test.Employee", (String)employeesMapping.getTargetEntity());
    }
}

