/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.JoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.core.jpa2.context.AssociationOverrideRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaEmbeddedMapping2_0;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaEmbeddedMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaEmbeddedMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    private void createAddressEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Address {");
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public GenericJavaEmbeddedMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)((EmbeddedMapping)persistentAttribute.getMapping()).getAttributeOverrideContainer().attributeOverrides().hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testDefaultEmbeddedMappingGenericEmbeddable() throws Exception {
        this.createTestEntityWithDefaultEmbeddedMapping();
        this.createTestGenericEmbeddable();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Embeddable1");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbeddable");
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)persistentAttribute.getMapping());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)persistentAttribute.getDefaultMappingKey());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    private void createTestEntityWithDefaultEmbeddedMapping() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 { ").append(CR);
                sb.append("private Embeddable1<Integer> myEmbeddable;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericEmbeddable() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class Embeddable1<T> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Embeddable1.java", sourceWriter);
    }

    private void createSelfReferentialEmbedded() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Foo embedded;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute persistentAttribute = this.getJavaPersistentType().getAttributeNamed("myEmbedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaEmbeddedMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"myEmbedded", (String)attributeResource.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"myEmbedded", (String)attributeResource.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("state");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((AttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceAttribute.moveAnnotation(1, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceAttribute.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceAttribute.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceAttribute.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JoinColumnJoiningStrategy joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address_id", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaPersistentType javaEmbeddable = ((ClassRef)classRefs.next()).getJavaPersistentType();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)javaEmbeddable.getAttributeNamed("address").getMapping();
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTable("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)((JoinColumn)joiningStrategy.joinColumns().next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.specifiedAssociationOverridesSize());
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.specifiedAssociationOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)3, (int)overrideContainer.associationOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        Iterator associationOverrides = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverrides.next();
        ((JavaAssociationOverride)virtualAssociationOverrides.next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        Iterator associationOverrides = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        Iterator associationOverrideResources = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((JavaAssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        associationOverrideResources = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        Iterator javaAssociationOverrides = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedAssociationOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedAssociationOverride(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceAttribute.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ((AssociationOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("FOO");
        ((AssociationOverrideAnnotation)resourceAttribute.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAR");
        ((AssociationOverrideAnnotation)resourceAttribute.addAnnotation(2, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceAttribute.moveAnnotation(2, 0, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceAttribute.moveAnnotation(0, 1, "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceAttribute.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceAttribute.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceAttribute.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        AssociationOverride virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideJoinTableDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)CollectionTools.get((Iterator)overrideContainer.virtualAssociationOverrides(), (int)1);
        JoinTableJoiningStrategy joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        JoinTable joinTable = joiningStrategy.getJoinTable();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)joinTable.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        JoinColumn virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses_id", (String)virtualInverseJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isNullable());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        JavaPersistentType javaEmbeddable = ((ClassRef)classRefs.next()).getJavaPersistentType();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)javaEmbeddable.getAttributeNamed("addresses").getMapping();
        JoinTableJoiningStrategy joinTableStrategy = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy();
        joinTableStrategy.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = joinTableStrategy.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTable("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JoinColumn inverseJoinColumn = joinTableStrategy.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("MY_INVERSE_JOIN_COLUMN");
        inverseJoinColumn.setSpecifiedReferencedColumnName("MY_INVERSE_REFERENCE_COLUMN");
        inverseJoinColumn.setSpecifiedTable("INVERSE_BAR");
        inverseJoinColumn.setColumnDefinition("INVERSE_COLUMN_DEF");
        inverseJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUnique(Boolean.TRUE);
        inverseJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)CollectionTools.get((Iterator)overrideContainer.virtualAssociationOverrides(), (int)1);
        joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverride"));
        GenericJavaEmbeddedMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AssociationOverrides"));
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType customerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("zipCode.plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("plusfour").setVirtual(false);
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("zipCode.plusfour");
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.setVirtual(false);
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals(null, (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericJavaEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testSelfReferentialEmbeddedMapping() throws Exception {
        this.createSelfReferentialEmbedded();
        this.addXmlClassRef("test.Foo");
        JavaEmbeddedMapping2_0 embeddedMapping = (JavaEmbeddedMapping2_0)this.getJavaPersistentType().getAttributeNamed("embedded").getMapping();
        GenericJavaEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.allOverrideableAttributeMappingNames().hasNext());
    }
}

