/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.jpa2.context.ManyToManyMapping2_0;
import org.eclipse.jpt.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaManyToManyMapping2_0;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaManyToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaManyToManyMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        manyToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        manyToManyMapping.setSpecifiedMapKey(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.candidateMapKeyNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.candidateMapKeyNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("Address");
        mapKeyNames = manyToManyMapping2_0.candidateMapKeyNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("String");
        mapKeyNames = manyToManyMapping2_0.candidateMapKeyNames();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        attributeResource.addAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)mapKeyClass);
        mapKeyClass.setValue("myMapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)mapKeyClass.getValue());
        mapKeyClass.setValue(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)mapKeyClass.getValue());
        mapKeyClass.setValue("myMapKeyClass");
        attributeResource.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        manyToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"String", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        JavaPersistentType printQueuePersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintQueue");
        ManyToManyMapping jobsMapping = (ManyToManyMapping)printQueuePersistentType.getAttributeNamed("jobs").getMapping();
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ManyToManyMapping queuesMapping = (ManyToManyMapping)printJobPersistentType.getAttributeNamed("queues").getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        OrderColumn2_0 jobsOrderColumn = jobsOrderable.getOrderColumn();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)jobsOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        OrderColumn2_0 queuesOrderColumn = queuesOrderable.getOrderColumn();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)queuesOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        jobsOrderColumn.setSpecifiedName("FOO");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)jobsOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        queuesOrderColumn.setSpecifiedName("BAR");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)queuesOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printQueuePersistentType.getMapping()).getTable().setSpecifiedName("OTHER_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)queuesOrderColumn.getTable());
        queuesMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)queuesOrderColumn.getTable());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany(mappedBy=\"queues\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintQueue> queues;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumn() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)manyToManyMapping.getMapKeyColumn().getTable());
        manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        manyToManyMapping.getRelationshipReference().setMappedByJoiningStrategy();
        manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("employees");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"Address_AnnotationTestType", (String)manyToManyMapping.getMapKeyColumn().getTable());
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType("test.Address");
        ManyToManyMapping owningManyToManyMapping = (ManyToManyMapping)persistentType.getAttributeNamed("employees").getMapping();
        ((JoinTableJoiningStrategy)owningManyToManyMapping.getRelationshipReference().getPredominantJoiningStrategy()).getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)manyToManyMapping.getMapKeyColumn().getTable());
        manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"parcels", (String)attributeResource.getName());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"parcels", (String)attributeResource.getName());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.specifiedAttributeOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.virtualAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((JavaAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((JavaAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
    }
}

