/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AssociationOverridesAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AssociationOverridesTests
extends JavaResourceModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE";

    public AssociationOverridesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAssociationOverrideOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn}))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverridesTests.assertNotNull((Object)associationOverride);
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverridesTests.assertNotNull((Object)associationOverride);
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName("Foo");
        AssociationOverridesTests.assertEquals((String)"Foo", (String)associationOverride.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName(null);
        AssociationOverridesTests.assertNull((Object)associationOverride.getName());
        this.assertSourceDoesNotContain("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
        this.assertSourceContains("@AssociationOverride", cu);
        this.assertSourceContains("@AssociationOverrides", cu);
    }

    public void testAddAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        AssociationOverridesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverridesTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
    }

    public void testAddAssociationOverrideToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"BAZ\"),@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")), @AssociationOverride(name = \"BAR\")})", cu);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        AssociationOverridesTests.assertEquals((String)"BAZ", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverridesTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
    }

    public void testRemoveAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.assertSourceContains("@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverridesTests.assertEquals((int)0, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0);
        associationOverride.addJoinColumn(1);
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0).setName("FOO");
        associationOverride.addJoinColumn(1);
        associationOverride.addJoinColumn(0).setName("BAR");
        ListIterator joinColumns = associationOverride.joinColumns();
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0).setName("FOO");
        ListIterator joinColumns = associationOverride.joinColumns();
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(1);
        joinColumns = associationOverride.joinColumns();
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(0);
        joinColumns = associationOverride.joinColumns();
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = @JoinColumn))", cu);
        associationOverride.setName(null);
        associationOverride.removeJoinColumn(0);
        this.assertSourceDoesNotContain("@AssociationOverride", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(2, 0);
        AssociationOverridesTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverridesTests.assertNull((Object)associationOverride.joinColumnAt(1).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverridesTests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(0, 2);
        AssociationOverridesTests.assertNull((Object)associationOverride.joinColumnAt(0).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverridesTests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")}))", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)associationOverride.joinColumns().next();
        AssociationOverridesTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverridesTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }
}

