/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkManyToOneMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmManyToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToOne").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Employee employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testJoinFetchDefaultFromJava() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        OrmEclipseLinkManyToOneMapping manyToOne = (OrmEclipseLinkManyToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEclipseLinkOneToOneMapping oneToOne = (OrmEclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employee").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        manyToOne = (OrmEclipseLinkManyToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)manyToOne.getJoinFetch().getValue());
    }
}

