/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink1_2.core.tests.internal.context;

import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.eclipselink.core.internal.JptEclipseLinkCorePlugin;
import org.eclipse.jpt.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.eclipselink1_2.core.tests.internal.context.EclipseLink1_2ContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLink1_2JpaProjectTests
extends EclipseLink1_2ContextModelTestCase {
    public EclipseLink1_2JpaProjectTests(String name) {
        super(name);
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLink1_2ContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_2_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLinkContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetDefaultEclipseLinkOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_2OrmXmlFile();
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_2_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLinkContentType() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.setProperty("JpaFileCreationDataModelProperties.FILE_PATH", (Object)"META-INF/orm.xml");
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLink1_2ContentType() throws Exception {
        this.createEclipseLink1_2OrmXmlFile("META-INF/orm.xml");
    }

    private void createDefaultEclipseLink1_2OrmXmlFile() throws Exception {
        this.createEclipseLink1_2OrmXmlFile("META-INF/eclipselink-orm.xml");
    }

    private void createEclipseLink1_2OrmXmlFile(String filePath) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)this.getJpaProject().getProject().getName());
        config.setProperty("JpaFileCreationDataModelProperties.VERSION", (Object)"1.2");
        config.setProperty("JpaFileCreationDataModelProperties.FILE_PATH", (Object)filePath);
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_2OrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_2_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
    }

    public void testGetDifferentlyNamedMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_2OrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_2_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_2OrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_1_2_RESOURCE_TYPE, (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

