/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.model;

import java.util.Stack;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xsl.core.internal.model.StylesheetParserData;
import org.eclipse.wst.xsl.core.internal.model.XSLModelObjectFactory;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StylesheetParser {
    private StylesheetParserData stylesheetParserData = new StylesheetParserData(new Stack<Element>(), new Stack<CallTemplate>(), new Stack<Function>());

    public StylesheetParser(Stylesheet stylesheet) {
        this.stylesheetParserData.setStylesheet(stylesheet);
    }

    public void walkDocument(IDOMDocument document) {
        if (document.getDocumentElement() != null) {
            this.recurse(document.getDocumentElement());
        }
    }

    private void recurse(Element element) {
        XSLElement xslEl = null;
        if ("http://www.w3.org/1999/XSL/Transform".equals(element.getNamespaceURI())) {
            XSLModelObjectFactory factory = new XSLModelObjectFactory(element, xslEl, this.stylesheetParserData);
            xslEl = factory.createXSLModelObject();
        }
        this.stylesheetParserData.getElementStack().push(element);
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                this.recurse((Element)node);
            }
            ++i;
        }
        if (xslEl instanceof CallTemplate) {
            this.stylesheetParserData.getCallTemplates().pop();
        }
        if (xslEl instanceof Function) {
            this.stylesheetParserData.getFunctions().pop();
        }
        this.stylesheetParserData.getElementStack().pop();
    }
}

