/* The following code was generated by JFlex 1.2.2 on 6/29/09 9:58 AM */

/*******************************************************************************
 * Copyright (c) 2004, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.html.core.internal.contenttype;
import java.io.IOException;
import java.io.Reader;

import org.eclipse.wst.xml.core.internal.contenttype.EncodingParserConstants;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizerConstants;




/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 6/29/09 9:58 AM from the specification file
 * <tt>file:/D:/dev/workspaces/wtp3M/org.eclipse.wst.sse.core/DevTimeSupport/HeadParsers/HTMLHeadTokenizer/HTMLHeadTokenizer.jFlex</tt>
 */
public class HTMLHeadTokenizer {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_META_TAG = 4;
  final public static int YYINITIAL = 0;
  final public static int UnDelimitedString = 12;
  final public static int DQ_STRING = 8;
  final public static int UnDelimitedCharset = 14;
  final public static int SQ_STRING = 10;
  final public static int ST_XMLDecl = 2;
  final public static int QuotedAttributeValue = 6;

  /**
   * YY_LEXSTATE[l] is the state in the DFA for the lexical state l
   * YY_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private final static int YY_LEXSTATE[] = { 
     0,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8, 8
  };

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\1\11\10\0\1\6\1\7\2\0\1\10\22\0\1\6\1\0\1\40"+
    "\2\0\1\44\1\0\1\43\5\0\1\34\1\0\1\42\13\0\1\45"+
    "\1\13\1\12\1\31\1\14\1\0\1\22\1\0\1\24\1\26\1\20"+
    "\1\0\1\30\1\32\1\27\2\0\1\17\1\16\1\23\1\25\1\33"+
    "\1\35\2\0\1\21\1\36\1\37\1\0\1\15\1\41\7\0\1\22"+
    "\1\0\1\24\1\26\1\20\1\0\1\30\1\32\1\27\2\0\1\17"+
    "\1\16\1\23\1\25\1\33\1\35\2\0\1\21\1\36\1\37\1\0"+
    "\1\15\1\41\101\0\1\4\3\0\1\5\17\0\1\3\16\0\1\1"+
    "\20\0\1\3\16\0\1\1\1\2\170\0\1\2\ufe87\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  //private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  //private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */


	private boolean hasMore = true;
	private final static int MAX_TO_SCAN = 8000;
	StringBuffer string = new StringBuffer();
	// state stack for easier state handling
	private IntStack fStateStack = new IntStack();
	private String valueText = null;
	boolean foundContentTypeValue = false;



	public HTMLHeadTokenizer() {
		super();
	}

	  public void reset (Reader in) {
	  	/* the input device */
	  	yy_reader = in;

  		/* the current state of the DFA */
  		yy_state = 0;

  		/* the current lexical state */
  		yy_lexical_state = YYINITIAL;

  		/* this buffer contains the current text to be matched and is
  		 the source of the yytext() string */
  		java.util.Arrays.fill(yy_buffer, (char)0);

  		/* the textposition at the last accepting state */
  		yy_markedPos = 0;

  		/* the textposition at the last state to be included in yytext */
  		yy_pushbackPos = 0;

  		/* the current text position in the buffer */
  		yy_currentPos = 0;

  		/* startRead marks the beginning of the yytext() string in the buffer */
  		yy_startRead = 0;

  		/** 
  		 * endRead marks the last character in the buffer, that has been read
  		 * from input 
  		 */
  		yy_endRead = 0;

  		/* number of newlines encountered up to the start of the matched text */
  		// yyline = 0;

  		/* the number of characters up to the start of the matched text */
  		yychar = 0;

  		/**
  		 * the number of characters from the last newline up to the start
  		 * of the matched text
  		 */
  		// yycolumn = 0; 

  		/** 
  		 * yy_atBOL == true <=> the scanner is currently at the beginning 
  		 * of a line
  		 */
  		yy_atBOL = false;

  		/* yy_atEOF == true <=> the scanner has returned a value for EOF */
  		yy_atEOF = false;

  		/* denotes if the user-EOF-code has already been executed */
  		yy_eof_done = false;


  		fStateStack.clear();
  		
  		hasMore = true;
  		
		// its a little wasteful to "throw away" first char array generated
		// by class init (via auto generated code), but we really do want
		// a small buffer for our head parsers.
		if (yy_buffer.length != MAX_TO_SCAN) {
			yy_buffer = new char[MAX_TO_SCAN];
		}
  		

  	}


	public final HeadParserToken getNextToken() throws IOException {
		String context = null;
		HeadParserToken result = null;
		try {
			context = primGetNextToken();
		}
		catch (IllegalStateException e) {
			hasMore = false;
			result = createToken(HTMLHeadTokenizerConstants.UNDEFINED, yychar, yytext());
			while(yy_advance() != YYEOF) {}
			return result;
		}
		if (valueText != null) {
			result = createToken(context, yychar, valueText);
			valueText = null;
		} else {
			result = createToken(context, yychar, yytext());
		}
		return result;
	}

	public final boolean hasMoreTokens() {
		return hasMore && yychar < MAX_TO_SCAN;
	}
	private void pushCurrentState() {
		fStateStack.push(yystate());

	}

	private void popState() {
		yybegin(fStateStack.pop());
	}
	private HeadParserToken createToken(String context, int start, String text) {
		return new HeadParserToken(context, start, text);
	}
	



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLHeadTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLHeadTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 176) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      IllegalStateException ise = new IllegalStateException("Instance: " + System.identityHashCode(this) + " offset:" + yychar + " state:" + yystate());
      System.out.println(YY_ERROR_MSG[errorCode] + "\n" + ise);
      throw ise;
    }
    catch (ArrayIndexOutOfBoundsException e) {
      System.out.println(YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }

  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    	hasMore=false;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    yy_pushbackPos = -1;
    boolean yy_was_pushback;

    while (true) {

      yychar+= yylength();

      yy_atBOL = yy_markedPos <= 0 || yy_buffer[yy_markedPos-1] == '\n';
      if (!yy_atBOL && yy_buffer[yy_markedPos-1] == '\r') {
        yy_atBOL = yy_advance() != '\n';
        if (!yy_atEOF) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      if (yy_atBOL)
        yy_state = YY_LEXSTATE[yy_lexical_state+1];
      else
        yy_state = YY_LEXSTATE[yy_lexical_state];

      yy_was_pushback = false;

      yy_forAction: {
        while (true) {
    
          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          yy_input = yycmap[yy_input];

          boolean yy_pushback = false;
          boolean yy_isFinal = false;
          boolean yy_noLookAhead = false;

          yy_forNext: { switch (yy_state) {
            case 0:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_state = 10; break yy_forNext;
                case 2: yy_isFinal = true; yy_state = 11; break yy_forNext;
                case 3: yy_isFinal = true; yy_state = 12; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 13; break yy_forNext;
                case 11: yy_isFinal = true; yy_state = 14; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 9; break yy_forNext;
              }

            case 1:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_state = 10; break yy_forNext;
                case 2: yy_isFinal = true; yy_state = 11; break yy_forNext;
                case 3: yy_isFinal = true; yy_state = 12; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 15; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 16; break yy_forNext;
                case 11: yy_isFinal = true; yy_state = 17; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 9; break yy_forNext;
              }

            case 2:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_state = 18; break yy_forNext;
                case 12: yy_isFinal = true; yy_state = 19; break yy_forNext;
                case 16: yy_isFinal = true; yy_state = 20; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 9; break yy_forNext;
              }

            case 3:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_state = 21; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 22; break yy_forNext;
                case 26: yy_isFinal = true; yy_state = 23; break yy_forNext;
                case 34: yy_isFinal = true; yy_state = 24; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 9; break yy_forNext;
              }

            case 4:
              switch (yy_input) {
                case 6: 
                case 8: yy_isFinal = true; yy_state = 26; break yy_forNext;
                case 7: yy_isFinal = true; yy_state = 27; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 28; break yy_forNext;
                case 32: yy_isFinal = true; yy_state = 29; break yy_forNext;
                case 35: yy_isFinal = true; yy_state = 30; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 25; break yy_forNext;
              }

            case 5:
              switch (yy_input) {
                case 7: 
                case 8: 
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 33; break yy_forNext;
                case 12: 
                case 34: yy_isFinal = true; yy_state = 34; break yy_forNext;
                case 32: yy_isFinal = true; yy_state = 35; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 6:
              switch (yy_input) {
                case 7: 
                case 8: 
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 34: yy_isFinal = true; yy_state = 34; break yy_forNext;
                case 35: yy_isFinal = true; yy_state = 35; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 36; break yy_forNext;
                case 36: yy_isFinal = true; yy_state = 37; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 7:
              switch (yy_input) {
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 34: yy_isFinal = true; yy_state = 34; break yy_forNext;
                case 12: yy_isFinal = true; yy_state = 37; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 39; break yy_forNext;
                case 32: 
                case 35: yy_isFinal = true; yy_state = 40; break yy_forNext;
                case 37: yy_isFinal = true; yy_pushbackPos = yy_currentPos; yy_pushback = true; yy_state = 41; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 8:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 9; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 42; break yy_forNext;
              }

            case 10:
              switch (yy_input) {
                case 2: yy_isFinal = true; yy_noLookAhead = true; yy_state = 43; break yy_forNext;
                default: break yy_forAction;
              }

            case 11:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_noLookAhead = true; yy_state = 44; break yy_forNext;
                default: break yy_forAction;
              }

            case 12:
              switch (yy_input) {
                case 4: yy_state = 45; break yy_forNext;
                default: break yy_forAction;
              }

            case 13:
              switch (yy_input) {
                case 11: yy_state = 46; break yy_forNext;
                default: break yy_forAction;
              }

            case 14:
              switch (yy_input) {
                case 9: yy_state = 47; break yy_forNext;
                case 14: yy_state = 48; break yy_forNext;
                default: break yy_forAction;
              }

            case 15:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 49; break yy_forNext;
                case 9: yy_state = 50; break yy_forNext;
                case 11: yy_state = 51; break yy_forNext;
                default: break yy_forAction;
              }

            case 16:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 49; break yy_forNext;
                case 11: yy_state = 52; break yy_forNext;
                default: break yy_forAction;
              }

            case 17:
              switch (yy_input) {
                case 14: yy_state = 48; break yy_forNext;
                case 9: yy_state = 53; break yy_forNext;
                case 12: yy_state = 54; break yy_forNext;
                default: break yy_forAction;
              }

            case 18:
              switch (yy_input) {
                case 12: yy_state = 55; break yy_forNext;
                case 16: yy_state = 56; break yy_forNext;
                default: break yy_forAction;
              }

            case 19:
              switch (yy_input) {
                case 9: yy_state = 57; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 20:
              switch (yy_input) {
                case 9: yy_state = 59; break yy_forNext;
                case 19: yy_state = 60; break yy_forNext;
                default: break yy_forAction;
              }

            case 21:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 22; break yy_forNext;
                case 26: yy_state = 61; break yy_forNext;
                case 34: yy_state = 62; break yy_forNext;
                default: break yy_forAction;
              }

            case 22:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 63; break yy_forNext;
                default: break yy_forAction;
              }

            case 23:
              switch (yy_input) {
                case 9: yy_state = 64; break yy_forNext;
                case 17: yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 24:
              switch (yy_input) {
                case 9: yy_state = 66; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 26:
              switch (yy_input) {
                case 6: 
                case 8: yy_isFinal = true; yy_state = 26; break yy_forNext;
                case 7: yy_state = 68; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 69; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 25; break yy_forNext;
              }

            case 27:
              switch (yy_input) {
                case 6: 
                case 8: yy_isFinal = true; yy_state = 26; break yy_forNext;
                case 7: yy_state = 68; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 69; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 25; break yy_forNext;
              }

            case 28:
              switch (yy_input) {
                case 32: yy_isFinal = true; yy_state = 29; break yy_forNext;
                case 35: yy_isFinal = true; yy_state = 30; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_state = 68; break yy_forNext;
                default: break yy_forAction;
              }

            case 29:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 70; break yy_forNext;
                default: break yy_forAction;
              }

            case 30:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 71; break yy_forNext;
                default: break yy_forAction;
              }

            case 32:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 72; break yy_forNext;
                default: break yy_forAction;
              }

            case 33:
              switch (yy_input) {
                case 7: 
                case 8: 
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 32: yy_isFinal = true; yy_state = 35; break yy_forNext;
                case 12: 
                case 34: yy_state = 73; break yy_forNext;
                default: break yy_forAction;
              }

            case 34:
              switch (yy_input) {
                case 9: yy_state = 74; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 75; break yy_forNext;
                default: break yy_forAction;
              }

            case 35:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 76; break yy_forNext;
                default: break yy_forAction;
              }

            case 36:
              switch (yy_input) {
                case 7: 
                case 8: 
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 35: yy_isFinal = true; yy_state = 35; break yy_forNext;
                case 34: yy_state = 73; break yy_forNext;
                case 36: yy_state = 77; break yy_forNext;
                default: break yy_forAction;
              }

            case 37:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 9: yy_state = 78; break yy_forNext;
                default: break yy_forAction;
              }

            case 38:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 79; break yy_forNext;
                default: break yy_forAction;
              }

            case 39:
              switch (yy_input) {
                case 11: 
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 32: 
                case 35: yy_isFinal = true; yy_state = 40; break yy_forNext;
                case 34: yy_state = 73; break yy_forNext;
                case 12: yy_state = 77; break yy_forNext;
                default: break yy_forAction;
              }

            case 40:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 80; break yy_forNext;
                default: break yy_forAction;
              }

            case 41:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_pushback = true; yy_state = 81; break yy_forNext;
                case 9: yy_state = 82; break yy_forNext;
                default: break yy_forAction;
              }

            case 45:
              switch (yy_input) {
                case 5: yy_isFinal = true; yy_noLookAhead = true; yy_state = 83; break yy_forNext;
                default: break yy_forAction;
              }

            case 46:
              switch (yy_input) {
                case 9: yy_state = 47; break yy_forNext;
                case 14: yy_state = 48; break yy_forNext;
                default: break yy_forAction;
              }

            case 47:
              switch (yy_input) {
                case 14: yy_state = 48; break yy_forNext;
                default: break yy_forAction;
              }

            case 48:
              switch (yy_input) {
                case 9: yy_state = 84; break yy_forNext;
                case 16: yy_state = 85; break yy_forNext;
                default: break yy_forAction;
              }

            case 49:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 49; break yy_forNext;
                case 9: yy_state = 50; break yy_forNext;
                case 11: yy_state = 51; break yy_forNext;
                default: break yy_forAction;
              }

            case 50:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 49; break yy_forNext;
                case 11: yy_state = 51; break yy_forNext;
                case 9: yy_state = 86; break yy_forNext;
                default: break yy_forAction;
              }

            case 51:
              switch (yy_input) {
                case 12: yy_state = 54; break yy_forNext;
                case 9: yy_state = 87; break yy_forNext;
                default: break yy_forAction;
              }

            case 52:
              switch (yy_input) {
                case 14: yy_state = 48; break yy_forNext;
                case 9: yy_state = 53; break yy_forNext;
                case 12: yy_state = 54; break yy_forNext;
                default: break yy_forAction;
              }

            case 53:
              switch (yy_input) {
                case 14: yy_state = 48; break yy_forNext;
                case 12: yy_state = 54; break yy_forNext;
                default: break yy_forAction;
              }

            case 54:
              switch (yy_input) {
                case 9: yy_state = 88; break yy_forNext;
                case 13: yy_state = 89; break yy_forNext;
                default: break yy_forAction;
              }

            case 55:
              switch (yy_input) {
                case 9: yy_state = 57; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 56:
              switch (yy_input) {
                case 9: yy_state = 59; break yy_forNext;
                case 19: yy_state = 60; break yy_forNext;
                default: break yy_forAction;
              }

            case 57:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 58:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 90; break yy_forNext;
                default: break yy_forAction;
              }

            case 59:
              switch (yy_input) {
                case 19: yy_state = 60; break yy_forNext;
                default: break yy_forAction;
              }

            case 60:
              switch (yy_input) {
                case 9: yy_state = 91; break yy_forNext;
                case 20: yy_state = 92; break yy_forNext;
                default: break yy_forAction;
              }

            case 61:
              switch (yy_input) {
                case 9: yy_state = 64; break yy_forNext;
                case 17: yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 62:
              switch (yy_input) {
                case 9: yy_state = 66; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 64:
              switch (yy_input) {
                case 17: yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 65:
              switch (yy_input) {
                case 9: yy_state = 93; break yy_forNext;
                case 17: yy_state = 94; break yy_forNext;
                default: break yy_forAction;
              }

            case 66:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 67:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 95; break yy_forNext;
                default: break yy_forAction;
              }

            case 68:
              switch (yy_input) {
                case 6: 
                case 8: yy_isFinal = true; yy_state = 26; break yy_forNext;
                case 7: yy_state = 68; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 69; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 25; break yy_forNext;
              }

            case 69:
              switch (yy_input) {
                case 6: 
                case 8: yy_isFinal = true; yy_state = 26; break yy_forNext;
                case 7: yy_state = 68; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 96; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 25; break yy_forNext;
              }

            case 73:
              switch (yy_input) {
                case 9: yy_state = 74; break yy_forNext;
                case 25: yy_isFinal = true; yy_state = 75; break yy_forNext;
                default: break yy_forAction;
              }

            case 74:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 75; break yy_forNext;
                default: break yy_forAction;
              }

            case 75:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 97; break yy_forNext;
                default: break yy_forAction;
              }

            case 77:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 9: yy_state = 78; break yy_forNext;
                default: break yy_forAction;
              }

            case 78:
              switch (yy_input) {
                case 25: yy_isFinal = true; yy_state = 32; break yy_forNext;
                default: break yy_forAction;
              }

            case 81:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_pushback = true; yy_state = 81; break yy_forNext;
                case 9: yy_isFinal = true; yy_pushback = true; yy_state = 98; break yy_forNext;
                default: break yy_forAction;
              }

            case 82:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_pushback = true; yy_state = 81; break yy_forNext;
                default: break yy_forAction;
              }

            case 84:
              switch (yy_input) {
                case 16: yy_state = 85; break yy_forNext;
                default: break yy_forAction;
              }

            case 85:
              switch (yy_input) {
                case 9: yy_state = 99; break yy_forNext;
                case 17: yy_state = 100; break yy_forNext;
                default: break yy_forAction;
              }

            case 86:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 49; break yy_forNext;
                case 11: yy_state = 51; break yy_forNext;
                default: break yy_forAction;
              }

            case 87:
              switch (yy_input) {
                case 12: yy_state = 54; break yy_forNext;
                default: break yy_forAction;
              }

            case 88:
              switch (yy_input) {
                case 13: yy_state = 89; break yy_forNext;
                default: break yy_forAction;
              }

            case 89:
              switch (yy_input) {
                case 9: yy_state = 101; break yy_forNext;
                case 14: yy_state = 102; break yy_forNext;
                default: break yy_forAction;
              }

            case 91:
              switch (yy_input) {
                case 20: yy_state = 92; break yy_forNext;
                default: break yy_forAction;
              }

            case 92:
              switch (yy_input) {
                case 9: yy_state = 103; break yy_forNext;
                case 21: yy_state = 104; break yy_forNext;
                default: break yy_forAction;
              }

            case 93:
              switch (yy_input) {
                case 17: yy_state = 94; break yy_forNext;
                default: break yy_forAction;
              }

            case 94:
              switch (yy_input) {
                case 9: yy_state = 105; break yy_forNext;
                case 27: yy_state = 106; break yy_forNext;
                default: break yy_forAction;
              }

            case 96:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 68; break yy_forNext;
                default: break yy_forAction;
              }

            case 98:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_pushback = true; yy_state = 81; break yy_forNext;
                case 9: yy_state = 82; break yy_forNext;
                default: break yy_forAction;
              }

            case 99:
              switch (yy_input) {
                case 17: yy_state = 100; break yy_forNext;
                default: break yy_forAction;
              }

            case 100:
              switch (yy_input) {
                case 9: yy_state = 107; break yy_forNext;
                case 18: yy_isFinal = true; yy_state = 108; break yy_forNext;
                default: break yy_forAction;
              }

            case 101:
              switch (yy_input) {
                case 14: yy_state = 102; break yy_forNext;
                default: break yy_forAction;
              }

            case 102:
              switch (yy_input) {
                case 9: yy_state = 109; break yy_forNext;
                case 15: yy_state = 110; break yy_forNext;
                default: break yy_forAction;
              }

            case 103:
              switch (yy_input) {
                case 21: yy_state = 104; break yy_forNext;
                default: break yy_forAction;
              }

            case 104:
              switch (yy_input) {
                case 9: yy_state = 111; break yy_forNext;
                case 22: yy_state = 112; break yy_forNext;
                default: break yy_forAction;
              }

            case 105:
              switch (yy_input) {
                case 27: yy_state = 106; break yy_forNext;
                default: break yy_forAction;
              }

            case 106:
              switch (yy_input) {
                case 9: yy_state = 113; break yy_forNext;
                case 28: yy_state = 114; break yy_forNext;
                default: break yy_forAction;
              }

            case 107:
              switch (yy_input) {
                case 18: yy_isFinal = true; yy_state = 108; break yy_forNext;
                default: break yy_forAction;
              }

            case 108:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_noLookAhead = true; yy_state = 115; break yy_forNext;
                default: break yy_forAction;
              }

            case 109:
              switch (yy_input) {
                case 15: yy_state = 110; break yy_forNext;
                default: break yy_forAction;
              }

            case 110:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 116; break yy_forNext;
                case 9: yy_state = 117; break yy_forNext;
                default: break yy_forAction;
              }

            case 111:
              switch (yy_input) {
                case 22: yy_state = 112; break yy_forNext;
                default: break yy_forAction;
              }

            case 112:
              switch (yy_input) {
                case 9: yy_state = 118; break yy_forNext;
                case 23: yy_state = 119; break yy_forNext;
                default: break yy_forAction;
              }

            case 113:
              switch (yy_input) {
                case 28: yy_state = 114; break yy_forNext;
                default: break yy_forAction;
              }

            case 114:
              switch (yy_input) {
                case 9: yy_state = 120; break yy_forNext;
                case 16: yy_state = 121; break yy_forNext;
                default: break yy_forAction;
              }

            case 116:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 116; break yy_forNext;
                case 9: yy_isFinal = true; yy_state = 122; break yy_forNext;
                default: break yy_forAction;
              }

            case 117:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 116; break yy_forNext;
                case 9: yy_state = 123; break yy_forNext;
                default: break yy_forAction;
              }

            case 118:
              switch (yy_input) {
                case 23: yy_state = 119; break yy_forNext;
                default: break yy_forAction;
              }

            case 119:
              switch (yy_input) {
                case 9: yy_state = 124; break yy_forNext;
                case 19: yy_state = 125; break yy_forNext;
                default: break yy_forAction;
              }

            case 120:
              switch (yy_input) {
                case 16: yy_state = 121; break yy_forNext;
                default: break yy_forAction;
              }

            case 121:
              switch (yy_input) {
                case 9: yy_state = 126; break yy_forNext;
                case 29: yy_state = 127; break yy_forNext;
                default: break yy_forAction;
              }

            case 122:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 116; break yy_forNext;
                case 9: yy_state = 123; break yy_forNext;
                default: break yy_forAction;
              }

            case 123:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 116; break yy_forNext;
                default: break yy_forAction;
              }

            case 124:
              switch (yy_input) {
                case 19: yy_state = 125; break yy_forNext;
                default: break yy_forAction;
              }

            case 125:
              switch (yy_input) {
                case 9: yy_state = 128; break yy_forNext;
                case 24: yy_state = 129; break yy_forNext;
                default: break yy_forAction;
              }

            case 126:
              switch (yy_input) {
                case 29: yy_state = 127; break yy_forNext;
                default: break yy_forAction;
              }

            case 127:
              switch (yy_input) {
                case 9: yy_state = 130; break yy_forNext;
                case 30: yy_state = 131; break yy_forNext;
                default: break yy_forAction;
              }

            case 128:
              switch (yy_input) {
                case 24: yy_state = 129; break yy_forNext;
                default: break yy_forAction;
              }

            case 129:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 129; break yy_forNext;
                case 9: yy_state = 132; break yy_forNext;
                case 10: yy_isFinal = true; yy_state = 133; break yy_forNext;
                default: break yy_forAction;
              }

            case 130:
              switch (yy_input) {
                case 30: yy_state = 131; break yy_forNext;
                default: break yy_forAction;
              }

            case 131:
              switch (yy_input) {
                case 9: yy_state = 134; break yy_forNext;
                case 23: yy_state = 135; break yy_forNext;
                default: break yy_forAction;
              }

            case 132:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 129; break yy_forNext;
                case 10: yy_isFinal = true; yy_state = 133; break yy_forNext;
                case 9: yy_state = 136; break yy_forNext;
                default: break yy_forAction;
              }

            case 133:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 137; break yy_forNext;
                case 9: yy_state = 138; break yy_forNext;
                default: break yy_forAction;
              }

            case 134:
              switch (yy_input) {
                case 23: yy_state = 135; break yy_forNext;
                default: break yy_forAction;
              }

            case 135:
              switch (yy_input) {
                case 9: yy_state = 139; break yy_forNext;
                case 31: yy_state = 140; break yy_forNext;
                default: break yy_forAction;
              }

            case 136:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 129; break yy_forNext;
                default: break yy_forAction;
              }

            case 137:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_state = 133; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 137; break yy_forNext;
                default: break yy_forAction;
              }

            case 138:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 137; break yy_forNext;
                default: break yy_forAction;
              }

            case 139:
              switch (yy_input) {
                case 31: yy_state = 140; break yy_forNext;
                default: break yy_forAction;
              }

            case 140:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 140; break yy_forNext;
                case 9: yy_state = 141; break yy_forNext;
                case 10: yy_state = 142; break yy_forNext;
                default: break yy_forAction;
              }

            case 141:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 140; break yy_forNext;
                case 10: yy_state = 142; break yy_forNext;
                case 9: yy_state = 143; break yy_forNext;
                default: break yy_forAction;
              }

            case 142:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 144; break yy_forNext;
                case 9: yy_state = 145; break yy_forNext;
                case 20: yy_state = 146; break yy_forNext;
                case 32: yy_state = 147; break yy_forNext;
                default: break yy_forAction;
              }

            case 143:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 140; break yy_forNext;
                default: break yy_forAction;
              }

            case 144:
              switch (yy_input) {
                case 9: yy_state = 142; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_state = 144; break yy_forNext;
                case 20: yy_state = 146; break yy_forNext;
                case 32: yy_state = 147; break yy_forNext;
                default: break yy_forAction;
              }

            case 145:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 144; break yy_forNext;
                case 20: yy_state = 146; break yy_forNext;
                case 32: yy_state = 147; break yy_forNext;
                case 9: yy_state = 148; break yy_forNext;
                default: break yy_forAction;
              }

            case 146:
              switch (yy_input) {
                case 9: yy_state = 149; break yy_forNext;
                case 21: yy_state = 150; break yy_forNext;
                default: break yy_forAction;
              }

            case 147:
              switch (yy_input) {
                case 20: yy_state = 146; break yy_forNext;
                case 9: yy_state = 148; break yy_forNext;
                default: break yy_forAction;
              }

            case 148:
              switch (yy_input) {
                case 20: yy_state = 146; break yy_forNext;
                case 9: yy_state = 151; break yy_forNext;
                default: break yy_forAction;
              }

            case 149:
              switch (yy_input) {
                case 21: yy_state = 150; break yy_forNext;
                default: break yy_forAction;
              }

            case 150:
              switch (yy_input) {
                case 9: yy_state = 152; break yy_forNext;
                case 19: yy_state = 153; break yy_forNext;
                default: break yy_forAction;
              }

            case 151:
              switch (yy_input) {
                case 20: yy_state = 146; break yy_forNext;
                default: break yy_forAction;
              }

            case 152:
              switch (yy_input) {
                case 19: yy_state = 153; break yy_forNext;
                default: break yy_forAction;
              }

            case 153:
              switch (yy_input) {
                case 9: yy_state = 154; break yy_forNext;
                case 17: yy_state = 155; break yy_forNext;
                default: break yy_forAction;
              }

            case 154:
              switch (yy_input) {
                case 17: yy_state = 155; break yy_forNext;
                default: break yy_forAction;
              }

            case 155:
              switch (yy_input) {
                case 9: yy_state = 156; break yy_forNext;
                case 16: yy_state = 157; break yy_forNext;
                default: break yy_forAction;
              }

            case 156:
              switch (yy_input) {
                case 16: yy_state = 157; break yy_forNext;
                default: break yy_forAction;
              }

            case 157:
              switch (yy_input) {
                case 9: yy_state = 158; break yy_forNext;
                case 19: yy_state = 159; break yy_forNext;
                default: break yy_forAction;
              }

            case 158:
              switch (yy_input) {
                case 19: yy_state = 159; break yy_forNext;
                default: break yy_forAction;
              }

            case 159:
              switch (yy_input) {
                case 9: yy_state = 160; break yy_forNext;
                case 17: yy_state = 161; break yy_forNext;
                default: break yy_forAction;
              }

            case 160:
              switch (yy_input) {
                case 17: yy_state = 161; break yy_forNext;
                default: break yy_forAction;
              }

            case 161:
              switch (yy_input) {
                case 9: yy_state = 162; break yy_forNext;
                case 28: yy_state = 163; break yy_forNext;
                default: break yy_forAction;
              }

            case 162:
              switch (yy_input) {
                case 28: yy_state = 163; break yy_forNext;
                default: break yy_forAction;
              }

            case 163:
              switch (yy_input) {
                case 9: yy_state = 164; break yy_forNext;
                case 17: yy_state = 165; break yy_forNext;
                default: break yy_forAction;
              }

            case 164:
              switch (yy_input) {
                case 17: yy_state = 165; break yy_forNext;
                default: break yy_forAction;
              }

            case 165:
              switch (yy_input) {
                case 9: yy_state = 166; break yy_forNext;
                case 33: yy_state = 167; break yy_forNext;
                default: break yy_forAction;
              }

            case 166:
              switch (yy_input) {
                case 33: yy_state = 167; break yy_forNext;
                default: break yy_forAction;
              }

            case 167:
              switch (yy_input) {
                case 9: yy_state = 168; break yy_forNext;
                case 27: yy_state = 169; break yy_forNext;
                default: break yy_forAction;
              }

            case 168:
              switch (yy_input) {
                case 27: yy_state = 169; break yy_forNext;
                default: break yy_forAction;
              }

            case 169:
              switch (yy_input) {
                case 9: yy_state = 170; break yy_forNext;
                case 16: yy_state = 171; break yy_forNext;
                default: break yy_forAction;
              }

            case 170:
              switch (yy_input) {
                case 16: yy_state = 171; break yy_forNext;
                default: break yy_forAction;
              }

            case 171:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 9: yy_state = 173; break yy_forNext;
                case 32: yy_state = 174; break yy_forNext;
                default: break yy_forAction;
              }

            case 172:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 9: yy_state = 175; break yy_forNext;
                case 20: yy_state = 176; break yy_forNext;
                default: break yy_forAction;
              }

            case 173:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 32: yy_state = 174; break yy_forNext;
                case 9: yy_state = 177; break yy_forNext;
                default: break yy_forAction;
              }

            case 174:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 9: yy_state = 177; break yy_forNext;
                default: break yy_forAction;
              }

            case 175:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 20: yy_state = 176; break yy_forNext;
                case 9: yy_state = 178; break yy_forNext;
                default: break yy_forAction;
              }

            case 176:
              switch (yy_input) {
                case 9: yy_state = 179; break yy_forNext;
                case 21: yy_state = 180; break yy_forNext;
                default: break yy_forAction;
              }

            case 177:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 9: yy_state = 181; break yy_forNext;
                default: break yy_forAction;
              }

            case 178:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                case 20: yy_state = 176; break yy_forNext;
                default: break yy_forAction;
              }

            case 179:
              switch (yy_input) {
                case 21: yy_state = 180; break yy_forNext;
                default: break yy_forAction;
              }

            case 180:
              switch (yy_input) {
                case 9: yy_state = 182; break yy_forNext;
                case 19: yy_state = 183; break yy_forNext;
                default: break yy_forAction;
              }

            case 181:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 172; break yy_forNext;
                default: break yy_forAction;
              }

            case 182:
              switch (yy_input) {
                case 19: yy_state = 183; break yy_forNext;
                default: break yy_forAction;
              }

            case 183:
              switch (yy_input) {
                case 9: yy_state = 184; break yy_forNext;
                case 17: yy_state = 185; break yy_forNext;
                default: break yy_forAction;
              }

            case 184:
              switch (yy_input) {
                case 17: yy_state = 185; break yy_forNext;
                default: break yy_forAction;
              }

            case 185:
              switch (yy_input) {
                case 9: yy_state = 186; break yy_forNext;
                case 16: yy_state = 187; break yy_forNext;
                default: break yy_forAction;
              }

            case 186:
              switch (yy_input) {
                case 16: yy_state = 187; break yy_forNext;
                default: break yy_forAction;
              }

            case 187:
              switch (yy_input) {
                case 9: yy_state = 188; break yy_forNext;
                case 19: yy_state = 189; break yy_forNext;
                default: break yy_forAction;
              }

            case 188:
              switch (yy_input) {
                case 19: yy_state = 189; break yy_forNext;
                default: break yy_forAction;
              }

            case 189:
              switch (yy_input) {
                case 9: yy_state = 190; break yy_forNext;
                case 17: yy_state = 191; break yy_forNext;
                default: break yy_forAction;
              }

            case 190:
              switch (yy_input) {
                case 17: yy_state = 191; break yy_forNext;
                default: break yy_forAction;
              }

            case 191:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 191; break yy_forNext;
                case 9: yy_state = 192; break yy_forNext;
                case 10: yy_isFinal = true; yy_state = 193; break yy_forNext;
                default: break yy_forAction;
              }

            case 192:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 191; break yy_forNext;
                case 10: yy_isFinal = true; yy_state = 193; break yy_forNext;
                case 9: yy_state = 194; break yy_forNext;
                default: break yy_forAction;
              }

            case 193:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 195; break yy_forNext;
                case 9: yy_state = 196; break yy_forNext;
                default: break yy_forAction;
              }

            case 194:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_state = 191; break yy_forNext;
                default: break yy_forAction;
              }

            case 195:
              switch (yy_input) {
                case 9: yy_isFinal = true; yy_state = 193; break yy_forNext;
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 195; break yy_forNext;
                default: break yy_forAction;
              }

            case 196:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 8: yy_isFinal = true; yy_state = 195; break yy_forNext;
                default: break yy_forAction;
              }

            default:
              yy_ScanError(YY_ILLEGAL_STATE);
              break;
          } }

          if ( yy_isFinal ) {
            yy_was_pushback = yy_pushback;
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( yy_noLookAhead ) break yy_forAction;
          }

        }
      }

      if (yy_was_pushback)
        yy_markedPos = yy_pushbackPos;

      switch (yy_action) {    

        case 32: 
        case 72: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue; }
        case 198: break;
        case 25: 
        case 26: 
        case 28: 
        case 69: 
        case 96: 
          {  yypushback(1); yybegin(UnDelimitedString); string.setLength(0); }
        case 199: break;
        case 22: 
        case 63: 
          {  yybegin(YYINITIAL);  if (foundContentTypeValue) hasMore = false; return HTMLHeadTokenizerConstants.MetaTagEnd; }
        case 200: break;
        case 40: 
        case 80: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTermintatedUnDelimitedStringValue; }
        case 201: break;
        case 67: 
        case 95: 
          {  yybegin(YYINITIAL); if (foundContentTypeValue) hasMore = false; return HTMLHeadTokenizerConstants.MetaTagEnd; }
        case 202: break;
        case 75: 
        case 97: 
          {  yypushback(yylength()); popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue; }
        case 203: break;
        case 116: 
        case 122: 
          { if (yychar == 0 ) {yybegin(ST_XMLDecl); return XMLHeadTokenizerConstants.XMLDeclStart;} }
        case 204: break;
        case 9: 
        case 10: 
        case 11: 
        case 12: 
        case 13: 
        case 14: 
        case 15: 
        case 16: 
        case 17: 
        case 18: 
        case 19: 
        case 20: 
        case 21: 
        case 23: 
        case 24: 
        case 27: 
        case 33: 
        case 36: 
        case 39: 
          { if(yychar > MAX_TO_SCAN) {hasMore=false; return EncodingParserConstants.MAX_CHARS_REACHED;} }
        case 205: break;
        case 108: 
        case 115: 
          { yybegin(ST_META_TAG); return HTMLHeadTokenizerConstants.MetaTagStart; }
        case 206: break;
        case 58: 
        case 90: 
          { yybegin(YYINITIAL);  return XMLHeadTokenizerConstants.XMLDeclEnd; }
        case 207: break;
        case 193: 
        case 195: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); foundContentTypeValue=true; return HTMLHeadTokenizerConstants.MetaTagContentType; }
        case 208: break;
        case 133: 
        case 137: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return XMLHeadTokenizerConstants.XMLDelEncoding; }
        case 209: break;
        case 83: 
          { hasMore = false; return EncodingParserConstants.UTF83ByteBOM; }
        case 210: break;
        case 43: 
          { hasMore = false; return EncodingParserConstants.UTF16BE; }
        case 211: break;
        case 44: 
          { hasMore = false; return EncodingParserConstants.UTF16LE; }
        case 212: break;
        case 35: 
        case 76: 
          {  popState(); valueText = string.toString(); return EncodingParserConstants.StringValue;  }
        case 213: break;
        case 31: 
        case 34: 
        case 37: 
          {  string.append( yytext() );  }
        case 214: break;
        case 30: 
        case 71: 
          {  yybegin(SQ_STRING); string.setLength(0);  }
        case 215: break;
        case 29: 
        case 70: 
          {  yybegin(DQ_STRING); string.setLength(0);  }
        case 216: break;
        case 38: 
        case 79: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.UnDelimitedStringValue;  }
        case 217: break;
        case 41: 
        case 81: 
        case 98: 
          {  pushCurrentState(); yybegin(UnDelimitedCharset); string.append( yytext() );  }
        case 218: break;
        case 42: 
          { yypushback(1); popState();  }
        case 219: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              { hasMore = false; return EncodingParserConstants.EOF; }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
