/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.tests.translation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.core.tests.Activator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TestHtmlTranslation
extends TestCase {
    private IModelManager fModelManager = StructuredModelManager.getModelManager();
    private static final String testFilesDirectory = "testFiles";
    static /* synthetic */ Class class$0;

    public void testHTMLFormat() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        IStructuredModel structuredModel = this.getModel("test1.html");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        structuredModel.getStructuredDocument().get();
        String expectedFileName = "test1.html";
        this.getFile(expectedFileName);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"expected function definition is missing", ((translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText().indexOf("function blah()") >= 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    private String readFile(String fileName) {
        String inputString = null;
        InputStream fileInputStream = null;
        try {
            URL url = Activator.getDefault().getBundle().getEntry(fileName);
            fileInputStream = url.openStream();
            byte[] inputBuffer = new byte[1024];
            inputString = new String();
            int bytesRead = -1;
            while ((bytesRead = fileInputStream.read(inputBuffer)) != -1) {
                String bufferString = new String(inputBuffer);
                bufferString = bufferString.substring(0, bytesRead);
                inputString = inputString.concat(bufferString);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException exception) {
            StringWriter s = new StringWriter();
            exception.printStackTrace(new PrintWriter(s));
            TestHtmlTranslation.fail((String)s.toString());
        }
        return inputString;
    }

    private static void printException(Exception exception) {
        exception.printStackTrace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStructuredModel getModel(String fileName) {
        IStructuredModel structuredModel = null;
        InputStream inputStream = null;
        try {
            try {
                String input = this.getFile(fileName);
                inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
                String id = inputStream.toString().concat(fileName);
                structuredModel = this.fModelManager.getModelForRead(id, inputStream, null);
            }
            catch (Exception exception) {
                StringWriter s = new StringWriter();
                exception.printStackTrace(new PrintWriter(s));
                TestHtmlTranslation.fail((String)s.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return structuredModel;
        }
        inputStream.close();
        return structuredModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStructuredModel getSharedModel(String id, String contents) {
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            try {
                inputStream = new ByteArrayInputStream(contents.getBytes("UTF8"));
                structuredModel = this.fModelManager.getModelForRead(id, (InputStream)inputStream, null);
            }
            catch (Exception exception) {
                StringWriter s = new StringWriter();
                exception.printStackTrace(new PrintWriter(s));
                TestHtmlTranslation.fail((String)s.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return structuredModel;
        }
        ((InputStream)inputStream).close();
        return structuredModel;
    }

    private String getFile(String fileName) {
        return this.readFile("/testFiles/".concat(fileName));
    }

    public void testMangleTagInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <custom:tag/>5; if(a < 4) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"tag included", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).indexOf("<custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"tag included", (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSideAndClientTagInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <custom:tag/>5;\nif(a < <%= 4 %>) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("var dropped\n" + translated), (translated.indexOf("var a = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("if dropped\n" + translated), (translated.indexOf("5;\nif(a <") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("block dropped\n" + translated), (translated.indexOf(") {} ; ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleTagAndServerSideInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <%= 4 %>5;\nif(a < <custom:tag/>) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("var dropped\n" + translated), (translated.indexOf("var a = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("if dropped\n" + translated), (translated.indexOf("5;\nif(a < ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("block dropped\n" + translated), (translated.indexOf(") {} ; ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSide1InJSCheckProblems() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <%= javaObject.getText() %>; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSide2InJSCheckProblems() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleServerSide1InJSCheckProblems() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <%= javaObject.getText() %>;  <%= javaObject.getText() %></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleServerSide2InJSCheckProblems() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>;  <? serverObject.getText() ?></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideInJS_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideInJSwithXMLcomment_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> <!-- var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"              var text = _$tag_______________________; _$tag___ _$tag___ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideAndClientTagInJS_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <server:tag/> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideAndClientTagInJS_and_CheckProblems2() {
        String fileName = String.valueOf(this.getName()) + ".jsp";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <server:tag/> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testJustClientTagInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><custom:tag /></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("/") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf(">") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testJustServer1SideInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><%= %></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testJustServer2SideInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><? !!!!!!!!!!!!!! ?></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testLeadingXMLComment() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, " <script> <!--  </script> ");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"                ", (String)translated);
        structuredModel.releaseFromRead();
    }

    public void testXMLComment() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> if(a) <!-- --> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"         if(a) <!-- --> ", (String)translated);
        structuredModel.releaseFromRead();
    }

    public void testCDATAInJS() {
        JsTranslationAdapter translationAdapter;
        IJsTranslation translation;
        String translated;
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <![CDATA[ serverObject.getText() ]]> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        IDOMDocument iDOMDocument = ((IDOMModel)structuredModel).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestHtmlTranslation.assertTrue((String)"translation empty", ((translated = (translation = (translationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz)).getJsTranslation(false)).getJsText()).length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("CDATA") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("[") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA end found", (translated.indexOf("]") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }
}

