/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.HashMap;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class BasicAnalyseTests
extends AbstractRegressionTest {
    public BasicAnalyseTests(String name) {
        super(name);
    }

    public void testBug251374_1() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb.toString();\n}\nb = 2;\nboo();"}, "", null, false, custom);
    }

    public void testBug251374_2() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb.toString();\n}\nboo();"}, "----------\n1. ERROR in X.js (at line 3)\n\tb.toString();\n\t^\nNull pointer access: The variable b can only be null at this location\n----------\n", null, false, custom);
    }

    public void testBug251374_3() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();"}, "----------\n1. ERROR in X.js (at line 4)\n\tb.toString();\n\t^\nNull pointer access: The variable b can only be null at this location\n----------\n", null, false, custom);
    }

    public void testBug251374_4() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();\nb.toString();"}, "----------\n1. ERROR in X.js (at line 4)\n\tb.toString();\n\t^\nNull pointer access: The variable b can only be null at this location\n----------\n", null, false, custom);
    }

    public void testBug251374_5() {
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();\nb.toString();"}, "");
    }

    public void testBug286029_1() {
        this.runNegativeTest(new String[]{"X.js", "var sub;\nif(!sub) sub = {};"}, "");
    }

    public void testBug286029_2() {
        this.runNegativeTest(new String[]{"X.js", "function abc() {\nvar sub;\nif(!sub) sub = {};\n}"}, "----------\n1. WARNING in X.js (at line 3)\n\tif(!sub) sub = {};\n\t    ^^^\nThe local variable sub may not have been initialized\n----------\n");
    }

    public void testBug286029_3() {
        this.runNegativeTest(new String[]{"X.js", "function abc() {\nvar sub; sub = {};\nif(!sub) sub = {};\n}"}, "");
    }

    public void testBug251225_1() {
        this.runNegativeTest(new String[]{"X.js", "var temp = function () {};\ntemp();"}, "");
    }

    public void testBug251225_2() {
        this.runNegativeTest(new String[]{"X.js", "var temp = function () {};\nnew temp();"}, "");
    }

    public void testBug251225_3() {
        this.runNegativeTest(new String[]{"X.js", "function testFunction() {\nvar temp = function () {};\nfunction temp2(){}new temp2();}"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar temp = function () {};\n\t    ^^^^\nThe local variable temp is never read\n----------\n");
    }
}

