/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter.comment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.jsdt.core.tests.formatter.comment.CommentFormatterUtil;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;

public abstract class CommentTestCase
extends SuiteOfTestCases {
    public static final String DELIMITER = TextUtilities.getDefaultLineDelimiter((IDocument)new Document());
    private Map fUserOptions;

    public static Test buildTestSuite(Class evaluationTestClass) {
        return CommentTestCase.buildTestSuite(evaluationTestClass, null);
    }

    public static Test buildTestSuite(Class evaluationTestClass, String suiteName) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite(suiteName == null ? evaluationTestClass.getName() : suiteName);
        List tests = CommentTestCase.buildTestsList((Class)evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        return suite;
    }

    protected CommentTestCase(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.fUserOptions = null;
    }

    protected abstract int getCommentKind();

    protected Map getUserOptions() {
        return this.fUserOptions;
    }

    protected void setUserOption(String name, String value) {
        if (this.fUserOptions == null) {
            this.fUserOptions = new HashMap();
        }
        this.fUserOptions.put(name, value);
    }

    protected void setUserOption(Map options) {
        if (this.fUserOptions == null) {
            this.fUserOptions = options;
        } else {
            this.fUserOptions.putAll(options);
        }
    }

    protected final String testFormat(String text) {
        return this.testFormat(text, 0, text.length());
    }

    protected final String testFormat(String text, Map options) {
        return this.testFormat(text, 0, text.length(), this.getCommentKind(), options);
    }

    protected String testFormat(String text, int offset, int length) {
        return this.testFormat(text, offset, length, this.getCommentKind());
    }

    protected String testFormat(String text, int offset, int length, int kind) {
        return this.testFormat(text, offset, length, kind, this.getUserOptions());
    }

    protected String testFormat(String text, int offset, int length, int kind, Map options) {
        CommentTestCase.assertNotNull((Object)text);
        CommentTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        CommentTestCase.assertTrue((offset < text.length() ? 1 : 0) != 0);
        CommentTestCase.assertTrue((length >= 0 ? 1 : 0) != 0);
        CommentTestCase.assertTrue((offset + length <= text.length() ? 1 : 0) != 0);
        CommentTestCase.assertTrue((kind == 64 || kind == 32 || kind == 16 ? 1 : 0) != 0);
        return CommentFormatterUtil.format(kind, text, offset, length, CommentFormatterUtil.createOptions(options));
    }

    protected String testFormat(String text, int offset, int length, int kind, int indentationLevel) {
        CommentTestCase.assertNotNull((Object)text);
        CommentTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        CommentTestCase.assertTrue((offset < text.length() ? 1 : 0) != 0);
        CommentTestCase.assertTrue((length >= 0 ? 1 : 0) != 0);
        CommentTestCase.assertTrue((offset + length <= text.length() ? 1 : 0) != 0);
        CommentTestCase.assertTrue((kind == 64 || kind == 32 || kind == 16 ? 1 : 0) != 0);
        return CommentFormatterUtil.format(kind, text, offset, length, indentationLevel, CommentFormatterUtil.createOptions(this.getUserOptions()));
    }
}

