/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class ExclusionPatternsTests
extends ModifyingResourceTests {
    IJavaScriptProject project;
    static /* synthetic */ Class class$0;

    public ExclusionPatternsTests(String name) {
        super(name);
    }

    protected void setClasspath(String[] sourceFoldersAndExclusionPatterns) throws JavaScriptModelException {
        this.project.setRawIncludepath(this.createClasspath(sourceFoldersAndExclusionPatterns, false, true), null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createJavaProject("P", new String[]{"src"});
        this.startDeltas();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.ExclusionPatternsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ExclusionPatternsTests.buildModelTestSuite(clazz);
    }

    protected void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void testAddExclusionOnCompilationUnit() throws CoreException {
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.js", pkg.getNonJavaScriptResources());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExclusionOnFolderUnderProject() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P1", new String[]{""});
            this.createFolder("/P1/doc");
            this.clearDeltas();
            javaProject.setRawIncludepath(this.createClasspath(new String[]{"/P1", "doc/"}, false, true), null);
            this.assertDeltas("Unexpected deltas", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t<project root>[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P1/.classpath)[*]");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1");
            this.assertSortedElementsEqual("Unexpected children", "<default> [in <project root> [in P1]]", root.getChildren());
            this.assertResourceNamesEqual("Unexpected non-java resources of project", ".classpath\n.project\ndoc", javaProject.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    public void testAddExclusionOnPackage() throws CoreException {
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getNonJavaScriptResources());
    }

    /*
     * Exception decompiling
     */
    public void testAddExclusionOnPrimaryWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 121->125)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testAddToExcludedFolder() throws CoreException {
        this.createFolder("/P/src/icons");
        this.setClasspath(new String[]{"/P/src", "icons/"});
        this.clearDeltas();
        this.createFile("/P/src/icons/my.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/icons)[*]");
        this.clearDeltas();
        this.deleteFile("/P/src/icons/my.txt");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/icons)[*]");
    }

    public void testCreateExcludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.clearDeltas();
        pkg.createCompilationUnit("A.js", "package p;\npublic class A {\n}", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/A.java)[+]");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.js", pkg.getNonJavaScriptResources());
    }

    public void testCreateExcludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.clearDeltas();
        root.createPackageFragment("p", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/p)[+]");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getNonJavaScriptResources());
    }

    public void testCreateExcludedPackage2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "org/*|org/eclipse/*"});
        this.clearDeltas();
        this.createFolder("/P/src/org/eclipse/mypack");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/org)[+]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\norg.eclipse.mypack [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "org", root.getNonJavaScriptResources());
    }

    public void testCreateExcludedAndIncludedPackages() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.clearDeltas();
        this.createFolder("/P/src/p1/p2");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp1[+]: {}");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\np1 [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p2", root.getPackageFragment("p1").getNonJavaScriptResources());
    }

    public void testCreateResourceExcludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/A.java)[+]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.js", pkg.getNonJavaScriptResources());
    }

    public void testCreateResourceExcludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        this.clearDeltas();
        this.createFolder("/P/src/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/p)[+]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getNonJavaScriptResources());
    }

    public void testIsOnClasspath1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", ""});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        ExclusionPatternsTests.assertTrue((String)"Resource should be on classpath", (boolean)this.project.isOnIncludepath((IResource)file));
        IJavaScriptUnit cu = this.getCompilationUnit("/P/src/p/A.js");
        ExclusionPatternsTests.assertTrue((String)"CU should be on classpath", (boolean)this.project.isOnIncludepath((IJavaScriptElement)cu));
    }

    public void testIsOnClasspath2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        ExclusionPatternsTests.assertTrue((String)"Resource should not be on classpath", (!this.project.isOnIncludepath((IResource)file) ? 1 : 0) != 0);
        IJavaScriptUnit cu = this.getCompilationUnit("/P/src/p/A.js");
        ExclusionPatternsTests.assertTrue((String)"CU should not be on classpath", (!this.project.isOnIncludepath((IJavaScriptElement)cu) ? 1 : 0) != 0);
    }

    public void testIsOnClasspath3() throws CoreException {
        this.setClasspath(new String[]{"/P/src", ""});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        ExclusionPatternsTests.assertTrue((String)"Resource should be on classpath", (boolean)this.project.isOnIncludepath((IResource)file));
    }

    public void testIsOnClasspath4() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/**"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        ExclusionPatternsTests.assertTrue((String)"Resource should not be on classpath", (!this.project.isOnIncludepath((IResource)file) ? 1 : 0) != 0);
    }

    public void testNestedSourceFolder1() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        IPackageFragmentRoot root1 = this.getPackageFragmentRoot("/P/src1");
        this.assertResourceNamesEqual("Unexpected non-java resources for /P/src1", "", root1.getNonJavaScriptResources());
    }

    public void testNestedSourceFolder2() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/A.js", "public class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tA.java[+]: {}");
    }

    public void testNestedSourceFolder3() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/readme.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CONTENT}\n\t\tResourceDelta(/P/src1/src2/readme.txt)[+]");
    }

    public void testNestedSourceFolder4() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder5() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder6() throws CoreException {
        this.setClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.createFolder("/P/src1/p");
        this.clearDeltas();
        this.moveFolder("/P/src1/p", "/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[-]: {MOVED_TO(p [in src1/src2 [in P]])}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {MOVED_FROM(p [in src1 [in P]])}");
    }

    public void testRenameExcludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.js"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tB.java[+]: {}\n\t\t\tResourceDelta(/P/src/p/A.java)[-]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "B.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testRenameExcludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        IPackageFragment pkg = root.createPackageFragment("p", false, null);
        this.clearDeltas();
        pkg.getResource().move((IPath)new Path("/P/src/q"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tq[+]: {}\n\t\tResourceDelta(/P/src/p)[-]");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\nq [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    public void testRenameResourceExcludedCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.js"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tB.java[+]: {}\n\t\t\tResourceDelta(/P/src/p/A.java)[-]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "B.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testSearchWithExcludedCompilationUnit1() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "**/A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        ExclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"", (String)resultCollector.toString());
    }

    public void testSearchWithExcludedCompilationUnit2() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.setClasspath(new String[]{"/P/src", ""});
        AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        this.search("A", 0, 0, SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("P")}), (SearchRequestor)resultCollector);
        ExclusionPatternsTests.assertEquals((String)"Unexpected matches found", (String)"src/p/A.java p.A [A]", (String)resultCollector.toString());
    }

    public void testRemoveExcludedAndIncludedPackages() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p1/p2/"});
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.createFolder("/P/src/p1/p2");
        this.clearDeltas();
        this.deleteFolder("/P/src/p1");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp1[-]: {}");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    public void testRenameResourceExcludedPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p/"});
        IFolder folder = this.createFolder("/P/src/p");
        this.clearDeltas();
        folder.move((IPath)new Path("/P/src/q"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tq[+]: {}\n\t\tResourceDelta(/P/src/p)[-]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\nq [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearchPotentialMatchInOutput() throws CoreException {
        try {
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptProject javaProject = ExclusionPatternsTests.this.createJavaProject("P2", new String[0]);
                    javaProject.setRawIncludepath(ExclusionPatternsTests.this.createClasspath(new String[]{"/P2", "src/", "/P2/src", ""}, false, true), null);
                    ExclusionPatternsTests.this.createFile("/P2/bin/X.js", "public class X {\n}");
                }
            }, null);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.getJavaProject("P")});
            this.search("X", 0, 0, scope, (SearchRequestor)resultCollector);
            ExclusionPatternsTests.assertEquals((String)"", (String)resultCollector.toString());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    public void testRemoveExclusionOnCompilationUnit() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "A.js"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.js", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", ""});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "A.java [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getNonJavaScriptResources());
    }

    public void testRemoveExclusionOnPackage() throws CoreException {
        this.setClasspath(new String[]{"/P/src", "p"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setClasspath(new String[]{"/P/src", ""});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\np [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getNonJavaScriptResources());
    }
}

