/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterables.TransformationListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListIterableTests
extends TestCase {
    public TransformationListIterableTests(String name) {
        super(name);
    }

    public void testTransform1() {
        int i = 1;
        for (Integer integer : this.buildIterable1()) {
            TransformationListIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable1() {
        return this.buildTransformationListIterable1(this.buildNestedList());
    }

    private Iterable<Integer> buildTransformationListIterable1(List<String> nestedList) {
        return new TransformationListIterable<String, Integer>(nestedList){

            protected Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    public void testTransform2() {
        int i = 1;
        for (Integer integer : this.buildIterable2()) {
            TransformationListIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable2() {
        return this.buildTransformationListIterable2(this.buildNestedList());
    }

    private Iterable<Integer> buildTransformationListIterable2(List<String> nestedList) {
        return new TransformationListIterable(nestedList, this.buildTransformer());
    }

    private Transformer<String, Integer> buildTransformer() {
        return new Transformer<String, Integer>(){

            public Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    private List<String> buildNestedList() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    public void testToString() {
        TransformationListIterableTests.assertNotNull((Object)this.buildIterable1().toString());
    }

    public void testMissingTransformer() {
        TransformationListIterable iterable = new TransformationListIterable(this.buildNestedList());
        boolean exCaught = false;
        try {
            int i = 1;
            for (Integer integer : iterable) {
                TransformationListIterableTests.assertEquals((int)i++, (int)integer);
            }
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        TransformationListIterableTests.assertTrue((boolean)exCaught);
    }
}

