/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.EMFWorkbenchEditPlugin;

public class ResourceSetWorkbenchEditSynchronizer
extends ResourceSetWorkbenchSynchronizer
implements IResourceDeltaVisitor {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_EXTENSION = "java";
    private static final String JAVA_ARCHIVE = "jar";
    private Set recentlySavedFiles = new HashSet();
    private Map ignoredFilesCache = new HashMap();
    protected List deferredRemoveResources = new ArrayList();
    protected List deferredUnloadResources = new ArrayList();
    protected List deferredLoadResources = new ArrayList();
    protected List autoloadResourcesURIs = new ArrayList();
    protected List autoloadResourcesExts = new ArrayList();
    private ILock lock;
    private static final long delay = 30L;

    public ResourceSetWorkbenchEditSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        super(aResourceSet, aProject);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        super.resourceChanged(event);
        try {
            try {
                this.acceptDelta(event);
                this.notifyExtendersIfNecessary();
                this.processDeferredResources();
            }
            catch (Exception e) {
                EMFWorkbenchEditPlugin.logError(e);
                this.deferredRemoveResources.clear();
                this.deferredUnloadResources.clear();
                this.deferredLoadResources.clear();
            }
        }
        finally {
            this.deferredRemoveResources.clear();
            this.deferredUnloadResources.clear();
            this.deferredLoadResources.clear();
        }
    }

    protected void processDeferredRemovedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredRemoveResources.size()) {
            resource = (Resource)this.deferredRemoveResources.get(i);
            this.resourceSet.getResources().remove((Object)resource);
            resource.unload();
            ++i;
        }
    }

    protected void processDeferredUnloadedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredUnloadResources.size()) {
            resource = (Resource)this.deferredUnloadResources.get(i);
            resource.unload();
            ++i;
        }
    }

    private void processDeferredLoadResources() {
        URI uri = null;
        int i = 0;
        while (i < this.deferredLoadResources.size()) {
            uri = (URI)this.deferredLoadResources.get(i);
            try {
                this.resourceSet.getResource(uri, true);
            }
            catch (WrappedException ex) {
                EMFWorkbenchEditPlugin.logError(ex);
            }
            ++i;
        }
    }

    private ILock getLock() {
        if (this.lock == null) {
            this.lock = Platform.getJobManager().newLock();
        }
        return this.lock;
    }

    private void releaseLock() {
        this.getLock().release();
    }

    private boolean aquireLock() throws InterruptedException {
        return this.getLock().acquire(30L);
    }

    protected void acceptDelta(final IResourceChangeEvent event) {
        boolean hasLocked = false;
        try {
            hasLocked = this.aquireLock();
        }
        catch (InterruptedException e) {
            EMFWorkbenchEditPlugin.logError(e);
        }
        try {
            final IResourceDelta delta = event.getDelta();
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                this.primAcceptDelta(delta, event);
            } else {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ResourceSetWorkbenchEditSynchronizer.this.primAcceptDelta(delta, event);
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.project, 1, null);
                }
                catch (CoreException e) {
                    EMFWorkbenchEditPlugin.logError(e);
                }
            }
        }
        finally {
            if (hasLocked) {
                this.releaseLock();
            }
        }
    }

    private void primAcceptDelta(IResourceDelta delta, IResourceChangeEvent event) {
        if (delta != null) {
            try {
                this.currentProjectDelta = null;
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                EMFWorkbenchEditPlugin.logError(e);
            }
        }
    }

    protected void release() {
        if (JEMUtilPlugin.isActivated()) {
            try {
                if (this.resourceSet instanceof ProjectResourceSet) {
                    ((ProjectResourceSet)this.resourceSet).release();
                }
            }
            finally {
                EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
                this.dispose();
            }
        }
    }

    private void processDeferredResources() {
        this.processDeferredRemovedResources();
        this.processDeferredUnloadedResources();
        this.processDeferredLoadResources();
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                IProject p = (IProject)resource;
                if (this.isInterrestedInProject(p)) {
                    this.currentProjectDelta = delta;
                    return true;
                }
                return false;
            }
            if (resource.getType() == 1 && this.isInterrestedInFile((IFile)resource)) {
                switch (delta.getKind()) {
                    case 2: {
                        this.removedResource((IFile)resource);
                        break;
                    }
                    case 1: {
                        this.addedResource((IFile)resource);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x100) == 0) break;
                        this.changedResource((IFile)resource);
                        break;
                    }
                    default: {
                        if ((delta.getFlags() & 0x1000) == 0 && (delta.getFlags() & 0x2000) == 0) break;
                        this.movedResource((IFile)resource);
                    }
                }
                return false;
            }
        }
        return true;
    }

    protected boolean removedResource(IFile aFile) {
        return this.processResource(aFile, true);
    }

    protected boolean addedResource(IFile aFile) {
        boolean didProcess = false;
        List resources = this.getResources(aFile);
        for (Resource resource : resources) {
            if (resource == null) continue;
            if (this.recentlySavedFilesContains(resource)) {
                ReferencedResource refRes;
                if (!resource.isModified() || !WorkbenchResourceHelper.isReferencedResource(resource) || !(refRes = (ReferencedResource)resource).shouldForceRefresh()) continue;
                this.deferredUnloadResources.add(resource);
                didProcess = true;
                continue;
            }
            if (resource.isLoaded()) {
                if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                    if (WorkbenchResourceHelper.isConsistent((ReferencedResource)resource)) continue;
                    this.deferredUnloadResources.add(resource);
                    didProcess = true;
                    continue;
                }
                this.deferredUnloadResources.add(resource);
                didProcess = true;
                continue;
            }
            URI uri = URI.createPlatformResourceURI((String)aFile.getFullPath().toString());
            if (!this.autoloadResourcesURIs.contains(uri) && !this.autoloadResourcesExts.contains(aFile.getFileExtension())) continue;
            this.deferredLoadResources.add(uri);
            didProcess = true;
        }
        return didProcess;
    }

    private synchronized boolean recentlySavedFilesContains(Resource resource) {
        for (SavedFileKey key : this.recentlySavedFiles) {
            if (key.getRes() == null || !key.getRes().getURI().equals((Object)resource.getURI()) || !key.getRes().getClass().equals(resource.getClass())) continue;
            return true;
        }
        return false;
    }

    protected boolean processResource(IFile aFile, boolean isRemove) {
        List resources = this.getResources(aFile);
        for (Resource resource : resources) {
            ReferencedResource refRes;
            if (resource == null || this.recentlySavedFilesContains(resource) && resource.isModified() && (!WorkbenchResourceHelper.isReferencedResource(resource) || !(refRes = (ReferencedResource)resource).shouldForceRefresh())) continue;
            if (isRemove) {
                this.deferredRemoveResources.add(resource);
                continue;
            }
            if (!resource.isLoaded()) continue;
            if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                if (WorkbenchResourceHelper.isConsistent((ReferencedResource)resource)) continue;
                this.deferredUnloadResources.add(resource);
                continue;
            }
            this.deferredUnloadResources.add(resource);
        }
        return false;
    }

    protected boolean movedResource(IFile aFile) {
        return this.removedResource(aFile);
    }

    protected boolean changedResource(IFile aFile) {
        return this.processResource(aFile, false);
    }

    protected Resource getResource(IFile aFile) {
        return this.resourceSet.getResource(URI.createPlatformResourceURI((String)aFile.getFullPath().toString()), false);
    }

    protected List getResources(IFile aFile) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        EList allResources = this.resourceSet.getResources();
        for (Resource res : allResources) {
            URI resURI = res.getURI();
            String resURIString = "";
            if (resURI.path() != null) {
                IPath resURIPath = WorkbenchResourceHelper.isPlatformResourceURI((URI)resURI) ? new Path(URI.decode((String)resURI.path())).removeFirstSegments(2) : new Path(URI.decode((String)resURI.path())).removeFirstSegments(1);
                resURIString = resURIPath.toString();
            }
            if (resURIString.equals("") || aFile.getFullPath().toString().indexOf(resURIString) == -1) continue;
            resources.add(res);
        }
        return resources;
    }

    public void preSave(IFile aFile) {
        if (aFile != null) {
            this.recentlySavedFilesAdd(aFile, null);
            this.ignoredFilesCache.remove(aFile);
        }
    }

    public void preSave(IFile aFile, Resource res) {
        if (aFile != null) {
            this.recentlySavedFilesAdd(aFile, res);
            this.ignoredFilesCache.remove(aFile);
        }
    }

    private synchronized boolean recentlySavedFilesAdd(IFile file, Resource res) {
        return this.recentlySavedFiles.add(new SavedFileKey(res, file));
    }

    public void removeFromRecentlySavedList(IFile aFile) {
        if (aFile != null) {
            this.recentlySavedFilesForceRemove(aFile);
            this.ignoredFilesCache.remove(aFile);
        }
    }

    private synchronized boolean recentlySavedFilesRemove(IFile file) {
        boolean removedFromList = false;
        Iterator iterator = this.recentlySavedFiles.iterator();
        while (iterator.hasNext()) {
            SavedFileKey key = (SavedFileKey)iterator.next();
            if (key.savedFile == null || !key.savedFile.equals((Object)file)) continue;
            List resources = this.getResources(file);
            if (key.getRes() != null && !resources.contains(key.getRes())) continue;
            iterator.remove();
            removedFromList = true;
        }
        return removedFromList;
    }

    private synchronized boolean recentlySavedFilesForceRemove(IFile file) {
        boolean removedFromList = false;
        Iterator iterator = this.recentlySavedFiles.iterator();
        while (iterator.hasNext()) {
            SavedFileKey key = (SavedFileKey)iterator.next();
            if (key.savedFile == null || !key.savedFile.equals((Object)file)) continue;
            iterator.remove();
            removedFromList = true;
        }
        return removedFromList;
    }

    public void postSave(IFile aFile) {
    }

    protected boolean isInterrestedInProject(IProject aProject) {
        return aProject.equals((Object)this.getProject());
    }

    protected boolean isInterrestedInFile(IFile aFile) {
        String extension = aFile.getFileExtension();
        if (CLASS_EXTENSION.equals(extension) || JAVA_EXTENSION.equals(extension) || JAVA_ARCHIVE.equals(extension)) {
            return false;
        }
        if (this.recentlySavedFilesRemove(aFile)) {
            this.cacheIgnored(aFile);
            return false;
        }
        return !this.hasIgnored(aFile);
    }

    private boolean hasIgnored(IFile file) {
        Long cachedStamp = (Long)this.ignoredFilesCache.get(file);
        if (cachedStamp == null) {
            return false;
        }
        long stamp = WorkbenchResourceHelper.computeModificationStamp(file);
        return cachedStamp == stamp;
    }

    private void cacheIgnored(IFile file) {
        long stamp = WorkbenchResourceHelper.computeModificationStamp(file);
        this.ignoredFilesCache.put(file, new Long(stamp));
    }

    public void enableAutoload(URI uri) {
        URI normalized = this.resourceSet.getURIConverter().normalize(uri);
        this.autoloadResourcesURIs.add(normalized);
    }

    public void disableAutoload(URI uri) {
        URI normalized = this.resourceSet.getURIConverter().normalize(uri);
        this.autoloadResourcesURIs.remove(normalized);
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    public void enableAutoload(String extension) {
        this.autoloadResourcesExts.add(extension);
    }

    public void disableAutoload(String extension) {
        this.autoloadResourcesExts.remove(extension);
    }

    public void dispose() {
        super.dispose();
        this.currentProjectDelta = null;
        this.extenders = null;
    }

    private class SavedFileKey {
        private WeakReference res;
        private IFile savedFile;

        public SavedFileKey(Resource res, IFile savedFile) {
            this.res = new WeakReference<Resource>(res);
            this.savedFile = savedFile;
        }

        public Resource getRes() {
            return this.res == null ? null : (Resource)this.res.get();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.getRes() == null ? 0 : this.getRes().hashCode());
            result = 31 * result + (this.savedFile == null ? 0 : this.savedFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SavedFileKey other = (SavedFileKey)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.getRes() == null ? other.getRes() != null : !this.getRes().equals(other.getRes())) {
                return false;
            }
            return !(this.savedFile == null ? other.savedFile != null : !this.savedFile.equals((Object)other.savedFile));
        }

        private ResourceSetWorkbenchEditSynchronizer getOuterType() {
            return ResourceSetWorkbenchEditSynchronizer.this;
        }
    }
}

