/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;

public abstract class Packet {
    private static int currentSequence = 0;
    private final int sequence;
    private final String type;

    protected Packet(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type for a packet cannot be null");
        }
        this.sequence = Packet.nextSequence();
        this.type = type.intern();
    }

    protected Packet(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("The JSON map for a packet cannot be null");
        }
        Number packetSeq = (Number)json.get("seq");
        this.sequence = packetSeq.intValue();
        String packetType = (String)json.get("type");
        this.type = packetType.intern();
    }

    private static synchronized int nextSequence() {
        return ++currentSequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getType() {
        return this.type;
    }

    public Map toJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("seq", new Integer(this.sequence));
        json.put("type", this.type);
        return json;
    }

    public static String getType(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("A null JSON map is not allowed when trying to get the packet type");
        }
        return (String)json.get("type");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Packet: ").append(JSONUtil.write(this.toJSON()));
        return buffer.toString();
    }
}

