/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XPathDecimalFormat;

public class XPathDecimalFormatTest
extends TestCase {
    private static final String DOUBLE_FORMAT = "0.################E0";
    private static final String FLOAT_FORMAT = "0.#######E0";

    public void testDoublePositiveInfinity() {
        XPathDecimalFormat format = new XPathDecimalFormat(DOUBLE_FORMAT);
        Double value = Double.POSITIVE_INFINITY;
        String result = format.xpathFormat((Object)value);
        XPathDecimalFormatTest.assertEquals((String)"Unexpected XPath format String:", (String)"INF", (String)result);
    }

    public void testDoubleNegativeInfinity() {
        XPathDecimalFormat format = new XPathDecimalFormat(DOUBLE_FORMAT);
        Double value = Double.NEGATIVE_INFINITY;
        String result = format.xpathFormat((Object)value);
        XPathDecimalFormatTest.assertEquals((String)"Unexpected XPath format string:", (String)"-INF", (String)result);
    }

    public void testFloatPositiveInfinity() {
        XPathDecimalFormat format = new XPathDecimalFormat(FLOAT_FORMAT);
        Float value = Float.valueOf(Float.POSITIVE_INFINITY);
        String result = format.xpathFormat((Object)value);
        XPathDecimalFormatTest.assertEquals((String)"Unexpected XPath format string:", (String)"INF", (String)result);
    }

    public void testFloatNegativeInfinity() {
        XPathDecimalFormat format = new XPathDecimalFormat(FLOAT_FORMAT);
        Float value = Float.valueOf(Float.NEGATIVE_INFINITY);
        String result = format.xpathFormat((Object)value);
        XPathDecimalFormatTest.assertEquals((String)"Unexpected XPath format string:", (String)"-INF", (String)result);
    }

    public void testLocaleInsensitivity() {
        Locale.setDefault(Locale.GERMAN);
        XPathDecimalFormat format = new XPathDecimalFormat(FLOAT_FORMAT);
        Float value = Float.valueOf(1.2f);
        String result = format.xpathFormat((Object)value);
        XPathDecimalFormatTest.assertEquals((String)"Unexpected XPath format string:", (String)"1.2", (String)result);
    }
}

