/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editpolicies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;

public class GraphNodeDragTracker
extends DragEditPartsTracker {
    protected EditPart editPart;

    public GraphNodeDragTracker(EditPart editPart) {
        super(editPart);
        this.editPart = editPart;
    }

    protected Command getCommand() {
        Request request = this.getTargetRequest();
        return this.editPart.getCommand(request);
    }

    protected void performSelection() {
        this.performAdditionalSelection();
        super.performSelection();
    }

    protected void performAdditionalSelection() {
        EditPartViewer viewer = this.getCurrentViewer();
        if (this.getCurrentInput().isShiftKeyDown()) {
            Object lastSelected;
            List list = this.editPart.getParent().getChildren();
            int currentIndex = list.indexOf(this.editPart);
            List currentSelected = viewer.getSelectedEditParts();
            int size = currentSelected.size();
            if (size > 0 && (lastSelected = currentSelected.get(size - 1)) instanceof BaseEditPart) {
                int lowerIndex = -1;
                int upperIndex = -1;
                int lastSelectedIndex = list.indexOf(lastSelected);
                if (lastSelectedIndex >= 0 && lastSelectedIndex < currentIndex) {
                    lowerIndex = lastSelectedIndex;
                    upperIndex = currentIndex;
                } else if (lastSelectedIndex >= 0 && lastSelectedIndex > currentIndex) {
                    lowerIndex = currentIndex;
                    upperIndex = lastSelectedIndex;
                }
                if (lowerIndex >= 0 && upperIndex >= 0) {
                    int i = lowerIndex;
                    while (i < upperIndex) {
                        viewer.appendSelection((EditPart)list.get(i));
                        ++i;
                    }
                }
            }
        }
    }
}

