/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;

public class XSDPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    Text indentTextField;
    String indentString;
    Text schemaNsPrefixField;
    Text defaultTargetNamespaceText;
    Button qualifyXSDLanguage;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.wst.xsd.ui.internal.xsdp0010");
        Group group = this.createGroup(parent, 2);
        group.setText(Messages._UI_TEXT_XSD_NAMESPACE_PREFIX);
        this.qualifyXSDLanguage = ViewUtility.createCheckBox((Composite)group, Messages._UI_QUALIFY_XSD);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.qualifyXSDLanguage, "org.eclipse.wst.xsd.ui.xsduf0010");
        ViewUtility.createLabel((Composite)group, " ");
        this.createLabel((Composite)group, Messages._UI_TEXT_XSD_DEFAULT_PREFIX);
        this.schemaNsPrefixField = this.createTextField((Composite)group);
        this.schemaNsPrefixField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                XSDPreferencePage.this.setValid(true);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaNsPrefixField, "org.eclipse.wst.xsd.ui.xsduf0020");
        this.createLabel((Composite)group, Messages._UI_TEXT_XSD_DEFAULT_TARGET_NAMESPACE);
        this.defaultTargetNamespaceText = this.createTextField((Composite)group);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.defaultTargetNamespaceText, "org.eclipse.wst.xsd.ui.xsduf0030");
        this.initializeValues();
        this.applyDialogFont(parent);
        return new Composite(parent, 0);
    }

    private Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    private Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
        this.checkValues();
    }

    public boolean performOk() {
        if (this.checkValues()) {
            this.storeValues();
            return true;
        }
        return false;
    }

    protected void performApply() {
        if (this.checkValues()) {
            this.storeValues();
        }
    }

    public void handleEvent(Event e) {
    }

    public void init(IWorkbench workbench) {
    }

    public IPreferenceStore getPreferenceStore() {
        return XSDEditorPlugin.getPlugin().getPreferenceStore();
    }

    private void initializeDefaults() {
        this.schemaNsPrefixField.setText(this.getPreferenceStore().getDefaultString("org.eclipse.wst.xmlschema.xsdDefaultPrefixText"));
        this.qualifyXSDLanguage.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.wst.xmlschema.xsdQualify"));
        this.defaultTargetNamespaceText.setText(this.getPreferenceStore().getString("org.eclipse.wst.xmlschema.defaultTargetnamespaceText"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.schemaNsPrefixField.setText(store.getString("org.eclipse.wst.xmlschema.xsdDefaultPrefixText"));
        this.qualifyXSDLanguage.setSelection(store.getBoolean("org.eclipse.wst.xmlschema.xsdQualify"));
        this.defaultTargetNamespaceText.setText(store.getString("org.eclipse.wst.xmlschema.defaultTargetnamespaceText"));
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.wst.xmlschema.xsdDefaultPrefixText", this.getXMLSchemaPrefix());
        store.setValue("org.eclipse.wst.xmlschema.xsdQualify", this.getQualify());
        store.setValue("org.eclipse.wst.xmlschema.defaultTargetnamespaceText", this.getXMLSchemaTargetNamespace());
        XSDEditorPlugin.getPlugin().savePluginPreferences();
    }

    public String getXMLSchemaPrefix() {
        String prefix = this.schemaNsPrefixField.getText();
        if (prefix == null || prefix.equals("")) {
            return "xsd";
        }
        return prefix;
    }

    public boolean getQualify() {
        return this.qualifyXSDLanguage.getSelection();
    }

    public String getXMLSchemaTargetNamespace() {
        String targetNamespace = this.defaultTargetNamespaceText.getText();
        if (targetNamespace == null || targetNamespace.equals("")) {
            return "http://www.example.org";
        }
        return targetNamespace;
    }

    public boolean checkValues() {
        String errorMessage = null;
        if (errorMessage != null) {
            errorMessage.length();
        }
        this.setErrorMessage(null);
        this.setValid(true);
        return true;
    }
}

