/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.caching;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.eclipselink.core.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.ui.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.persistence.caching.EntityCachingPropertyComposite;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite<T extends Caching>
extends Pane<T> {
    WritablePropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> entityHolder;

    public EntityListComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.entityHolder = this.buildEntityHolder();
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, EclipseLinkUiMessages.CachingEntityListComposite_groupTitle);
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.entityHolder, this.buildEntityLabelProvider(), "org.eclipse.jpt.ui.persistence_caching");
        EntityCachingPropertyComposite pane = new EntityCachingPropertyComposite(this, (PropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity>)this.entityHolder, container);
        this.installPaneEnabler(this.entityHolder, pane);
    }

    private AddRemovePane.Adapter buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityListComposite.this.addEntities(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Caching caching = (Caching)EntityListComposite.this.getSubject();
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity entityCaching = (org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity)item;
                    caching.removeEntity(entityCaching.getName());
                    ++n2;
                }
            }
        };
    }

    private void addEntities(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Caching)this.getSubject()).entityExists(entityName)) {
                ((Caching)this.getSubject()).addEntity(entityName);
                int index = CollectionTools.indexOf((Iterator)((Caching)this.getSubject()).entityNames(), (Object)entityName);
                org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity entity = (org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity)listSelectionModel.getListModel().getElementAt(index);
                listSelectionModel.setSelectedValue((Object)entity);
                this.entityHolder.setValue((Object)entity);
            }
        }
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((Caching)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CachingEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CachingEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return ((Caching)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity entityCaching = (org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity)element;
                return entityCaching.getName();
            }
        };
    }

    private WritablePropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> buildEntitiesListHolder() {
        return new ListAspectAdapter<Caching, org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterator<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> listIterator_() {
                return ((Caching)this.subject).entities();
            }

            protected int size_() {
                return ((Caching)this.subject).entitiesSize();
            }
        };
    }

    private void installPaneEnabler(WritablePropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> entityHolder, EntityCachingPropertyComposite pane) {
        new PaneEnabler(this.buildPaneEnablerHolder(entityHolder), (Pane)pane);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(WritablePropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity> entityHolder) {
        return new TransformationPropertyValueModel<org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity, Boolean>(entityHolder){

            protected Boolean transform_(org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Entity value) {
                return value.entityNameIsValid();
            }
        };
    }
}

