/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.IntReference;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class IntReferenceTests
extends TestCase {
    public IntReferenceTests(String name) {
        super(name);
    }

    public void testCtors() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        ir = new IntReference(7);
        IntReferenceTests.assertEquals((int)7, (int)ir.getValue());
        ir = new IntReference(-7);
        IntReferenceTests.assertEquals((int)-7, (int)ir.getValue());
    }

    public void testEqualsInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.equals(0));
        IntReferenceTests.assertFalse((boolean)ir.equals(7));
        ir = new IntReference(7);
        IntReferenceTests.assertTrue((boolean)ir.equals(7));
        IntReferenceTests.assertFalse((boolean)ir.equals(0));
    }

    public void testNotEqualsInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.notEquals(0));
        IntReferenceTests.assertTrue((boolean)ir.notEquals(7));
        ir = new IntReference(7);
        IntReferenceTests.assertFalse((boolean)ir.notEquals(7));
        IntReferenceTests.assertTrue((boolean)ir.notEquals(0));
    }

    public void testIsZero() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.isZero());
        ir = new IntReference(7);
        IntReferenceTests.assertFalse((boolean)ir.isZero());
    }

    public void testIsNotZero() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.isNotZero());
        ir = new IntReference(7);
        IntReferenceTests.assertTrue((boolean)ir.isNotZero());
    }

    public void testIsGreaterThanInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.isGreaterThan(-1));
        IntReferenceTests.assertFalse((boolean)ir.isGreaterThan(0));
        IntReferenceTests.assertFalse((boolean)ir.isGreaterThan(7));
    }

    public void testIsGreaterThanOrEqualInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.isGreaterThanOrEqual(-1));
        IntReferenceTests.assertTrue((boolean)ir.isGreaterThanOrEqual(0));
        IntReferenceTests.assertFalse((boolean)ir.isGreaterThanOrEqual(7));
    }

    public void testIsLessThanInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.isLessThan(-1));
        IntReferenceTests.assertFalse((boolean)ir.isLessThan(0));
        IntReferenceTests.assertTrue((boolean)ir.isLessThan(7));
    }

    public void testIsLessThanOrEqualInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.isLessThanOrEqual(-1));
        IntReferenceTests.assertTrue((boolean)ir.isLessThanOrEqual(0));
        IntReferenceTests.assertTrue((boolean)ir.isLessThanOrEqual(7));
    }

    public void testIsPositive() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertFalse((boolean)ir.isPositive());
        ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.isPositive());
        ir = new IntReference(7);
        IntReferenceTests.assertTrue((boolean)ir.isPositive());
    }

    public void testIsNotPositive() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertTrue((boolean)ir.isNotPositive());
        ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.isNotPositive());
        ir = new IntReference(7);
        IntReferenceTests.assertFalse((boolean)ir.isNotPositive());
    }

    public void testIsNegative() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertTrue((boolean)ir.isNegative());
        ir = new IntReference();
        IntReferenceTests.assertFalse((boolean)ir.isNegative());
        ir = new IntReference(7);
        IntReferenceTests.assertFalse((boolean)ir.isNegative());
    }

    public void testIsNotNegative() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertFalse((boolean)ir.isNotNegative());
        ir = new IntReference();
        IntReferenceTests.assertTrue((boolean)ir.isNotNegative());
        ir = new IntReference(7);
        IntReferenceTests.assertTrue((boolean)ir.isNotNegative());
    }

    public void testSetValueInt() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)-3, (int)ir.setValue(4));
        IntReferenceTests.assertEquals((int)4, (int)ir.getValue());
    }

    public void testAbs() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)3, (int)ir.abs());
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        ir.setValue(3);
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)3, (int)ir.abs());
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
    }

    public void testNeg() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)3, (int)ir.neg());
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        ir.setValue(3);
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)-3, (int)ir.neg());
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
    }

    public void testSetZero() {
        IntReference ir = new IntReference(-3);
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)-3, (int)ir.setZero());
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
    }

    public void testAddInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int value = ir.add(3);
        IntReferenceTests.assertEquals((int)3, (int)value);
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        value = ir.add(-7);
        IntReferenceTests.assertEquals((int)-4, (int)value);
        IntReferenceTests.assertEquals((int)-4, (int)ir.getValue());
    }

    public void testIncrement() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int value = ir.increment();
        IntReferenceTests.assertEquals((int)1, (int)value);
        IntReferenceTests.assertEquals((int)1, (int)ir.getValue());
    }

    public void testSubtractInt() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int count = ir.subtract(3);
        IntReferenceTests.assertEquals((int)-3, (int)count);
        IntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        count = ir.subtract(-7);
        IntReferenceTests.assertEquals((int)4, (int)count);
        IntReferenceTests.assertEquals((int)4, (int)ir.getValue());
    }

    public void testDecrement() {
        IntReference ir = new IntReference();
        IntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int count = ir.decrement();
        IntReferenceTests.assertEquals((int)-1, (int)count);
        IntReferenceTests.assertEquals((int)-1, (int)ir.getValue());
    }

    public void testMultiplyInt() {
        IntReference ir = new IntReference(3);
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)9, (int)ir.multiply(3));
        IntReferenceTests.assertEquals((int)9, (int)ir.getValue());
    }

    public void testDivideInt() {
        IntReference ir = new IntReference(24);
        IntReferenceTests.assertEquals((int)24, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)8, (int)ir.divide(3));
        IntReferenceTests.assertEquals((int)8, (int)ir.getValue());
    }

    public void testRemainderInt() {
        IntReference ir = new IntReference(25);
        IntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)1, (int)ir.remainder(3));
        IntReferenceTests.assertEquals((int)1, (int)ir.getValue());
    }

    public void testMinInt() {
        IntReference ir = new IntReference(25);
        IntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)3, (int)ir.min(3));
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)3, (int)ir.min(25));
        IntReferenceTests.assertEquals((int)3, (int)ir.getValue());
    }

    public void testMaxInt() {
        IntReference ir = new IntReference(25);
        IntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)25, (int)ir.max(3));
        IntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)30, (int)ir.max(30));
        IntReferenceTests.assertEquals((int)30, (int)ir.getValue());
    }

    public void testPowInt() {
        IntReference ir = new IntReference(5);
        IntReferenceTests.assertEquals((int)5, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)25, (int)ir.pow(2));
        IntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        IntReferenceTests.assertEquals((int)625, (int)ir.pow(2));
        IntReferenceTests.assertEquals((int)625, (int)ir.getValue());
    }

    public void testCompareToIntReference() {
        IntReference ir1 = new IntReference(44);
        IntReference ir2 = new IntReference(44);
        IntReferenceTests.assertTrue((ir1.compareTo(ir2) == 0 ? 1 : 0) != 0);
        ir2 = new IntReference(55);
        IntReferenceTests.assertTrue((ir1.compareTo(ir2) < 0 ? 1 : 0) != 0);
        ir2 = new IntReference(33);
        IntReferenceTests.assertTrue((ir1.compareTo(ir2) > 0 ? 1 : 0) != 0);
    }

    public void testClone() {
        IntReference ir1 = new IntReference(44);
        IntReference ir2 = (IntReference)ir1.clone();
        IntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        IntReferenceTests.assertEquals((Object)ir1, (Object)ir2);
        IntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }

    public void testEquals() {
        IntReference ir1 = new IntReference(44);
        IntReference ir2 = new IntReference(44);
        IntReferenceTests.assertEquals((Object)ir1, (Object)ir2);
        IntReferenceTests.assertEquals((int)ir1.hashCode(), (int)ir2.hashCode());
        IntReferenceTests.assertFalse((boolean)ir1.equals(null));
    }

    public void testSerialization() throws Exception {
        IntReference ir1 = new IntReference(44);
        IntReference ir2 = TestTools.serialize(ir1);
        IntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        IntReferenceTests.assertEquals((Object)ir1, (Object)ir2);
        IntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }

    public void testToString() {
        IntReference ir = new IntReference(5);
        IntReferenceTests.assertEquals((String)"[5]", (String)ir.toString());
    }
}

