/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model;

import java.util.EventListener;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ChangeEvent;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class NewEventTests
extends TestCase {
    private Foo foo;

    public NewEventTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Foo();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNoFooChangeListeners() {
        NewEventTests.assertTrue((boolean)this.foo.hasNoFooChangeListeners());
        LocalListener listener = new LocalListener();
        this.foo.addFooChangeListener(listener);
        NewEventTests.assertFalse((boolean)this.foo.hasNoFooChangeListeners());
        this.foo.removeFooChangeListener(listener);
        NewEventTests.assertTrue((boolean)this.foo.hasNoFooChangeListeners());
    }

    public void testHasAnyFooChangeListeners() {
        NewEventTests.assertFalse((boolean)this.foo.hasAnyFooChangeListeners());
        LocalListener listener = new LocalListener();
        this.foo.addFooChangeListener(listener);
        NewEventTests.assertTrue((boolean)this.foo.hasAnyFooChangeListeners());
        this.foo.removeFooChangeListener(listener);
        NewEventTests.assertFalse((boolean)this.foo.hasAnyFooChangeListeners());
    }

    public void testFireFooChangeEvent() {
        LocalListener listener = new LocalListener();
        NewEventTests.assertFalse((boolean)listener.receivedFooEvent);
        this.foo.addFooChangeListener(listener);
        this.foo.foo();
        NewEventTests.assertTrue((boolean)listener.receivedFooEvent);
    }

    static class AbstractFooModel
    extends AbstractModel
    implements FooModel {
        AbstractFooModel() {
        }

        protected synchronized FooChangeSupport getChangeSupport() {
            return (FooChangeSupport)super.getChangeSupport();
        }

        protected ChangeSupport buildChangeSupport() {
            return new FooChangeSupport(this);
        }

        public void addFooChangeListener(FooChangeListener listener) {
            this.getChangeSupport().addFooChangeListener(listener);
        }

        public void removeFooChangeListener(FooChangeListener listener) {
            this.getChangeSupport().removeFooChangeListener(listener);
        }

        protected void fireFooChangeEvent() {
            this.getChangeSupport().fireFooChanged();
        }

        public boolean hasAnyFooChangeListeners() {
            return this.getChangeSupport().hasAnyFooChangeListeners();
        }

        public boolean hasNoFooChangeListeners() {
            return !this.hasAnyFooChangeListeners();
        }
    }

    class Foo
    extends AbstractFooModel {
        Foo() {
        }

        void foo() {
            this.fireFooChangeEvent();
        }
    }

    static class FooChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1L;

        public FooChangeEvent(FooModel source) {
            super((Model)source);
        }

        public FooChangeEvent clone(Model newSource) {
            return new FooChangeEvent((FooModel)newSource);
        }
    }

    static interface FooChangeListener
    extends EventListener {
        public void fooChanged(FooChangeEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FooChangeSupport
    extends ChangeSupport {
        protected static final Class<FooChangeListener> FOO_CHANGE_LISTENER_CLASS = FooChangeListener.class;

        FooChangeSupport(FooModel source) {
            super((Model)source);
        }

        void addFooChangeListener(FooChangeListener listener) {
            this.addListener(FOO_CHANGE_LISTENER_CLASS, listener);
        }

        void removeFooChangeListener(FooChangeListener listener) {
            this.removeListener(FOO_CHANGE_LISTENER_CLASS, listener);
        }

        public boolean hasAnyFooChangeListeners() {
            return this.hasAnyListeners(FOO_CHANGE_LISTENER_CLASS);
        }

        private ListenerList<FooChangeListener> getFooChangeListenerList() {
            return this.getListenerList(FOO_CHANGE_LISTENER_CLASS);
        }

        private Iterable<FooChangeListener> getFooChangeListeners() {
            ListenerList<FooChangeListener> listenerList = this.getFooChangeListenerList();
            return listenerList == null ? null : listenerList.getListeners();
        }

        private boolean hasFooChangeListener(FooChangeListener listener) {
            return CollectionTools.contains(this.getFooChangeListeners(), (Object)listener);
        }

        public void fireFooChanged() {
            Iterable<FooChangeListener> listeners = this.getFooChangeListeners();
            if (listeners != null) {
                FooChangeEvent event = null;
                for (FooChangeListener listener : listeners) {
                    if (!this.hasFooChangeListener(listener)) continue;
                    if (event == null) {
                        event = new FooChangeEvent((FooModel)this.source);
                    }
                    listener.fooChanged(event);
                }
            }
        }
    }

    static interface FooModel
    extends Model {
        public void addFooChangeListener(FooChangeListener var1);

        public void removeFooChangeListener(FooChangeListener var1);
    }

    class LocalListener
    implements FooChangeListener {
        boolean receivedFooEvent = false;

        LocalListener() {
        }

        public void fooChanged(FooChangeEvent event) {
            this.receivedFooEvent = true;
        }
    }
}

