/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddRegistryToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.OpenRegistryAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindBusinessUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceInterfaceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDINodeAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.BusinessNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.PublishedItemsNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryParentNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceInterfaceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public class RefreshUDDINodeAction
extends UDDINodeAction {
    private Vector staleNodes_;

    public RefreshUDDINodeAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("nodeId", String.valueOf(controller.getUDDIPerspective().getNavigatorManager().getSelectedNodeId()));
        this.staleNodes_ = new Vector();
    }

    public static String getActionLink(int nodeId) {
        StringBuffer actionLink = new StringBuffer("uddi/actions/RefreshUDDINodeActionJSP.jsp?");
        actionLink.append("nodeId").append('=').append(nodeId);
        return actionLink.toString();
    }

    public final boolean verifyNodeData() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node node = this.nodeManager_.getNode(nodeId);
        if (node instanceof BusinessNode) {
            return this.refreshBusinessElement((BusinessNode)node);
        }
        if (node instanceof ServiceNode) {
            return this.refreshServiceElement((ServiceNode)node);
        }
        if (node instanceof ServiceInterfaceNode) {
            return this.refreshServiceInterfaceElement((ServiceInterfaceNode)node);
        }
        if (node instanceof QueryNode) {
            return true;
        }
        if (node != null) {
            if (node instanceof RegistryNode) {
                this.refreshRegistryElement((RegistryNode)node);
            }
            Vector childNodes = node.getChildNodes();
            Vector<RefreshUDDINodeAction> refreshActions = new Vector<RefreshUDDINodeAction>();
            int i = 0;
            while (i < childNodes.size()) {
                Node childNode = (Node)childNodes.elementAt(i);
                RefreshUDDINodeAction action = new RefreshUDDINodeAction(this.controller_);
                action.setStaleNodes(this.staleNodes_);
                Hashtable propertyTable = action.getPropertyTable();
                String childNodeIdString = String.valueOf(childNode.getNodeId());
                propertyTable.put("nodeId", childNodeIdString);
                if (!action.verifyNodeData()) {
                    this.staleNodes_.addElement(childNode);
                } else {
                    refreshActions.addElement(action);
                }
                ++i;
            }
            this.propertyTable_.put("latestObject", refreshActions);
            return true;
        }
        return true;
    }

    private final void refreshRegistryElement(RegistryNode regNode) {
        RegistryElement regElement = (RegistryElement)regNode.getTreeElement();
        Hashtable userDefinedCategories = null;
        if (regElement.getCheckForUserDefinedCategories()) {
            userDefinedCategories = new Hashtable();
            OpenRegistryAction openRegAction = new OpenRegistryAction(this.controller_);
            openRegAction.gatherWSUserDefinedCategories(regElement.getProxy(), userDefinedCategories);
            if (!userDefinedCategories.keys().hasMoreElements()) {
                userDefinedCategories = null;
                regNode.setImagePath("uddi/images/registry.gif");
            } else {
                String categoriesDirectory = regElement.getCategoriesDirectory();
                AddRegistryToUDDIPerspectiveAction addAction = new AddRegistryToUDDIPerspectiveAction(this.controller_);
                if (categoriesDirectory != null) {
                    addAction.linkCategoryModelsWithSavedData(userDefinedCategories.elements(), categoriesDirectory);
                } else {
                    addAction.linkCategoryModelsWithSavedData(regElement.getName(), userDefinedCategories.elements());
                }
                regNode.setImagePath("uddi/images/regstrycat_obj.gif");
            }
        }
        regElement.setUserDefinedCategories(userDefinedCategories);
    }

    private final boolean refreshBusinessElement(BusinessNode busNode) {
        BusinessElement busElement = (BusinessElement)busNode.getTreeElement();
        String uuidKey = busElement.getBusinessEntity().getBusinessKey();
        RegFindBusinessUUIDAction verifyAction = new RegFindBusinessUUIDAction(this.controller_);
        Hashtable propertyTable = verifyAction.getPropertyTable();
        propertyTable.put("uuidBusinessKey", uuidKey);
        propertyTable.put("refreshNode", busNode);
        propertyTable.put("overrideAddQueryNode", Boolean.TRUE);
        boolean verifyResult = verifyAction.run();
        if (verifyResult) {
            this.propertyTable_.put("latestObject", new BusinessElement((BusinessEntity)propertyTable.get("latestObject"), busElement.getModel()));
        }
        return verifyResult;
    }

    private final boolean refreshServiceElement(ServiceNode serviceNode) {
        ServiceElement serviceElement = (ServiceElement)serviceNode.getTreeElement();
        String uuidKey = serviceElement.getBusinessService().getServiceKey();
        RegFindServiceUUIDAction verifyAction = new RegFindServiceUUIDAction(this.controller_);
        Hashtable propertyTable = verifyAction.getPropertyTable();
        propertyTable.put("uuidServiceKey", uuidKey);
        propertyTable.put("refreshNode", serviceNode);
        propertyTable.put("overrideAddQueryNode", Boolean.TRUE);
        boolean verifyResult = verifyAction.run();
        if (verifyResult) {
            this.propertyTable_.put("latestObject", new ServiceElement((BusinessService)propertyTable.get("latestObject"), serviceElement.getModel()));
        }
        return verifyResult;
    }

    private final boolean refreshServiceInterfaceElement(ServiceInterfaceNode siNode) {
        ServiceInterfaceElement siElement = (ServiceInterfaceElement)siNode.getTreeElement();
        String uuidKey = siElement.getTModel().getTModelKey();
        RegFindServiceInterfaceUUIDAction verifyAction = new RegFindServiceInterfaceUUIDAction(this.controller_);
        Hashtable propertyTable = verifyAction.getPropertyTable();
        propertyTable.put("uuidServiceInterfaceKey", uuidKey);
        propertyTable.put("refreshNode", siNode);
        propertyTable.put("overrideAddQueryNode", Boolean.TRUE);
        boolean verifyResult = verifyAction.run();
        if (verifyResult) {
            this.propertyTable_.put("latestObject", new ServiceInterfaceElement((TModel)propertyTable.get("latestObject"), siElement.getModel()));
        }
        return verifyResult;
    }

    public final void connectElements(Node parentNode, TreeElement newElement) {
        TreeElement parentElement = parentNode.getTreeElement();
        String rel = null;
        if (parentNode instanceof PublishedItemsNode) {
            rel = "publishedItems";
        } else if (parentNode instanceof QueryNode) {
            rel = "queryResults";
        } else if (parentNode instanceof QueryParentNode) {
            rel = "queries";
        }
        parentElement.connect((Element)newElement, rel, "owner");
        Node newNode = parentNode.getChildNode(newElement);
        int newNodeId = newNode.getNodeId();
        this.nodeManager_.setSelectedNodeId(newNodeId);
        ToolManager toolManager = newNode.getToolManager();
        Tool selectedTool = toolManager.getSelectedTool();
        this.addToHistory(0, selectedTool.getSelectToolActionHref(true));
    }

    public final String getActionLinkForHistory() {
        return null;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        if (!this.isStaleNode(nodeId)) {
            Node node = this.nodeManager_.getNode(nodeId);
            Object latestObject = this.propertyTable_.get("latestObject");
            if (latestObject != null) {
                if (latestObject instanceof Vector) {
                    Vector refreshActions = (Vector)this.propertyTable_.get("latestObject");
                    int i = 0;
                    while (i < refreshActions.size()) {
                        RefreshUDDINodeAction refreshAction = (RefreshUDDINodeAction)refreshActions.elementAt(i);
                        refreshAction.run();
                        ++i;
                    }
                    this.nodeManager_.setSelectedNodeId(nodeId);
                } else {
                    TreeElement oldElement = node.getTreeElement();
                    oldElement.disconnectAll();
                    this.connectElements(node.getParent(), (TreeElement)((Object)this.propertyTable_.get("latestObject")));
                }
            } else {
                QueryNode queryNode = (QueryNode)node;
                FindAction findAction = queryNode.getFindAction();
                findAction.setRefreshAction(true);
                if (!findAction.run()) {
                    queryNode.removeChildNodes(true);
                }
                findAction.setRefreshAction(false);
            }
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_NODE_REFRESHED", node.getNodeName()));
            return true;
        }
        return false;
    }

    public final Vector getStaleNodes() {
        return this.staleNodes_;
    }

    public final void setStaleNodes(Vector staleNodes) {
        this.staleNodes_ = staleNodes;
    }
}

