/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterators;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.iterators.SynchronizedListIterator;
import org.eclipse.jpt.utility.tests.internal.TestTools;
import org.eclipse.jpt.utility.tests.internal.iterators.SynchronizedIteratorTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedListIteratorTests
extends SynchronizedIteratorTests {
    public SynchronizedListIteratorTests(String name) {
        super(name);
    }

    public void testUnsynchronizedPrevious() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        PreviousTestRunnable runnable2 = new PreviousTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable2.previous));
    }

    public void testSynchronizedPrevious() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        iterator.next();
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        PreviousTestRunnable runnable2 = new PreviousTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable2.previous));
    }

    public void testUnsynchronizedHasPrevious() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        HasPreviousTestRunnable runnable2 = new HasPreviousTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((boolean)true, (boolean)runnable2.hasPrevious);
    }

    public void testSynchronizedHasPrevious() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        HasPreviousTestRunnable runnable2 = new HasPreviousTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((boolean)false, (boolean)runnable2.hasPrevious);
    }

    public void testUnsynchronizedNextIndex() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        NextIndexTestRunnable runnable2 = new NextIndexTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertEquals((int)0, (int)runnable2.nextIndex);
    }

    public void testSynchronizedNextIndex() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        NextIndexTestRunnable runnable2 = new NextIndexTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertEquals((int)1, (int)runnable2.nextIndex);
    }

    public void testUnsynchronizedPreviousIndex() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        PreviousIndexTestRunnable runnable2 = new PreviousIndexTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((int)0, (int)runnable2.previousIndex);
    }

    public void testSynchronizedPreviousIndex() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        iterator.next();
        PreviousTestRunnable runnable1 = new PreviousTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        PreviousIndexTestRunnable runnable2 = new PreviousIndexTestRunnable(iterator);
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"foo", (String)((String)runnable1.previous));
        SynchronizedListIteratorTests.assertEquals((int)-1, (int)runnable2.previousIndex);
    }

    public void testUnsynchronizedSet() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        SetTestRunnable<String> runnable2 = new SetTestRunnable<String>((ListIterator<String>)((Object)iterator), "xxx");
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertFalse((boolean)((TestListIterator)iterator).list.contains("foo"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("bar"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("baz"));
    }

    public void testSynchronizedSet() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        iterator.next();
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        SetTestRunnable<String> runnable2 = new SetTestRunnable<String>((ListIterator<String>)iterator, "xxx");
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("foo"));
        SynchronizedListIteratorTests.assertFalse((boolean)((TestListIterator)nestedIterator).list.contains("bar"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("baz"));
    }

    public void testUnsynchronizedAdd() throws Exception {
        SynchronizedIteratorTests.TestIterator iterator = this.buildTestIterator(TWO_TICKS);
        iterator.next();
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        AddTestRunnable<String> runnable2 = new AddTestRunnable<String>((ListIterator<String>)((Object)iterator), "xxx");
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)iterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("foo"));
        SynchronizedListIteratorTests.assertEquals((int)0, (int)((TestListIterator)iterator).list.indexOf("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("bar"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)iterator).list.contains("baz"));
    }

    public void testSynchronizedAdd() throws Exception {
        SynchronizedIteratorTests.TestIterator nestedIterator = this.buildTestIterator(TWO_TICKS);
        Iterator iterator = this.buildSynchronizedIterator((Iterator)nestedIterator);
        iterator.next();
        SynchronizedIteratorTests.NextTestRunnable runnable1 = new SynchronizedIteratorTests.NextTestRunnable(iterator);
        Thread thread1 = this.buildThread(runnable1);
        AddTestRunnable<String> runnable2 = new AddTestRunnable<String>((ListIterator<String>)iterator, "xxx");
        Thread thread2 = this.buildThread(runnable2);
        ((TestListIterator)nestedIterator).slowThread = thread1;
        thread1.start();
        this.sleep(TICK);
        thread2.start();
        thread1.join();
        thread2.join();
        SynchronizedListIteratorTests.assertEquals((String)"bar", (String)((String)runnable1.next));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("foo"));
        SynchronizedListIteratorTests.assertEquals((int)1, (int)((TestListIterator)nestedIterator).list.indexOf("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("xxx"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("bar"));
        SynchronizedListIteratorTests.assertTrue((boolean)((TestListIterator)nestedIterator).list.contains("baz"));
    }

    ListIterator<String> buildSynchronizedIterator(Iterator<String> nestedIterator) {
        return new SynchronizedListIterator((ListIterator)nestedIterator);
    }

    TestListIterator<String> buildTestIterator(long delay) {
        return new TestListIterator<String>(delay, this.buildArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        final E element;

        AddTestRunnable(ListIterator<E> iterator, E element) {
            this.iterator = iterator;
            this.element = element;
        }

        @Override
        public void run() {
            this.iterator.add(this.element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HasPreviousTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        boolean hasPrevious;

        HasPreviousTestRunnable(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.hasPrevious = this.iterator.hasPrevious();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NextIndexTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        int nextIndex;

        NextIndexTestRunnable(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.nextIndex = this.iterator.nextIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PreviousIndexTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        int previousIndex;

        PreviousIndexTestRunnable(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.previousIndex = this.iterator.previousIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PreviousTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        E previous;

        PreviousTestRunnable(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.previous = this.iterator.previous();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetTestRunnable<E>
    implements Runnable {
        final ListIterator<E> iterator;
        final E element;

        SetTestRunnable(ListIterator<E> iterator, E element) {
            this.iterator = iterator;
            this.element = element;
        }

        @Override
        public void run() {
            this.iterator.set(this.element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestListIterator<E>
    extends SynchronizedIteratorTests.TestIterator<E>
    implements ListIterator<E> {
        TestListIterator(long delay, E ... array) {
            super(delay, array);
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                Object previous = this.list.get(this.previousIndex());
                if (Thread.currentThread() == this.slowThread) {
                    TestTools.sleep(this.delay);
                }
                --this.nextIndex;
                this.lastIndex = this.nextIndex;
                return previous;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.lastIndex, e);
        }

        @Override
        public void add(E e) {
            this.list.add(this.lastIndex, e);
            ++this.lastIndex;
            this.lastIndex = -1;
        }
    }
}

