/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.BidiFilter;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.FilteringWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringPropertyValueModelTests
extends TestCase {
    private WritablePropertyValueModel<String> objectHolder;
    PropertyChangeEvent event;
    private WritablePropertyValueModel<String> filteredObjectHolder;
    PropertyChangeEvent filteredEvent;

    public FilteringPropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
        this.filteredObjectHolder = new FilteringWritablePropertyValueModel(this.objectHolder, this.buildFilter());
    }

    private BidiFilter<String> buildFilter() {
        return new BidiFilter<String>(){

            public boolean accept(String s) {
                return s != null && s.startsWith("b");
            }

            public boolean reverseAccept(String s) {
                return s != null && s.startsWith("b");
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        FilteringPropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertNull((Object)this.filteredObjectHolder.getValue());
        this.objectHolder.setValue((Object)"bar");
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertNotNull((Object)this.filteredObjectHolder.getValue());
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"baz");
        FilteringPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertNotNull((Object)this.filteredObjectHolder.getValue());
        FilteringPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.filteredObjectHolder.getValue()));
        this.objectHolder.setValue(null);
        FilteringPropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        FilteringPropertyValueModelTests.assertNull((Object)this.filteredObjectHolder.getValue());
        this.objectHolder.setValue((Object)"foo");
        FilteringPropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertNull((Object)this.filteredObjectHolder.getValue());
    }

    public void testSetValue() {
        this.filteredObjectHolder.setValue((Object)"bar");
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredObjectHolder.getValue()));
        this.filteredObjectHolder.setValue((Object)"foo");
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredObjectHolder.getValue()));
        this.filteredObjectHolder.setValue(null);
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredObjectHolder.getValue()));
        this.filteredObjectHolder.setValue((Object)"baz");
        FilteringPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.objectHolder.getValue()));
        FilteringPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.filteredObjectHolder.getValue()));
    }

    public void testLazyListening() {
        FilteringPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildFilteredListener();
        this.filteredObjectHolder.addChangeListener(listener);
        FilteringPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.filteredObjectHolder.removeChangeListener(listener);
        FilteringPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.filteredObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        FilteringPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.filteredObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        FilteringPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.filteredObjectHolder.addChangeListener(this.buildFilteredListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.filteredObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildFilteredListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, "foo", "bar");
        this.verifyEvent(this.filteredEvent, this.filteredObjectHolder, null, "bar");
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue((Object)"baz");
        this.verifyEvent(this.event, this.objectHolder, "bar", "baz");
        this.verifyEvent(this.filteredEvent, this.filteredObjectHolder, "bar", "baz");
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue((Object)"foo");
        this.verifyEvent(this.event, this.objectHolder, "baz", "foo");
        this.verifyEvent(this.filteredEvent, this.filteredObjectHolder, "baz", null);
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue((Object)"fop");
        this.verifyEvent(this.event, this.objectHolder, "foo", "fop");
        FilteringPropertyValueModelTests.assertNull((Object)this.filteredEvent);
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, "fop", null);
        FilteringPropertyValueModelTests.assertNull((Object)this.filteredEvent);
        this.event = null;
        this.filteredEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, null, "bar");
        this.verifyEvent(this.filteredEvent, this.filteredObjectHolder, null, "bar");
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                FilteringPropertyValueModelTests.this.event = e;
            }
        };
    }

    private ChangeListener buildFilteredListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                FilteringPropertyValueModelTests.this.filteredEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        FilteringPropertyValueModelTests.assertEquals((Object)source, (Object)e.getSource());
        FilteringPropertyValueModelTests.assertEquals((String)"value", (String)e.getPropertyName());
        FilteringPropertyValueModelTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        FilteringPropertyValueModelTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }
}

