/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.PrintStream;
import java.text.MessageFormat;

public class PerfTracker {
    private long _max = Long.MIN_VALUE;
    private long _maxIdx = 0L;
    private long _min = Long.MAX_VALUE;
    private long _minIdx = 0L;
    private long _runningTotal = 0L;
    private final long[] _times;
    private int _numTimesRecorded = 0;
    private final String _name;

    public PerfTracker(String name, int numOfRuns) {
        this._times = new long[numOfRuns];
        this._name = name;
    }

    public void recordTime(long time) {
        this._max = Math.max(this._max, time);
        this._maxIdx = this._max == time ? (long)this._numTimesRecorded : this._maxIdx;
        this._min = Math.min(this._min, time);
        this._minIdx = this._min == time ? (long)this._numTimesRecorded : this._minIdx;
        this._runningTotal += time;
        this._times[this._numTimesRecorded++] = time;
    }

    public void printReport(PrintStream outStream) {
        outStream.println("===================================================");
        outStream.println("Report for performance test: " + this._name);
        outStream.println("Number of iterations: " + this._numTimesRecorded);
        outStream.println("===================================================");
        outStream.println(MessageFormat.format("Max: {0}, Max Index: {1}", this._max, this._maxIdx));
        outStream.println(MessageFormat.format("Min: {0}, Min Index: {1}", this._min, this._minIdx));
        outStream.println(MessageFormat.format("Avg: {0}, StdDev: {1}, StdDev Ignore Max/Min: {2}", this.average(), this.calculateStdDev(false), this.calculateStdDev(true)));
        outStream.println("===================================================");
        outStream.println("");
    }

    private double average() {
        return this._runningTotal / (long)this._numTimesRecorded;
    }

    private double calculateStdDev(boolean ignoreMaxMin) {
        double total = 0.0;
        double avg = this.average();
        int i = 0;
        while (i < this._numTimesRecorded) {
            if (!ignoreMaxMin || (long)i != this._maxIdx && (long)i != this._minIdx) {
                total += Math.pow((double)this._times[i] - avg, 2.0) / (double)this._numTimesRecorded;
            }
            ++i;
        }
        return Math.sqrt(total);
    }
}

