/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class FnData
extends Function {
    public FnData() {
        super(new QName("data"), 1);
    }

    public ResultSequence evaluate(Collection args) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnData.atomize(argument);
    }

    public static ResultSequence atomize(ResultSequence arg) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            if (at instanceof AnyAtomicType) {
                rs.add(at);
                continue;
            }
            if (at instanceof NodeType) {
                NodeType nt = (NodeType)at;
                rs.concat(nt.typed_value());
                continue;
            }
            assert (false);
        }
        return rs;
    }

    public static void fast_atomize(ResultSequence arg) {
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            if (at instanceof AnyAtomicType) continue;
            if (at instanceof NodeType) {
                NodeType nt = (NodeType)at;
                i.set(nt.typed_value().first());
                continue;
            }
            assert (false);
        }
    }

    public static AnyType atomize(AnyType arg) {
        if (arg instanceof AnyAtomicType) {
            return arg;
        }
        if (arg instanceof NodeType) {
            NodeType nt = (NodeType)arg;
            return nt.typed_value().first();
        }
        assert (false);
        return null;
    }
}

