/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.jaxp.validation.XSGrammarPoolContainer;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.custommonkey.xmlunit.XMLTestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.userdefined.UserDefinedCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.testsuite.userdefined.XercesFloatUserDefined;
import org.eclipse.wst.xml.xpath2.processor.testsuite.userdefined.XercesIntegerUserDefined;
import org.eclipse.wst.xml.xpath2.processor.testsuite.userdefined.XercesQNameUserDefined;
import org.eclipse.wst.xml.xpath2.processor.testsuite.userdefined.XercesUserDefined;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class AbstractPsychoPathTest
extends XMLTestCase {
    protected Document domDoc = null;
    protected Document domDoc2 = null;
    protected Bundle bundle = null;
    private DynamicContext dynamicContext = null;
    private static final String INPUT_CONTEXT = "input-context";
    private static final String INPUT_CONTEXT1 = "input-context1";
    private static final String INPUT_CONTEXT2 = "input-context2";
    private static final String S_COMMENT2 = ":)";
    private static final String DECLARE_NAMESPACE = "declare namespace";
    private static final String IMPORT_SCHEMA_NAMESPACE = "import schema namespace";
    private static final String REGEX_DN = " namespace\\s+(\\w[-_\\w]*)\\s*=\\s*['\"]([^;]*)['\"];";
    private static HashMap<String, String> inputMap = new HashMap(3);

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        if (this.bundle == null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
    }

    protected void loadDOMDocument(URL fileURL) throws IOException, DOMLoaderException {
        InputStream is = fileURL.openStream();
        XercesLoader domloader = new XercesLoader();
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
        this.domDoc.setDocumentURI(fileURL.toString());
    }

    protected void loadDOMDocument(URL fileURL, Schema schema) throws IOException, DOMLoaderException {
        InputStream is = fileURL.openStream();
        XercesLoader domloader = new XercesLoader(schema);
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
        this.domDoc.setDocumentURI(fileURL.toString());
    }

    protected void load2DOMDocument(URL fileURL, URL fileURL2) throws IOException, DOMLoaderException {
        InputStream is = fileURL.openStream();
        InputStream is2 = fileURL2.openStream();
        XercesLoader domloader = new XercesLoader();
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
        this.domDoc.setDocumentURI(fileURL.toString());
        this.domDoc2 = domloader.load(is2);
        this.domDoc2.setDocumentURI(fileURL2.toString());
        is.close();
        is2.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.domDoc = null;
        this.domDoc2 = null;
        this.dynamicContext = null;
    }

    protected XSModel getGrammar() {
        ElementPSVI rootPSVI = (ElementPSVI)this.domDoc.getDocumentElement();
        XSModel schema = rootPSVI.getSchemaInformation();
        return schema;
    }

    protected void loadDOMDocument(URL fileURL, URL schemaURL) throws IOException, DOMLoaderException, SAXException {
        InputStream is = fileURL.openStream();
        InputStream schemaIs = schemaURL.openStream();
        Schema jaxpSchema = this.getSchema(schemaIs);
        XercesLoader domloader = new XercesLoader(jaxpSchema);
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
    }

    private Schema getSchema(InputStream schemaIs) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(schemaIs));
        return schema;
    }

    protected XSModel getGrammar(URL schemaURL) throws IOException, SAXException {
        InputStream schemaIs = schemaURL.openStream();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(schemaIs));
        XSGrammarPoolContainer poolContainer = (XSGrammarPoolContainer)schema;
        XMLGrammarPool pool = poolContainer.getGrammarPool();
        Grammar[] grammars = pool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        XSGrammar[] xsGrammars = new XSGrammar[grammars.length];
        System.arraycopy(grammars, 0, xsGrammars, 0, grammars.length);
        return xsGrammars[0].toXSModel(xsGrammars);
    }

    protected DefaultDynamicContext setupDynamicContext(XSModel schema) {
        DefaultDynamicContext dc = new DefaultDynamicContext(schema, this.domDoc);
        this.dynamicContext = dc;
        dc.add_namespace("xs", "http://www.w3.org/2001/XMLSchema");
        dc.add_namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        dc.add_namespace("fn", "http://www.w3.org/2005/xpath-functions");
        dc.add_namespace("xml", "http://www.w3.org/XML/1998/namespace");
        dc.add_function_library((FunctionLibrary)new FnFunctionLibrary());
        dc.add_function_library((FunctionLibrary)new XSCtrLibrary());
        this.setupVariables((DynamicContext)dc);
        return dc;
    }

    protected void addXPathDefaultNamespace(String uri) {
        this.dynamicContext.add_namespace(null, uri);
    }

    protected XPath compileXPath(DynamicContext dc, String xpath) throws XPathParserException, StaticError {
        JFlexCupParser xpp = new JFlexCupParser();
        XPath path = xpp.parse(xpath);
        StaticNameResolver name_check = new StaticNameResolver((StaticContext)dc);
        name_check.check((XPathNode)path);
        return path;
    }

    protected String getExpectedResult(String xqFile) {
        return this.getExpectedResult(xqFile, true);
    }

    protected String getExpectedResultNoEscape(String xqFile) {
        return this.getExpectedResult(xqFile, false);
    }

    protected String getExpectedResult(String xqFile, boolean unescape) {
        String resultFile = xqFile;
        if (resultFile.length() < 10) {
            return resultFile;
        }
        String content = "";
        try {
            InputStream isrf = this.bundle.getEntry(resultFile).openStream();
            BufferedReader rfreader = new BufferedReader(new InputStreamReader(isrf, "UTF-8"));
            int bufferLength = 2048;
            if (resultFile.indexOf("Axes085") != -1 || resultFile.indexOf("NodeTest003") != -1 || resultFile.indexOf("NodeTest004") != -1 || resultFile.indexOf("NodeTest005") != -1) {
                bufferLength = 40000;
            } else if (resultFile.indexOf("ForExpr013") != -1) {
                bufferLength = 433500;
            } else if (resultFile.indexOf("ForExpr016") != -1 || resultFile.indexOf("ReturnExpr011") != -1 || resultFile.indexOf("sgml-queries-results-q1") != -1 || resultFile.indexOf("sgml-queries-results-q2") != -1) {
                bufferLength = 10240;
            }
            char[] cbuf = new char[bufferLength];
            int nByte = rfreader.read(cbuf);
            AbstractPsychoPathTest.assertTrue((String)resultFile, (nByte < bufferLength ? 1 : 0) != 0);
            content = new String(cbuf).trim();
            rfreader.close();
            isrf.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load expected result from : " + xqFile, e);
        }
        if (unescape && content.contains("&")) {
            return this.resolveCharacterReferences(content);
        }
        return content;
    }

    public String unwrapResult(String expectedResult, String elemName) {
        return this.trimSurrounding(expectedResult, "<" + elemName + ">", "</" + elemName + ">");
    }

    protected String getExpectedResult(String resultFile, String elemName) {
        return this.unwrapResult(this.getExpectedResult(resultFile), elemName);
    }

    public String extractXPathExpressionNoEscape(String xqFile, String inputFile) {
        return this.extractXPathExpression(xqFile, inputFile, false);
    }

    public String extractXPathExpression(String xqFile, String inputFile) {
        return this.extractXPathExpression(xqFile, inputFile, true);
    }

    public String extractXPathExpression(String xqFile, String inputFile, boolean unescape) {
        char[] cbuf = new char[2048];
        String content = null;
        String xpath2Expr = null;
        try {
            BufferedReader xqreader;
            int nByte;
            URL entryUrl = this.bundle.getEntry(xqFile);
            InputStream isxq = entryUrl.openStream();
            if (this.dynamicContext.base_uri().string_value() == null) {
                this.dynamicContext.set_base_uri(entryUrl.toString());
            }
            AbstractPsychoPathTest.assertTrue((String)xqFile, ((nByte = (xqreader = new BufferedReader(new InputStreamReader(isxq, Charset.forName("UTF-8")))).read(cbuf)) < 2048 ? 1 : 0) != 0);
            content = new String(cbuf).trim();
            if (content.indexOf(INPUT_CONTEXT) != -1 && content.indexOf(INPUT_CONTEXT1) == -1 && content.indexOf(INPUT_CONTEXT2) == -1) {
                inputMap.put(INPUT_CONTEXT, inputFile);
            } else if (content.indexOf(INPUT_CONTEXT1) == -1) {
                inputMap.put(INPUT_CONTEXT1, inputFile);
            } else if (content.indexOf(INPUT_CONTEXT2) != -1) {
                inputMap.put(INPUT_CONTEXT2, inputFile);
            }
            if (content.indexOf(DECLARE_NAMESPACE) != -1 || content.indexOf(IMPORT_SCHEMA_NAMESPACE) != -1) {
                this.setupNamespace(content);
            }
            AbstractPsychoPathTest.assertTrue((content.lastIndexOf(S_COMMENT2) != -1 ? 1 : 0) != 0);
            xpath2Expr = content.substring(content.lastIndexOf(S_COMMENT2) + 2).trim();
            xqreader.close();
            isxq.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't extract XPath expression from XQuery file : " + xqFile, e);
        }
        if (unescape && xpath2Expr.contains("&")) {
            return this.resolveCharacterReferences(xpath2Expr);
        }
        return xpath2Expr;
    }

    protected String extractXPathExpression(String xqFile, String inputFile, String tagName) {
        return this.unwrapQuery(this.extractXPathExpression(xqFile, inputFile), tagName);
    }

    protected String unwrapQuery(String xpath2Expr, String tag) {
        String endStr;
        String str = "<" + tag + ">";
        String withoutTag = this.trimSurrounding(xpath2Expr, str, endStr = "</" + tag + ">");
        if (withoutTag != xpath2Expr) {
            xpath2Expr = this.trimSurrounding(withoutTag, "{", "}");
        }
        return xpath2Expr;
    }

    protected String trimSurrounding(String xpath2Expr, String str, String endStr) {
        int indexOfStart = xpath2Expr.indexOf(str);
        int indexOfEnd = xpath2Expr.indexOf(endStr);
        if (indexOfStart >= 0 && indexOfEnd >= 0) {
            xpath2Expr = xpath2Expr.substring(indexOfStart + str.length(), indexOfEnd).trim();
        }
        return xpath2Expr;
    }

    protected void setupNamespace(String content) {
        if (this.dynamicContext == null) {
            return;
        }
        Pattern p = Pattern.compile(REGEX_DN);
        Matcher m = p.matcher(content);
        while (m.find()) {
            AbstractPsychoPathTest.assertTrue((m.groupCount() == 2 ? 1 : 0) != 0);
            this.dynamicContext.add_namespace(m.group(1), m.group(2));
        }
    }

    protected DynamicContext setupVariables(DynamicContext dc) {
        dc.add_variable(new QName("x"));
        dc.add_variable(new QName("var"));
        if (this.domDoc != null) {
            DocType docType = new DocType(this.domDoc);
            dc.set_variable(new QName(INPUT_CONTEXT1), (AnyType)docType);
            dc.set_variable(new QName(INPUT_CONTEXT), (AnyType)docType);
            if (this.domDoc2 == null) {
                dc.set_variable(new QName(INPUT_CONTEXT2), (AnyType)docType);
            } else {
                dc.set_variable(new QName(INPUT_CONTEXT2), (AnyType)new DocType(this.domDoc2));
            }
        }
        return dc;
    }

    protected String buildResultString(ResultSequence rs) {
        String actual = new String();
        for (AnyType anyType : rs) {
            actual = String.valueOf(actual) + anyType.string_value() + " ";
        }
        return actual.trim();
    }

    protected String buildXMLResultString(ResultSequence rs) throws Exception {
        DOMImplementationLS domLS = (DOMImplementationLS)this.domDoc.getImplementation().getFeature("LS", "3.0");
        LSOutput outputText = domLS.createLSOutput();
        LSSerializer serializer = domLS.createLSSerializer();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputText.setByteStream(outputStream);
        String actual = new String();
        ListIterator iterator = rs.iterator();
        boolean queueSpace = false;
        while (iterator.hasNext()) {
            AnyType aat = (AnyType)iterator.next();
            if (aat instanceof NodeType) {
                NodeType nodeType = (NodeType)aat;
                Node node = nodeType.node_value();
                serializer.write(node, outputText);
                queueSpace = false;
                continue;
            }
            if (queueSpace) {
                outputText.getByteStream().write(32);
            }
            outputText.getByteStream().write(aat.string_value().getBytes("UTF-8"));
            queueSpace = true;
        }
        actual = outputStream.toString("UTF-8");
        actual = actual.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        actual = actual.replace("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>", "");
        outputStream.close();
        return actual.trim();
    }

    protected String formatResultString(String resultFile) throws Exception {
        XercesLoader domloader = new XercesLoader(null);
        domloader.set_validating(false);
        InputStream is = this.bundle.getEntry(resultFile).openStream();
        Document resultDoc = domloader.load(is);
        DOMImplementationLS domLS = (DOMImplementationLS)resultDoc.getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = domLS.createLSSerializer();
        String actual = serializer.writeToString(resultDoc.getDocumentElement());
        actual = actual.replace("<?xml version=\"1.0\" encoding=\"UTF-16\"?>", "");
        return actual.trim();
    }

    protected String removeIrrelevantNamespaces(String expectedResult) {
        expectedResult = expectedResult.replaceAll(" xmlns:xml=\"http://www.w3.org/XML/1998/namespace\"", "");
        expectedResult = expectedResult.replaceAll(" xmlns:foo=\"http://www.example.com/foo\"", "");
        expectedResult = expectedResult.replaceAll(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
        return expectedResult;
    }

    protected String resolveCharacterReferences(String xpath) {
        String docText = "<doc>" + xpath + "</doc>";
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(docText.getBytes("UTF-8"));
            XercesLoader domloader = new XercesLoader();
            domloader.set_validating(false);
            Document temp = domloader.load((InputStream)is);
            return temp.getDocumentElement().getFirstChild().getTextContent();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (DOMLoaderException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addUserDefinedSimpleTypes(XSModel schema, DynamicContext dc) {
        XSNamedMap xstypes = schema.getComponents((short)3);
        if (xstypes.getLength() == 0) {
            return;
        }
        dc.add_namespace("myType", "http://www.w3.org/XQueryTest/userDefinedTypes");
        UserDefinedCtrLibrary udl = new UserDefinedCtrLibrary("http://www.w3.org/XQueryTest/userDefinedTypes");
        int i = 0;
        while (i < xstypes.getLength()) {
            XSObject xsobject = xstypes.item(i);
            if ("http://www.w3.org/XQueryTest/userDefinedTypes".equals(xsobject.getNamespace()) && xsobject instanceof XSSimpleTypeDefinition) {
                if (((XSSimpleTypeDefinition)xsobject).getNumeric()) {
                    if (xsobject.getName().equals("floatBased") || xsobject.getName().equals("shoesize")) {
                        XercesFloatUserDefined fudt = new XercesFloatUserDefined(xsobject);
                        udl.add_type((CtrType)fudt);
                    } else {
                        XercesIntegerUserDefined iudt = new XercesIntegerUserDefined(xsobject);
                        udl.add_type((CtrType)iudt);
                    }
                } else if (xsobject.getName().equals("QNameBased")) {
                    XercesQNameUserDefined qudt = new XercesQNameUserDefined(xsobject);
                    udl.add_type((CtrType)qudt);
                } else {
                    XercesUserDefined udt = new XercesUserDefined(xsobject);
                    udl.add_type((CtrType)udt);
                }
            }
            ++i;
        }
        dc.add_function_library((FunctionLibrary)udl);
    }
}

