/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker.test;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;

public class TransformDefinitonTest
extends TestCase {
    TransformDefinition tdef = null;

    protected void setUp() throws Exception {
        this.tdef = new TransformDefinition();
    }

    protected void tearDown() throws Exception {
        this.tdef = null;
    }

    public void testDefaultResolver() throws Exception {
        String resolver = this.tdef.getResolverClass();
        TransformDefinitonTest.assertEquals((String)"Did not find default resolver", (String)"org.apache.xml.resolver.tools.CatalogResolver", (String)resolver);
    }

    public void testChangeResolverFromDefault() throws Exception {
        String resolver = "org.eclipse.wst.xml.catalog.URIResolver";
        this.tdef.setResolverClass(resolver);
        TransformDefinitonTest.assertEquals((String)"Problem setting a new resolver", (String)resolver, (String)this.tdef.getResolverClass());
    }

    public void testAddParameters() throws Exception {
        this.setupParameters();
        TransformDefinitonTest.assertNotNull((String)"Missing paramerters", (Object)this.tdef.getParameters());
    }

    public void testGetParameters() throws Exception {
        this.setupParameters();
        Set parmSet = this.tdef.getParameters();
        TransformDefinitonTest.assertEquals((String)"Incorrect size returned.", (int)1, (int)parmSet.size());
    }

    public void testGetParametersAsMap() throws Exception {
        this.setupParameters();
        Map parmMap = this.tdef.getParametersAsMap();
        TransformDefinitonTest.assertNotNull((String)"Missing parmater MAP.", (Object)parmMap);
    }

    public void testStyleSheetSource() throws Exception {
        String stylesheet = "http://www.example.org/stylesheet.xsl";
        this.tdef.setStylesheetURL(stylesheet);
        TransformDefinitonTest.assertNotNull((String)"Missing stylesheet.", (Object)this.tdef.getStylesheetURL());
        TransformDefinitonTest.assertEquals((String)"Incorrect stylesheet.", (String)stylesheet, (String)this.tdef.getStylesheetURL());
    }

    public void testRemoveParameter() throws Exception {
        TypedValue param = this.setupParameters();
        TransformDefinitonTest.assertTrue((this.tdef.getParameters().size() > 0 ? 1 : 0) != 0);
        this.tdef.removeParameter(param);
        TransformDefinitonTest.assertTrue((String)"Found parameters when there should be zero.", (this.tdef.getParameters().size() == 0 ? 1 : 0) != 0);
    }

    public void testSetOutputProperty() throws Exception {
        this.tdef.setOutputProperty("output", "test");
        String value = this.tdef.getOutputProperties().getProperty("output");
        TransformDefinitonTest.assertEquals((String)"Incorrect value", (String)"test", (String)value);
    }

    public void testNoOutputProperties() throws Exception {
        TransformDefinitonTest.assertEquals((String)"Found output properties when there should be none.", (int)0, (int)this.tdef.getOutputProperties().size());
    }

    public void testRemoveOutputProperty() throws Exception {
        this.tdef.setOutputProperty("output", "test");
        Properties properties = this.tdef.getOutputProperties();
        TransformDefinitonTest.assertEquals((int)1, (int)properties.size());
        this.tdef.removeOutputProperty("output");
    }

    private TypedValue setupParameters() {
        TypedValue param = new TypedValue("param", "string", "test");
        this.tdef.addParameter(param);
        return param;
    }
}

