/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInspectorImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void setUpSpecific() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("EndpointAnnInspector.src", "EndpointAnnInspector");
    }

    public void testInspector() throws Exception {
        IMethod[] methods;
        this.setUp();
        try {
            AnnotationFactory.createAnnotationInspector(null).inspectType();
            AnnotationInspectorImplTest.fail((String)"NullPointerException should be thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationInspectorImplTest.assertTrue((boolean)true);
        }
        try {
            AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(null);
            AnnotationInspectorImplTest.fail((String)"NullPointerException should be thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationInspectorImplTest.assertTrue((boolean)true);
        }
        try {
            AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(null);
            AnnotationInspectorImplTest.fail((String)"NullPointerException should be thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationInspectorImplTest.assertTrue((boolean)true);
        }
        try {
            AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(null);
            AnnotationInspectorImplTest.fail((String)"NullPointerException should be thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationInspectorImplTest.assertTrue((boolean)true);
        }
        IValue sv = AnnotationFactory.createStringValue((String)"My Value");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)sv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint.getField("field1"));
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint.getField("field1"));
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(this.endpoint.getField("field1"));
        AnnotationInspectorImplTest.assertNotNull((Object)annotations);
        AnnotationInspectorImplTest.assertTrue((annotations.size() == 1 ? 1 : 0) != 0);
        IAnnotation annP = (IAnnotation)annotations.iterator().next();
        AnnotationWriter.getInstance().remove(annP);
        annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(this.endpoint.getField("field1"));
        AnnotationInspectorImplTest.assertNotNull((Object)annotations);
        AnnotationInspectorImplTest.assertTrue((annotations.size() == 0 ? 1 : 0) != 0);
        IMethod[] iMethodArray = methods = this.endpoint.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getRawParameterNames() != null && method.getRawParameterNames().length > 0) {
                int i = 0;
                while (i < method.getRawParameterNames().length) {
                    ITypeParameter param = method.getTypeParameter(method.getRawParameterNames()[i]);
                    IValue svParam = AnnotationFactory.createStringValue((String)"String Valu Param");
                    HashSet<IParamValuePair> pvParam = new HashSet<IParamValuePair>();
                    pvParam.add(AnnotationFactory.createParamValuePairValue((String)"ParamAtribute", (IValue)svParam));
                    IAnnotation annPam = AnnotationFactory.createAnnotation((String)"ParamAnnotation", pvParam, (IJavaElement)param);
                    AnnotationWriter.getInstance().setAppliedElement(annPam, (IJavaElement)param);
                    Collection paramAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(param);
                    AnnotationInspectorImplTest.assertNotNull((Object)paramAnnotations);
                    AnnotationInspectorImplTest.assertTrue((paramAnnotations.size() == 1 ? 1 : 0) != 0);
                    IAnnotation tmpAnn = (IAnnotation)paramAnnotations.iterator().next();
                    AnnotationWriter.getInstance().remove(tmpAnn);
                    paramAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(param);
                    AnnotationInspectorImplTest.assertNotNull((Object)paramAnnotations);
                    AnnotationInspectorImplTest.assertTrue((paramAnnotations.size() == 0 ? 1 : 0) != 0);
                    annPam = AnnotationFactory.createAnnotation((String)"ParamAnnotation2", pvParam, (IJavaElement)param);
                    AnnotationWriter.getInstance().setAppliedElement(annPam, (IJavaElement)param);
                    paramAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(param);
                    AnnotationInspectorImplTest.assertNotNull((Object)paramAnnotations);
                    AnnotationInspectorImplTest.assertTrue((paramAnnotations.size() == 1 ? 1 : 0) != 0);
                    AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)param);
                    paramAnnotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(param);
                    AnnotationInspectorImplTest.assertNotNull((Object)paramAnnotations);
                    AnnotationInspectorImplTest.assertTrue((paramAnnotations.size() == 0 ? 1 : 0) != 0);
                    ++i;
                }
            }
            ++n2;
        }
    }

    public void testInspectorSpecificAnnotation() throws Exception {
        this.setUpSpecific();
        IAnnotation inspectedTypeAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType("org.eclipse.demo.MyAnnotation");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedTypeAnnotation);
        AnnotationInspectorImplTest.assertEquals((String)inspectedTypeAnnotation.getPropertyValue("myValue"), (String)"MyString");
        inspectedTypeAnnotation = null;
        inspectedTypeAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType("javax.jws.WebService");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedTypeAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"javax.jws.WebService".endsWith(inspectedTypeAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedTypeAnnotation.getPropertyValue("serviceName"), (String)"WSImplBeanService");
        AnnotationInspectorImplTest.assertEquals((String)inspectedTypeAnnotation.getPropertyValue("name"), (String)"WSImplBean");
        AnnotationInspectorImplTest.assertEquals((String)inspectedTypeAnnotation.getPropertyValue("targetNamespace"), (String)"http://demo/eclipse/org/");
        AnnotationInspectorImplTest.assertEquals((String)inspectedTypeAnnotation.getPropertyValue("portName"), (String)"WSImplBeanPort");
        IField field = this.endpoint.getField("field1");
        IAnnotation inspectedFieldAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(field, "org.eclipse.demo.MyFieldAnnotation");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedFieldAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"org.eclipse.demo.MyFieldAnnotation".endsWith(inspectedFieldAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedFieldAnnotation.getPropertyValue("name"), (String)"field1");
        inspectedFieldAnnotation = null;
        inspectedFieldAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectField(field, "javax.jws.WebField");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedFieldAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"javax.jws.WebField".endsWith(inspectedFieldAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedFieldAnnotation.getPropertyValue("name"), (String)"MyField");
        IMethod method = this.endpoint.getMethods()[0];
        IAnnotation inspectedMethodAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method, "org.eclipse.demo.MyMethodAnnotation");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedMethodAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"org.eclipse.demo.MyMethodAnnotation".endsWith(inspectedMethodAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedMethodAnnotation.getPropertyValue("name"), (String)"annotatedMethod");
        inspectedMethodAnnotation = null;
        inspectedMethodAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method, "javax.jws.WebMethod");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedMethodAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"javax.jws.WebMethod".endsWith(inspectedMethodAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedMethodAnnotation.getPropertyValue("exclude"), (String)"false");
        AnnotationInspectorImplTest.assertEquals((String)inspectedMethodAnnotation.getPropertyValue("operationName"), (String)"test");
        ITypeParameter typeParameter = method.getTypeParameter("annotatedParam");
        IAnnotation inspectedParamAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter, "org.eclipse.demo.MyParamAnnotation");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedParamAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"org.eclipse.demo.MyParamAnnotation".endsWith(inspectedParamAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedParamAnnotation.getPropertyValue("name"), (String)"annotatedMyParam");
        inspectedParamAnnotation = null;
        inspectedParamAnnotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectParam(typeParameter, "javax.jws.WebParam");
        AnnotationInspectorImplTest.assertNotNull((Object)inspectedParamAnnotation);
        AnnotationInspectorImplTest.assertTrue((boolean)"javax.jws.WebParam".endsWith(inspectedParamAnnotation.getAnnotationName()));
        AnnotationInspectorImplTest.assertEquals((String)inspectedParamAnnotation.getPropertyValue("name"), (String)"annotatedParam");
    }

    public void testInspectorLocatorRetrieved() throws Exception {
        this.setUpSpecific();
        IAnnotation annotation = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType("javax.jws.WebService");
        AnnotationInspectorImplTest.assertNotNull((Object)annotation);
        AnnotationInspectorImplTest.assertEquals((int)11, (int)annotation.getLocator().getLineNumber());
        AnnotationInspectorImplTest.assertEquals((int)226, (int)annotation.getLocator().getStartPosition());
        AnnotationInspectorImplTest.assertEquals((int)134, (int)annotation.getLocator().getLength());
        AnnotationInspectorImplTest.assertEquals((int)11, (int)this.getParam("portName", (IAnnotation<? extends IJavaElement>)annotation).getLocator().getLineNumber());
        AnnotationInspectorImplTest.assertEquals((int)334, (int)this.getParam("portName", (IAnnotation<? extends IJavaElement>)annotation).getLocator().getStartPosition());
        AnnotationInspectorImplTest.assertEquals((int)25, (int)this.getParam("portName", (IAnnotation<? extends IJavaElement>)annotation).getLocator().getLength());
    }

    private IParamValuePair getParam(String name, IAnnotation<? extends IJavaElement> annotation) {
        for (IParamValuePair param : annotation.getParamValuePairs()) {
            if (!param.getParam().equals(name)) continue;
            return param;
        }
        return null;
    }
}

