/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.defect.tests;

import java.io.File;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.defect.tests.ClasspathContainerThreading;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.ejb.project.operations.IEjbFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebImportOperationTest;

public class DefectVerificationTests
extends OperationTestCase {
    public static String BASE_DATA_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "DefectTestData" + File.separatorChar;
    private static final String TEST_DATA_PATH = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "TestData" + File.separatorChar;

    private static String getDataPath(String suffix) {
        return String.valueOf(BASE_DATA_DIRECTORY) + "componentLoadAdapterTestData" + File.separatorChar + suffix;
    }

    public static String getFullTestDataPath(String dataPath) {
        try {
            String defectTestDataPath = "DefectTestData" + fileSep + dataPath;
            HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
            if (plugin != null) {
                return ProjectUtility.getFullFileName((Plugin)plugin, (String)defectTestDataPath);
            }
            return String.valueOf(System.getProperty("user.dir")) + File.separatorChar + defectTestDataPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void _test261508() throws Exception {
        String earFileName = DefectVerificationTests.getFullTestDataPath("EARForLibDep.ear");
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        DefectVerificationTests.runAndVerify((IDataModel)model);
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)J2EEProjectUtilities.getProject((String)"WebForLibDep"));
        IVirtualReference[] refs = webComponent.getReferences();
        Assert.assertTrue((refs.length == 2 ? 1 : 0) != 0);
        IVirtualReference[] iVirtualReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent refComponent = ref.getReferencedComponent();
            if (refComponent instanceof J2EEModuleVirtualArchiveComponent) {
                J2EEModuleVirtualArchiveComponent j2eeVirtualArchive = (J2EEModuleVirtualArchiveComponent)refComponent;
                Assert.assertTrue((boolean)j2eeVirtualArchive.getName().endsWith("EjbTestClient.jar"));
            }
            ++n2;
        }
    }

    public void test130657() throws Exception {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)"Test120018");
        model.getDefaultOperation().execute(null, null);
        IVirtualComponent component = ComponentUtilities.getComponent((String)"Test120018");
        IFolder folder = component.getProject().getFolder("imported_classes");
        folder.create(true, true, null);
        IFile fakeClassFile = folder.getFile("Fake.class");
        fakeClassFile.create((InputStream)new StringBufferInputStream(""), true, null);
        Assert.assertTrue((String)"Class file should have been created in project.", (boolean)component.getProject().exists(fakeClassFile.getProjectRelativePath()));
        IVirtualFolder jsrc = component.getRootFolder().getFolder("/WEB-INF/classes");
        jsrc.createLink(folder.getProjectRelativePath(), 0, null);
        Assert.assertEquals((String)"Should be a link for each class in imported_classes.", (int)folder.members().length, (int)jsrc.members().length);
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentExportDataModelProvider());
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)DefectVerificationTests.getDataPath("testblah.war"));
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)component);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", true);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", true);
        IStatus status = dataModel.getDefaultOperation().execute(null, null);
        Assert.assertEquals((String)("Creating WAR failed " + status.getMessage()), (int)0, (int)status.getSeverity());
        IArchive archiveWAR = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(DefectVerificationTests.getDataPath("testblah.war")));
        int i = 0;
        while (i < jsrc.members().length) {
            Assert.assertTrue((String)"Archive does not contain resource for each linked imported class.", (boolean)archiveWAR.containsArchiveResource(jsrc.members()[i].getRuntimePath().makeRelative()));
            ++i;
        }
        JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveWAR);
    }

    public void test120018() throws Exception {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)"Test120018");
        model.getDefaultOperation().execute(null, null);
        IVirtualComponent component = ComponentUtilities.getComponent((String)"Test120018");
        IVirtualFolder folder = component.getRootFolder().getFolder("imported_classes");
        folder.create(0, null);
        IPath folderPath = folder.getProjectRelativePath();
        IVirtualFolder jsrc = component.getRootFolder().getFolder("/WEB-INF/classes");
        jsrc.createLink(folder.getProjectRelativePath(), 0, null);
        J2EEComponentClasspathUpdater.getInstance().forceUpdate(Collections.singleton(component.getProject()));
        IJobManager manager = Job.getJobManager();
        Job[] jobs = manager.find((Object)J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
        if (jobs.length > 0) {
            try {
                int i = 0;
                while (i < jobs.length) {
                    if (jobs[i].getName().equals(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME)) {
                        jobs[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)component.getProject());
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        boolean foundImportedClasses = false;
        int i = 0;
        while (i < entries.length && !foundImportedClasses) {
            if (5 == entries[i].getEntryKind()) {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entries[i].getPath(), (IJavaProject)javaProject);
                IClasspathEntry[] containerEntries = container.getClasspathEntries();
                int j = 0;
                while (j < containerEntries.length && !foundImportedClasses) {
                    IPath entryPath = containerEntries[j].getPath().removeFirstSegments(1);
                    foundImportedClasses = folderPath.equals((Object)entryPath);
                    if (foundImportedClasses) break;
                    ++j;
                }
            }
            ++i;
        }
    }

    public void test105901() throws Exception {
        String earFileName = DefectVerificationTests.getFullTestDataPath("Collision.ear");
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        DefectVerificationTests.runAndVerify((IDataModel)model);
        IVirtualComponent comp = (IVirtualComponent)model.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
        IVirtualReference[] refs = comp.getReferences();
        DefectVerificationTests.assertEquals((int)3, (int)refs.length);
    }

    public void test109430() throws Exception {
        String earFileName = DefectVerificationTests.getFullTestDataPath("EJBLocalAndRemoteRefEARWithClientJars.ear");
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        List cfr_ignored_0 = (List)model.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        DefectVerificationTests.runAndVerify((IDataModel)model);
        IVirtualComponent component = (IVirtualComponent)model.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
        EARArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)component);
            EARFile earFile = null;
            try {
                earFile = (EARFile)artifactEdit.asArchive(true);
                earFile.getEJBReferences(false, false);
            }
            finally {
                if (earFile != null) {
                    earFile.close();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void test112636() throws Exception {
        this.checkDeploy("BeenThere.ear");
    }

    public void test112835() throws Exception {
        this.checkDeploy("sib.test.mediations.m5.JsMBR.ear");
    }

    public void test121158() throws Exception {
        String earFileName = DefectVerificationTests.getFullTestDataPath("EAR121158.ear");
        EARFile earFile = null;
        try {
            ArchiveOptions opts = new ArchiveOptions();
            opts.setIsReadOnly(true);
            earFile = CommonarchiveFactory.eINSTANCE.openEARFile(opts, earFileName);
            List moduleList = earFile.getModuleFiles();
            int i = 0;
            while (i < moduleList.size()) {
                ModuleFile module = (ModuleFile)moduleList.get(i);
                RuntimeClasspathEntry[] entries = module.getFullRuntimeClassPath();
                DefectVerificationTests.assertEquals((int)2, (int)entries.length);
                DefectVerificationTests.assertTrue((boolean)entries[0].toString().endsWith(module.getURI()));
                DefectVerificationTests.assertTrue((boolean)entries[1].toString().endsWith("EAR121158Util.jar"));
                ++i;
            }
        }
        finally {
            if (earFile != null && earFile.isOpen()) {
                earFile.close();
                earFile = null;
            }
        }
    }

    protected void checkDeploy(String earName) throws Exception {
        String earFileName = DefectVerificationTests.getFullTestDataPath(earName);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        DefectVerificationTests.runAndVerify((IDataModel)model);
        IVirtualComponent comp = (IVirtualComponent)model.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
        EARArtifactEdit earEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)comp);
        EARFile earFile = (EARFile)earEdit.asArchive(false);
        earFile.getEJBReferences(true, true);
        earFile.getEJBReferences(true, false);
        earFile.getEJBReferences(false, true);
        earFile.getEJBReferences(false, false);
        earFile.close();
        earFile = null;
        Thread.sleep(5000L);
        String earOutputName = "c:\\temp\\Output" + System.currentTimeMillis() + ".ear";
        IDataModel export = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
        export.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)comp.getProject().getName());
        export.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)earOutputName);
        DefectVerificationTests.runAndVerify((IDataModel)export);
    }

    public void test143483() throws Exception {
        this.checkDeploy("undeployed_DefaultApplication.ear");
    }

    public void test145460() throws Exception {
        String warName = "Example1.war";
        String warFileName = DefectVerificationTests.getFullTestDataPath(warName);
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentImportDataModelProvider());
        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)"AN_EAR");
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
        dataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)warFileName);
        dataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)"A_WAR");
        DefectVerificationTests.runAndVerify((IDataModel)dataModel);
    }

    public void test149995() throws Exception {
        String earName = "149995.ear";
        String earFileName = DefectVerificationTests.getFullTestDataPath(earName);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        DefectVerificationTests.runAndVerify((IDataModel)model);
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)J2EEProjectUtilities.getProject((String)"149995"));
        IVirtualResource[] members = earComponent.getRootFolder().members();
        Assert.assertEquals((int)5, (int)members.length);
        this.setUp();
        model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earFileName);
        model.setProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST", (Object)Collections.EMPTY_LIST);
        DefectVerificationTests.runAndVerify((IDataModel)model);
        earComponent = ComponentCore.createComponent((IProject)J2EEProjectUtilities.getProject((String)"149995"));
        members = earComponent.getRootFolder().members();
        Assert.assertEquals((int)5, (int)members.length);
    }

    public void test149995_BinaryClaspathTest() throws Exception {
    }

    public void test159481() throws Exception {
        ArchiveOptions options = new ArchiveOptions();
        options.setRendererType(2);
        String earPath = DefectVerificationTests.getFullTestDataPath("WebDavTest.war");
        CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
        WARFile warFile = pkg.getCommonarchiveFactory().openWARFile(options, earPath);
        warFile.getDeploymentDescriptor();
    }

    public void test145805() throws Exception {
        ClasspathContainerThreading threading = new ClasspathContainerThreading();
        threading.testDeadlock();
    }

    public void test160562() throws Exception {
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"A.jar", (String)"B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./A.jar", (String)"B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"A.jar", (String)"./B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"././././A.jar", (String)"B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"A.jar", (String)"././././B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"././././A.jar", (String)"././././B.jar"));
        Assert.assertEquals((String)"lib/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"A.jar", (String)"lib/B.jar"));
        Assert.assertEquals((String)"lib/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./A.jar", (String)"lib/B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"../A.jar", (String)"lib/B.jar"));
        Assert.assertEquals((String)"lib/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"../lib/A.jar", (String)"lib/B.jar"));
        Assert.assertEquals((String)"A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"../../../A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"../../A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"../A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/bar/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/bar/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/bar/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/bar/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./../bar/../../foo/./bar/A.jar", (String)"lib/foo/bar/B.jar"));
        Assert.assertEquals((String)"lib/foo/bar/A.jar", (String)ArchiveUtil.deriveEARRelativeURI((String)"./A.jar", (String)"lib/foo/bar/B.jar"));
    }

    public void test184154() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String projName = "TestAPIEjbProject";
        String ejbVersionString = J2EEVersionUtil.convertVersionIntToString((int)21);
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion ejbFacetVersion = ejbFacet.getVersion(ejbVersionString);
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel appmodel = (IDataModel)map.get((Object)"jst.ejb");
        appmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)ejbFacetVersion);
        appmodel.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "ejb333");
        String ejbClientName = String.valueOf(projName) + "Client";
        map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        appmodel = (IDataModel)map.get((Object)"jst.ejb");
        appmodel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
        appmodel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", ejbClientName);
        String clientURI = String.valueOf(ejbClientName) + "zzzzz" + ".jar";
        appmodel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_URI ", clientURI);
        String earProjName = String.valueOf(projName) + "EAR";
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earProjName);
        DefectVerificationTests.runAndVerify((IDataModel)dataModel);
        IVirtualComponent component = ComponentUtilities.getComponent((String)earProjName);
        IVirtualComponent ejbClientComponent = ComponentUtilities.getComponent((String)ejbClientName);
        IVirtualReference reference = component.getReference(ejbClientComponent.getName());
        Assert.assertEquals((Object)reference.getReferencedComponent(), (Object)ejbClientComponent);
        Assert.assertEquals((String)reference.getArchiveName(), (String)clientURI);
        String utilityProjectName = "TestUtilityProject";
        String utilEarProjectName = String.valueOf(utilityProjectName) + "EAR";
        String utilityURI = String.valueOf(utilityProjectName) + ".jar";
        ProjectUtil.createUtilityProject(utilityProjectName, utilEarProjectName);
        IVirtualComponent earComponent = ComponentUtilities.getComponent((String)utilEarProjectName);
        IVirtualComponent utilClientComponent = ComponentUtilities.getComponent((String)utilityProjectName);
        IVirtualReference reference1 = earComponent.getReference(utilClientComponent.getName());
        Assert.assertEquals((Object)reference1.getReferencedComponent(), (Object)utilClientComponent);
        Assert.assertEquals((String)reference1.getArchiveName(), (String)utilityURI);
        String javaProjectName = "TestJavaProject";
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(javaProjectName);
        proj.create(null);
        proj.open(null);
        IProjectDescription description = proj.getDescription();
        ArrayList<String> natureList = new ArrayList<String>();
        natureList.add("org.eclipse.jdt.core.javanature");
        natureList.addAll(Arrays.asList(description.getNatureIds()));
        description.setNatureIds(natureList.toArray(new String[natureList.size()]));
        proj.setDescription(description, null);
        JavaCore.create((IProject)proj);
        IDataModel migrationdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        migrationdm.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)proj.getName());
        DefectVerificationTests.runAndVerify((IDataModel)migrationdm);
        String javaProjectURI = String.valueOf(proj.getName()) + ".jar";
        IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        IVirtualComponent targetcomponent = ComponentCore.createComponent((IProject)proj);
        targetCompList.add(targetcomponent);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComponent);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
        ((Map)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP")).put(targetcomponent, javaProjectURI);
        DefectVerificationTests.runAndVerify((IDataModel)refdm, (boolean)true, (boolean)true, null, (boolean)true, (boolean)true);
        IVirtualReference reference2 = earComponent.getReference(targetcomponent.getName());
        Assert.assertEquals((Object)reference2.getReferencedComponent(), (Object)targetcomponent);
        Assert.assertEquals((String)reference2.getArchiveName(), (String)javaProjectURI);
    }

    public void test311542() throws Exception {
        String warPath = null;
        String projectName = null;
        IDataModel model = null;
        warPath = this.getWarFile("Bug311542.war");
        projectName = warPath.substring(warPath.lastIndexOf(File.separator) + 1, warPath.length() - 4);
        model = WebImportOperationTest.getWebImportDataModel(warPath, projectName, null, true, null, null);
        OperationTestCase.runAndVerify((IDataModel)model);
    }

    private String getWarFile(String fileName) {
        return String.valueOf(TEST_DATA_PATH) + "WarImportTests" + File.separatorChar + fileName;
    }

    private void checkIfModelIsParsed(WebApp deploymentDescriptor1) {
        Assert.assertNotNull((Object)deploymentDescriptor1);
        Assert.assertNotNull((Object)deploymentDescriptor1.getConstraints());
        Assert.assertFalse((boolean)deploymentDescriptor1.getConstraints().isEmpty());
        Assert.assertNotNull((Object)deploymentDescriptor1.getSecurityRoles());
        Assert.assertFalse((boolean)deploymentDescriptor1.getSecurityRoles().isEmpty());
    }
}

