/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBResourceImpl;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class JEE5LegacyModelTest
extends GeneralEMFPopulationTest {
    private static final String PROJECTNAME = "TESTEJB3Import";
    private static final String BASE_IMPORT_DIR = "TestData" + File.separatorChar;

    public JEE5LegacyModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(JEE5LegacyModelTest.class);
    }

    protected Object primCreateAttributeValue(EAttribute att, EObject eObject) {
        if (att.getEAttributeType() == XMLTypePackage.eINSTANCE.getQName()) {
            return null;
        }
        return super.primCreateAttributeValue(att, eObject);
    }

    public static IDataModel getEJBImportDataModel(String filePath, String projectName, IDataModel creationModel, boolean closeArchiveOnDispose) {
        IDataModel importModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentImportDataModelProvider());
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filePath);
        importModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)closeArchiveOnDispose);
        if (creationModel != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", (Object)creationModel);
        }
        return importModel;
    }

    protected String getArchivePath(String archiveName) throws Exception {
        HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
        String pluginRelativeFileName = String.valueOf(BASE_IMPORT_DIR) + this.getTestDataDirectoryName() + File.separatorChar + archiveName;
        return ProjectUtility.getFullFileName((Plugin)plugin, (String)pluginRelativeFileName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProject(PROJECTNAME).isAccessible()) {
            return;
        }
        IProjectDescription description = workspace.newProjectDescription(PROJECTNAME);
        description.setLocation(null);
        IHeadlessRunnableWithProgress op = new IHeadlessRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    String archiveName = JEE5LegacyModelTest.this.getArchivePath("TestEJB3.jar");
                    IDataModel importModel = JEE5LegacyModelTest.getEJBImportDataModel(archiveName, JEE5LegacyModelTest.PROJECTNAME, null, true);
                    importModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void testEJBModel() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        String modelPathURI = "META-INF/ejb-jar.xml";
        URI uri = URI.createURI((String)(String.valueOf(J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")) + "/" + modelPathURI));
        FlexibleProjectResourceSet resSet = this.getResourceSet(PROJECTNAME);
        EJBResourceImpl ejbRes = (EJBResourceImpl)resSet.getResource(uri, true, EJBJarResourceFactory.getRegisteredFactory());
        Assert.assertTrue((ejbRes.getContents().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ejbRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (ejbRes.getContents().size() > 0) {
            EJBJar jar = ejbRes.getEJBJar();
            EList beanslist = jar.getEnterpriseBeans();
            for (EnterpriseBean enterpriseBean : beanslist) {
                System.out.println(enterpriseBean.getName());
                System.out.println(enterpriseBean.getHomeInterfaceName());
                if (enterpriseBean instanceof Session) {
                    System.out.println(((Session)enterpriseBean).getServiceEndpointName());
                }
                enterpriseBean.setDescription("Ugh");
            }
        }
        ejbRes.save(null);
    }

    public void testUsingEJBArtifactEdit() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.getProject());
            EJBJar ejb = edit.getEJBJar();
            boolean pass = !ejb.getEnterpriseBeans().isEmpty();
            JEE5LegacyModelTest.assertTrue((boolean)pass);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private FlexibleProjectResourceSet getResourceSet(String projName) {
        IProject proj = this.getProject(projName);
        return (FlexibleProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj);
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
    }

    public IProject getProject(String projName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    private void registerFactory(URI uri, ResourceSet resSet, Resource.Factory factory) {
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), factory);
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }

    protected void tearDown() throws Exception {
    }

    protected String getTestDataDirectoryName() {
        return "EJBImportTests";
    }
}

