/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.ejb.project.operations.IEjbFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.CreationConstants;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.IAppClientFacetInstallDataModelProperties;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.internal.util.ApplicationResourceImpl;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.applicationclient.internal.util.ApplicationclientResourceImpl;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.internal.util.EjbResourceImpl;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.internal.util.WebResourceImpl;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebProjectCreationOperationTest;

public class JEE5ModelTest
extends GeneralEMFPopulationTest {
    private static final String PROJECTNAME = "TestNewModels";

    public JEE5ModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(JEE5ModelTest.class);
    }

    protected Object primCreateAttributeValue(EAttribute att, EObject eObject) {
        if (att.getEAttributeType() == XMLTypePackage.eINSTANCE.getQName()) {
            return null;
        }
        return super.primCreateAttributeValue(att, eObject);
    }

    protected void setUp() throws Exception {
        super.setUp();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        RendererFactory.getDefaultRendererFactory().setValidating(false);
        if (workspace.getRoot().getProject(PROJECTNAME).isAccessible()) {
            return;
        }
        final IProjectDescription description = workspace.newProjectDescription(PROJECTNAME);
        description.setLocation(null);
        IHeadlessRunnableWithProgress op = new IHeadlessRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    JEE5ModelTest.this.createProject(description, workspace.getRoot().getProject(JEE5ModelTest.PROJECTNAME), monitor);
                }
                catch (OperationCanceledException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public void testEJBModel() throws Exception {
        EJBJar jar;
        String projName = "TestEE5EjbProject";
        this.createEjbProject(projName);
        EMFAttributeFeatureGenerator.reset();
        String modelPathURI = "META-INF/ejb-jar.xml";
        URI uri = URI.createURI((String)(String.valueOf(J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")) + "/" + modelPathURI));
        ProjectResourceSet resSet = this.getResourceSet(projName);
        EjbResourceImpl ejbRes = (EjbResourceImpl)resSet.getResource(uri, true);
        Assert.assertTrue((ejbRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (ejbRes.getContents().size() > 0) {
            jar = ejbRes.getEjbJar();
            this.populateRoot((EObject)((EObjectImpl)jar));
            ejbRes.save(null);
        }
        ejbRes.unload();
        ejbRes = (EjbResourceImpl)resSet.getResource(uri, true);
        Assert.assertTrue((ejbRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (ejbRes.getContents().size() > 0) {
            jar = ejbRes.getEjbJar();
            jar.getDescriptions();
        }
    }

    public void testAppClientModel() throws Exception {
        String projName = "TestEE5AppClientProject";
        this.createAppClientProject(projName);
        EMFAttributeFeatureGenerator.reset();
        String modelPathURI = "META-INF/application-client.xml";
        URI uri = URI.createURI((String)(String.valueOf(CreationConstants.DEFAULT_APPCLIENT_SOURCE_FOLDER) + "/" + modelPathURI));
        ProjectResourceSet resSet = this.getResourceSet(projName);
        ApplicationclientResourceImpl appClientRes = (ApplicationclientResourceImpl)resSet.getResource(uri, true);
        Assert.assertTrue((appClientRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (appClientRes.getContents().size() > 0) {
            ApplicationClient client = appClientRes.getApplicationClient();
            this.populateRoot((EObject)((EObjectImpl)client));
            appClientRes.save(null);
        }
    }

    public void testEarModel() throws Exception {
        String projName = "TestEE5EarProject";
        this.createEarProject(projName);
        EMFAttributeFeatureGenerator.reset();
        String modelPathURI = "META-INF/application.xml";
        URI uri = URI.createURI((String)(String.valueOf(J2EEPlugin.getDefault().getJ2EEPreferences().getString("earContent")) + "/" + modelPathURI));
        ProjectResourceSet resSet = this.getResourceSet(projName);
        ApplicationResourceImpl earRes = (ApplicationResourceImpl)resSet.getResource(uri, true);
        Assert.assertTrue((earRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (earRes.getContents().size() > 0) {
            Application ear = earRes.getApplication();
            this.populateRoot((EObject)((EObjectImpl)ear));
            earRes.save(null);
        }
    }

    public void testWarModel() throws Exception {
        String projName = "TestEE5WarProject";
        this.createWebProject(projName);
        EMFAttributeFeatureGenerator.reset();
        String modelPathURI = "WEB-INF/web.xml";
        URI uri = URI.createURI((String)(String.valueOf(J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent")) + "/" + modelPathURI));
        ProjectResourceSet resSet = this.getResourceSet(projName);
        WebResourceImpl webRes = (WebResourceImpl)resSet.getResource(uri, true);
        Assert.assertTrue((webRes.getContents().size() > 0 ? 1 : 0) != 0);
        if (webRes.getContents().size() > 0) {
            WebApp ear = webRes.getWebApp();
            this.populateRoot((EObject)((EObjectImpl)ear));
            webRes.save(null);
        }
    }

    private ProjectResourceSet getResourceSet(String projName) {
        IProject proj = this.getProject(projName);
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj);
    }

    private IProject createWebProject(String projName) throws ExecutionException {
        String webVersionString = J2EEVersionUtil.convertVersionIntToString((int)25);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(webVersionString);
        IDataModel dataModel = WebProjectCreationOperationTest.getWebDataModel(projName, null, null, null, null, webFacetVersion, true);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createEjbProject(String projName) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)30);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ejb");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject ejbProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return ejbProj;
    }

    private IProject createEarProject(String projName) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEarFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ear");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createAppClientProject(String projName) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.appclient");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, J2EEPlugin.getDefault().getJ2EEPreferences().getString("appClientContent")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    protected IDataModel setupJavaInstallAction(String aProjectName, String srcFolder) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
        String jVersion = "5.0";
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)jVersion);
        dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", srcFolder);
        return dm;
    }

    private void addWebProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion web25) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webmodel = (IDataModel)map.get((Object)"jst.web");
        webmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)web25);
        webmodel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
    }

    private void addVersionProperties(IDataModel dataModel, String projName, IProjectFacetVersion fv, String facetString) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel model = (IDataModel)map.get((Object)facetString);
        model.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        model.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)fv);
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
    }

    public IProject getProject(String projName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    private void registerFactory(URI uri, ResourceSet resSet, Resource.Factory factory) {
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), factory);
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }

    protected void tearDown() throws Exception {
    }
}

