/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.utility.verifiers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleImportDataModelVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilityImportDataModelVerifier
extends ModuleImportDataModelVerifier {
    @Override
    public void verify(IDataModel model) throws Exception {
    }

    @Override
    public void verify(IDataModel nestedArchiveImportModel, IArchive importedNestedArchive) throws Exception {
        super.verify(nestedArchiveImportModel, importedNestedArchive);
    }

    @Override
    protected int getExportType() {
        return -1;
    }

    @Override
    protected void verifyImportedResources(Collection<IArchiveResource> sourceResources, Collection<IArchiveResource> importedClassesResources, Collection<IArchiveResource> otherResources, Collection<IArchive> nestedArchives, IContainer rootFolder, IFolder importedClassesFolder) throws Exception {
        IPath resourcePath = null;
        IFile resourceFile = null;
        for (IArchiveResource sourceResource : sourceResources) {
            resourcePath = sourceResource.getPath();
            resourceFile = rootFolder.getFile(resourcePath);
            AssertWarn.warnTrue((String)("The file " + resourcePath + " should exist in the project in the " + rootFolder.getFullPath() + " directory"), (boolean)resourceFile.exists());
        }
        for (IArchiveResource importedClassResource : importedClassesResources) {
            resourcePath = importedClassResource.getPath();
            resourceFile = importedClassesFolder.getFile(resourcePath);
            if (resourceFile.exists()) continue;
            AssertWarn.warnTrue((String)("The imported class " + resourcePath + " should exist in the project in the " + importedClassesFolder.getFullPath() + " directory"), (boolean)resourceFile.exists());
        }
        for (IArchiveResource otherResource : otherResources) {
            resourcePath = otherResource.getPath();
            resourceFile = rootFolder.getFile(resourcePath);
            AssertWarn.warnTrue((String)("The resource " + resourcePath + " should exist in the project in the " + rootFolder.getFullPath() + " directory"), (boolean)resourceFile.exists());
        }
        Iterator<IArchive> iterator = nestedArchives.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }
}

