/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class NoSourceTestCase
extends TestCase {
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "test", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    private static boolean projectsCreated;

    protected void setUp() throws Exception {
        if (!projectsCreated) {
            ModuleHelper.importProject("PublishEARNoSource.zip", PROJECT_NAMES);
            ModuleHelper.buildIncremental();
            projectsCreated = true;
        }
    }

    protected IModule getModule(String project) throws Exception {
        return ModuleHelper.getModuleFromProject(project);
    }

    protected IEnterpriseApplication getEnterpriseApp(String project) throws Exception {
        return (IEnterpriseApplication)this.getModule(project).loadAdapter(IEnterpriseApplication.class, null);
    }

    protected IJ2EEModule getJ2EEModule(String project) throws Exception {
        return (IJ2EEModule)this.getModule(project).loadAdapter(IJ2EEModule.class, null);
    }

    protected IWebModule getWebModule(String project) throws Exception {
        return (IWebModule)this.getModule(project).loadAdapter(IWebModule.class, null);
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(NoSourceTestCase.class, (String)"deleteProjects"));
    }

    public void testNumJstEarModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void testNumJstWebModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void testNumJstEjbModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void testNumJstUtilModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)2);
    }

    public void testNumJstAppModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void testNumJstConnModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void testEARGetModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestEAR"));
    }

    public void testEARFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEAR"), "META-INF/application.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void testEARJarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEAR"), "PublishTestUtil2.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void testEARFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestEAR")), (int)4);
    }

    public void testEARFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestEAR")), (int)1);
    }

    public void testEARModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestEAR").getModuleType().getId(), (String)"jst.ear");
    }

    public void testEARGetApp() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getEnterpriseApp("PublishTestEAR"));
    }

    public void testEARResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getResourceFolders().length, (int)1);
    }

    public void testEARModules() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getModules().length, (int)6);
    }

    public void testEARAModuleNames() throws Exception {
        String[] s;
        IModule[] modules = this.getEnterpriseApp("PublishTestEAR").getModules();
        ArrayList<String> list = new ArrayList<String>(modules.length);
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            list.add(m.getName());
            ++n2;
        }
        String[] stringArray = s = new String[]{"PublishTestEJB", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
        int n3 = s.length;
        n = 0;
        while (n < n3) {
            String ss = stringArray[n];
            if (!list.contains(ss)) {
                NoSourceTestCase.fail((String)("EAR does not contain " + ss));
            }
            ++n;
        }
    }

    public void testUtilGetModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("test"));
    }

    public void testUtilFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtilFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test"), "test.properties")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtilClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test"), "publish/TestUtil.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtilFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("test")), (int)3);
    }

    public void testUtilFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("test")), (int)2);
    }

    public void testUtilModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("test").getModuleType().getId(), (String)"jst.utility");
    }

    public void testUtilJ2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getJ2EEModule("test"));
    }

    public void testUtilResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("test").getResourceFolders().length, (int)2);
    }

    public void testUtilJavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("test").getJavaOutputFolders().length, (int)1);
    }

    public void testUtilIsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getJ2EEModule("test").isBinary());
    }

    public void testUtil2Module() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("test2"));
    }

    public void testUtil2FileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test2"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtil2FileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test2"), "test.properties")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtil2ClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("test2"), "publish/TestUtil.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testUtil2FileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("test2")), (int)3);
    }

    public void testUtil2FolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("test2")), (int)2);
    }

    public void testUtil2ModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("test2").getModuleType().getId(), (String)"jst.utility");
    }

    public void testUtil2J2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getJ2EEModule("test2"));
    }

    public void testUtil2ResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("test2").getResourceFolders().length, (int)2);
    }

    public void testUtil2JavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("test2").getJavaOutputFolders().length, (int)1);
    }

    public void testUtil2IsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getJ2EEModule("test2").isBinary());
    }

    public void testEJBModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestEJB"));
    }

    public void testEJBFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testEJBFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "META-INF/ejb-jar.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void testEJBClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "ejbs/MyBeanLocalHome.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testEJBFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestEJB")), (int)7);
    }

    public void testEJBFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestEJB")), (int)2);
    }

    public void testEJBModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestEJB").getModuleType().getId(), (String)"jst.ejb");
    }

    public void testEJBJ2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestEJB"));
    }

    public void testEJBResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestEJB").getResourceFolders().length, (int)2);
    }

    public void testEJBJavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestEJB").getJavaOutputFolders().length, (int)1);
    }

    public void testEJBIsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestEJB").isBinary());
    }

    public void testConnector() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestConnector"));
    }

    public void testConnectorFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testConnectorFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "META-INF/ra.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void _testConnectorClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "test/MyOtherConnectorClass.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void _testConnectorFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestConnector")), (int)5);
    }

    public void _testConnectorFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestConnector")), (int)3);
    }

    public void testConnectorModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestConnector").getModuleType().getId(), (String)"jst.connector");
    }

    public void testConnectorJ2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestConnector"));
    }

    public void testConnectorResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestConnector").getResourceFolders().length, (int)1);
    }

    public void testConnectorJavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestConnector").getJavaOutputFolders().length, (int)1);
    }

    public void testConnectorIsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestConnector").isBinary());
    }

    public void testClientModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestClient"));
    }

    public void testClientFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testClientFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "META-INF/application-client.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void testClientClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "Main.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testClientClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "Main2.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void _testClientFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestClient")), (int)4);
    }

    public void testClientFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestClient")), (int)1);
    }

    public void testClientModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestClient").getModuleType().getId(), (String)"jst.appclient");
    }

    public void testClientJ2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestClient"));
    }

    public void testClientResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestClient").getResourceFolders().length, (int)2);
    }

    public void testClientJavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getJ2EEModule("PublishTestClient").getJavaOutputFolders().length, (int)1);
    }

    public void testClientIsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestClient").isBinary());
    }

    public void testWebModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestWeb"));
    }

    public void testWebFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWebWebXmlExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/web.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWebJSPExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "test.jsp")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWebClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/classes/servtest/TestServlet2.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWebClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/classes/servtest/TestServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWebJarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/lib/PublishTestUtil.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void _testWebFileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestWeb")), (int)6);
    }

    public void _testWebFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestWeb")), (int)5);
    }

    public void testWebModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestWeb").getModuleType().getId(), (String)"jst.web");
    }

    public void testWebJ2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getWebModule("PublishTestWeb"));
    }

    public void testWebResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getResourceFolders().length, (int)1);
    }

    public void testWebJavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getJavaOutputFolders().length, (int)1);
    }

    public void testWebGetModules() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getModules().length, (int)0);
    }

    public void testWebGetContextRoot() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getWebModule("PublishTestWeb").getContextRoot(), (String)"PublishTestWeb");
    }

    public void testWebIsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getWebModule("PublishTestWeb").isBinary());
    }

    public void testWeb2Module() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getModule("PublishTestWeb2"));
    }

    public void testWeb2FileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWeb2WebXmlExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/web.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWeb2JarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/lib/test.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWeb2ClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/classes/serv/AServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWeb2ClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/classes/serv/BServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void testWeb2FileCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestWeb2")), (int)5);
    }

    public void testWeb2FolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestWeb2")), (int)5);
    }

    public void testWeb2ModuleType() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getModule("PublishTestWeb2").getModuleType().getId(), (String)"jst.web");
    }

    public void testWeb2J2EEModule() throws Exception {
        NoSourceTestCase.assertNotNull((Object)this.getWebModule("PublishTestWeb2"));
    }

    public void testWeb2ResourceFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getResourceFolders().length, (int)1);
    }

    public void testWeb2JavaOutputFolderCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getJavaOutputFolders().length, (int)1);
    }

    public void testWeb2ModuleCount() throws Exception {
        NoSourceTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getModules().length, (int)1);
    }

    public void testWeb2GetModules() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getWebModule("PublishTestWeb2").getModules()[0].getName(), (String)"test");
    }

    public void testWeb2GetContextRoot() throws Exception {
        NoSourceTestCase.assertEquals((String)this.getWebModule("PublishTestWeb2").getContextRoot(), (String)"PublishTestWeb2");
    }

    public void testWeb2IsBinary() throws Exception {
        NoSourceTestCase.assertFalse((boolean)this.getWebModule("PublishTestWeb2").isBinary());
    }

    public void deleteProjects() throws Exception {
        String[] stringArray = PROJECT_NAMES;
        int n = PROJECT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            ModuleHelper.deleteProject(projectName);
            ++n2;
        }
    }
}

